/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.hdpath.HdKeyPath;
import com.github.chouheiwa.wallet.socket.bitlib.util.HexUtils;
import java.io.Serializable;

public class NetworkParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PROTOCOL_VERSION = 70002;
    public static final NetworkParameters testNetwork;
    public static final NetworkParameters productionNetwork;
    public static final NetworkParameters regtestNetwork;
    private static final byte[] TESTNET_GENESIS_BLOCK;
    private static final byte[] PRODNET_GENESIS_BLOCK;
    private static final byte[] REGTEST_GENESIS_BLOCK;
    private final String _blockchain_explorer_transaction;
    private final String _blockchain_explorer_address;
    private final HdKeyPath _bip44_coin_type;
    private int _standardAddressHeader;
    private int _multisigAddressHeader;
    private byte[] _genesisBlock;
    private final int _port;
    private final int _packetMagic;
    private final byte[] _packetMagicBytes;
    private final NetworkType _networkType;

    private NetworkParameters(NetworkType networkType) {
        this._networkType = networkType;
        if (networkType == NetworkType.PRODNET) {
            this._standardAddressHeader = 0;
            this._multisigAddressHeader = 5;
            this._genesisBlock = PRODNET_GENESIS_BLOCK;
            this._port = 8333;
            this._packetMagic = -104942375;
            this._packetMagicBytes = new byte[]{-7, -66, -76, -39};
            this._blockchain_explorer_address = "https://blockchain.info/address/";
            this._blockchain_explorer_transaction = "https://blockchain.info/tx/";
            this._bip44_coin_type = HdKeyPath.BIP44_PRODNET;
        } else if (networkType == NetworkType.TESTNET) {
            this._standardAddressHeader = 111;
            this._multisigAddressHeader = 196;
            this._genesisBlock = TESTNET_GENESIS_BLOCK;
            this._port = 18333;
            this._packetMagic = 185665799;
            this._packetMagicBytes = new byte[]{11, 17, 9, 7};
            this._blockchain_explorer_address = "http://tbtc.blockr.io/address/info/";
            this._blockchain_explorer_transaction = "http://tbtc.blockr.io/tx/info/";
            this._bip44_coin_type = HdKeyPath.BIP44_TESTNET;
        } else if (networkType == NetworkType.REGTEST) {
            this._standardAddressHeader = 111;
            this._multisigAddressHeader = 196;
            this._genesisBlock = REGTEST_GENESIS_BLOCK;
            this._port = 18444;
            this._packetMagic = -88099366;
            this._packetMagicBytes = new byte[]{-6, -65, -75, -38};
            this._blockchain_explorer_address = "(regtest)";
            this._blockchain_explorer_transaction = "(regtest)";
            this._bip44_coin_type = HdKeyPath.BIP44_TESTNET;
        } else {
            throw new RuntimeException("unknown network " + networkType.toString());
        }
    }

    public int getStandardAddressHeader() {
        return this._standardAddressHeader;
    }

    public int getMultisigAddressHeader() {
        return this._multisigAddressHeader;
    }

    public byte[] getGenesisBlock() {
        return this._genesisBlock;
    }

    public int getPort() {
        return this._port;
    }

    public NetworkType getNetworkType() {
        return this._networkType;
    }

    public int getPacketMagic() {
        return this._packetMagic;
    }

    public byte[] getPacketMagicBytes() {
        return this._packetMagicBytes;
    }

    public int hashCode() {
        return this._standardAddressHeader;
    }

    public boolean isProdnet() {
        return this.equals(productionNetwork);
    }

    public boolean isRegTest() {
        return this.equals(regtestNetwork);
    }

    public boolean isTestnet() {
        return this.equals(testNetwork);
    }

    public String getCoinName() {
        return this.isProdnet() ? "Bitcoin" : "Testnet";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NetworkParameters)) {
            return false;
        }
        NetworkParameters other = (NetworkParameters)obj;
        return other._standardAddressHeader == this._standardAddressHeader;
    }

    public String toString() {
        return this.isProdnet() ? "prodnet" : (this._networkType == NetworkType.REGTEST ? "regtest" : "testnet");
    }

    public HdKeyPath getBip44CoinType() {
        return this._bip44_coin_type;
    }

    static {
        TESTNET_GENESIS_BLOCK = HexUtils.toBytes("0100000043497fd7f826957108f4a30fd9cec3aeba79972084e90ead01ea330900000000bac8b0fa927c0ac8234287e33c5f74d38d354820e24756ad709d7038fc5f31f020e7494dffff001d03e4b6720101000000010000000000000000000000000000000000000000000000000000000000000000ffffffff0e0420e7494d017f062f503253482fffffffff0100f2052a010000002321021aeaf2f8638a129a3156fbe7e5ef635226b0bafd495ff03afe2c843d7e3a4b51ac00000000");
        PRODNET_GENESIS_BLOCK = HexUtils.toBytes("0100000000000000000000000000000000000000000000000000000000000000000000003ba3edfd7a7b12b27ac72c3e67768f617fc81bc3888a51323a9fb8aa4b1e5e4a29ab5f49ffff001d1dac2b7c0101000000010000000000000000000000000000000000000000000000000000000000000000ffffffff4d04ffff001d0104455468652054696d65732030332f4a616e2f32303039204368616e63656c6c6f72206f6e206272696e6b206f66207365636f6e64206261696c6f757420666f722062616e6b73ffffffff0100f2052a01000000434104678afdb0fe5548271967f1a67130b7105cd6a828e03909a67962e0ea1f61deb649f6bc3f4cef38c4f35504e51ec112de5c384df7ba0b8d578a4c702b6bf11d5fac00000000");
        REGTEST_GENESIS_BLOCK = HexUtils.toBytes("0100000000000000000000000000000000000000000000000000000000000000000000003ba3edfd7a7b12b27ac72c3e67768f617fc81bc3888a51323a9fb8aa4b1e5e4adae5494dffff7f20020000000101000000010000000000000000000000000000000000000000000000000000000000000000ffffffff4d04ffff001d0104455468652054696d65732030332f4a616e2f32303039204368616e63656c6c6f72206f6e206272696e6b206f66207365636f6e64206261696c6f757420666f722062616e6b73ffffffff0100f2052a01000000434104678afdb0fe5548271967f1a67130b7105cd6a828e03909a67962e0ea1f61deb649f6bc3f4cef38c4f35504e51ec112de5c384df7ba0b8d578a4c702b6bf11d5fac00000000");
        testNetwork = new NetworkParameters(NetworkType.TESTNET);
        productionNetwork = new NetworkParameters(NetworkType.PRODNET);
        regtestNetwork = new NetworkParameters(NetworkType.REGTEST);
    }

    private static enum NetworkType {
        PRODNET,
        TESTNET,
        REGTEST;

    }
}

