/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HexUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import java.io.Serializable;

public class OutPoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final OutPoint COINBASE_OUTPOINT = new OutPoint(Sha256Hash.ZERO_HASH, 0);
    public Sha256Hash hash;
    public int index;

    public OutPoint(Sha256Hash hash, int index) {
        this.hash = hash;
        this.index = index;
    }

    public OutPoint(ByteReader reader) throws ByteReader.InsufficientBytesException {
        this.hash = reader.getSha256Hash();
        this.index = (int)reader.getCompactInt();
    }

    public int hashCode() {
        return this.hash.hashCode() + this.index;
    }

    public boolean equals(Object other) {
        if (!(other instanceof OutPoint)) {
            return false;
        }
        return this.hash.equals(((OutPoint)other).hash) && this.index == ((OutPoint)other).index;
    }

    public String toString() {
        return String.valueOf(this.hash) + ':' + this.index;
    }

    public ByteWriter toByteWriter(ByteWriter writer) {
        writer.putSha256Hash(this.hash);
        writer.putCompactInt(this.index);
        return writer;
    }

    public static OutPoint fromString(String string) {
        try {
            if (string == null) {
                return null;
            }
            int colon = string.indexOf(58);
            if (colon == -1) {
                return null;
            }
            String txid = string.substring(0, colon);
            if (txid.length() != 64) {
                return null;
            }
            byte[] bytes = HexUtils.toBytes(txid);
            if (bytes == null) {
                return null;
            }
            String indexString = string.substring(colon + 1);
            int index = Integer.parseInt(indexString);
            return new OutPoint(new Sha256Hash(bytes), index);
        }
        catch (Exception e) {
            return null;
        }
    }
}

