/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutput;
import com.github.chouheiwa.wallet.socket.bitlib.model.TransactionOutput;
import com.google.common.base.Preconditions;
import java.util.ArrayList;

public class OutputList
extends ArrayList<TransactionOutput> {
    public boolean add(long value, ScriptOutput script) {
        Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0);
        return this.add(new TransactionOutput(value, script));
    }

    public long getTotalAmount() {
        long sum = 0L;
        for (TransactionOutput out : this) {
            sum += out.value;
        }
        return sum;
    }

    public OutputList newOutputsWithTotalAmount(Long amountToSend) {
        Preconditions.checkState((this.getTotalAmount() == 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((amountToSend >= 5460L ? 1 : 0) != 0);
        OutputList ret = new OutputList();
        long split = (long)Math.floor((double)amountToSend.longValue() / (double)this.size());
        if (split < 5460L) {
            ret.add(new TransactionOutput(amountToSend, ((TransactionOutput)this.get((int)0)).script));
        } else {
            long spentAmount = 0L;
            for (int idx = 0; idx < this.size() - 1; ++idx) {
                ret.add(new TransactionOutput(split, ((TransactionOutput)this.get((int)idx)).script));
                spentAmount += split;
            }
            ret.add(new TransactionOutput(amountToSend - spentAmount, ((TransactionOutput)this.get((int)(this.size() - 1))).script));
        }
        Preconditions.checkState((ret.getTotalAmount() == amountToSend.longValue() ? 1 : 0) != 0);
        return ret;
    }
}

