/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.HexUtils;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class Script
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int OP_FALSE = 0;
    public static final int OP_0 = 0;
    public static final int OP_PUSHDATA1 = 76;
    public static final int OP_PUSHDATA2 = 77;
    public static final int OP_PUSHDATA4 = 78;
    public static final int OP_1NEGATE = 79;
    public static final int OP_TRUE = 81;
    public static final int OP_2 = 82;
    public static final int OP_3 = 83;
    public static final int OP_4 = 84;
    public static final int OP_5 = 85;
    public static final int OP_6 = 86;
    public static final int OP_7 = 87;
    public static final int OP_8 = 88;
    public static final int OP_9 = 89;
    public static final int OP_10 = 90;
    public static final int OP_11 = 91;
    public static final int OP_12 = 92;
    public static final int OP_13 = 93;
    public static final int OP_14 = 94;
    public static final int OP_15 = 95;
    public static final int OP_16 = 96;
    public static final int OP_NOP = 97;
    public static final int OP_IF = 99;
    public static final int OP_VERIFY = 105;
    public static final int OP_RETURN = 106;
    public static final int OP_IFDUP = 115;
    public static final int OP_DEPTH = 116;
    public static final int OP_DROP = 117;
    public static final int OP_DUP = 118;
    public static final int OP_EQUAL = 135;
    public static final int OP_EQUALVERIFY = 136;
    public static final int OP_MIN = 163;
    public static final int OP_SHA256 = 168;
    public static final int OP_HASH160 = 169;
    public static final int OP_CHECKSIG = 172;
    public static final int OP_CHECKSIGVERIFY = 173;
    public static final int OP_CHECKMULTISIG = 174;
    public static final int OP_CHECKMULTISIGVERIFY = 175;
    public static final int OP_NOP1 = 176;
    public static final int OP_NOP2 = 177;
    public static final Map<Integer, String> OP_CODE_MAP = new HashMap<Integer, String>();
    protected byte[] _scriptBytes;
    private boolean _isCoinbase;

    protected Script(byte[] scriptBytes, boolean isCoinBase) {
        this._scriptBytes = scriptBytes;
        this._isCoinbase = isCoinBase;
    }

    public boolean isCoinBase() {
        return this._isCoinbase;
    }

    protected static boolean isOP(byte[] chunk, int op) {
        return chunk != null && chunk.length == 1 && (chunk[0] & 0xFF) == op;
    }

    public static int opToIntValue(byte[] chunk) {
        Preconditions.checkState((chunk.length == 1 ? 1 : 0) != 0);
        int opCode = chunk[0] & 0xFF;
        if (opCode > 80 && opCode < 97) {
            return opCode - 80;
        }
        return -1;
    }

    protected static byte[][] chunksFromScriptBytes(byte[] script) throws ScriptParsingException {
        try {
            ByteReader reader = new ByteReader(script);
            int numChunks = Script.countChunks(reader);
            if (numChunks == -1) {
                throw new ScriptParsingException(script);
            }
            byte[][] chunks = new byte[numChunks][];
            int index = 0;
            reader.reset();
            while (reader.available() > 0) {
                int size;
                int opcode = reader.get();
                if (opcode >= 240) {
                    opcode = opcode << 8 | reader.get() & 0xFF;
                }
                if (opcode > 0 && opcode < 76) {
                    chunks[index++] = reader.getBytes(opcode);
                    continue;
                }
                if (opcode == 76) {
                    size = reader.get() & 0xFF;
                    chunks[index++] = reader.getBytes(size);
                    continue;
                }
                if (opcode == 77) {
                    size = reader.getShortLE();
                    chunks[index++] = reader.getBytes(size);
                    continue;
                }
                if (opcode == 78) {
                    size = reader.getIntLE();
                    if (size < 0) {
                        throw new ScriptParsingException(script);
                    }
                    chunks[index++] = reader.getBytes(size);
                    continue;
                }
                chunks[index++] = new byte[]{(byte)opcode};
            }
            return chunks;
        }
        catch (ByteReader.InsufficientBytesException e) {
            throw new ScriptParsingException(script);
        }
    }

    private static int countChunks(ByteReader reader) throws ByteReader.InsufficientBytesException {
        int chunks = 0;
        while (reader.available() > 0) {
            int size;
            int opcode = reader.get();
            if (opcode >= 240) {
                opcode = opcode << 8 | reader.get() & 0xFF;
            }
            if (opcode > 0 && opcode < 76) {
                ++chunks;
                reader.skip(opcode);
                continue;
            }
            if (opcode == 76) {
                size = reader.get() & 0xFF;
                ++chunks;
                reader.skip(size);
                continue;
            }
            if (opcode == 77) {
                size = reader.getShortLE();
                ++chunks;
                reader.skip(size);
                continue;
            }
            if (opcode == 78) {
                size = reader.getIntLE();
                if (size < 0) {
                    return -1;
                }
                ++chunks;
                reader.skip(size);
                continue;
            }
            ++chunks;
        }
        return chunks;
    }

    public String dump(int maxLen) {
        String s = this.dump();
        if (s.length() > maxLen) {
            s = maxLen > 3 ? s.substring(0, maxLen - 3) + "..." : s.substring(0, maxLen);
        }
        return s;
    }

    public String dump() {
        byte[][] chunks;
        if (this._isCoinbase) {
            return HexUtils.toHex(this._scriptBytes);
        }
        StringBuilder sb = new StringBuilder();
        try {
            chunks = Script.chunksFromScriptBytes(this._scriptBytes);
        }
        catch (ScriptParsingException e) {
            return "Invalid script: " + HexUtils.toHex(this._scriptBytes);
        }
        for (byte[] chunk : chunks) {
            if (chunk.length == 1) {
                int opCode = chunk[0] & 0xFF;
                String opCodeString = OP_CODE_MAP.get(opCode);
                if (opCodeString == null) {
                    sb.append(opCode);
                } else {
                    sb.append(opCodeString);
                }
            } else {
                sb.append(HexUtils.toHex(chunk));
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    public byte[] getScriptBytes() {
        return this._scriptBytes;
    }

    protected static final byte[] scriptEncodeChunks(byte[][] chunks) {
        byte[] buf = new byte[Script.calculateByteSize(chunks)];
        int index = 0;
        for (byte[] chunk : chunks) {
            if (chunk.length == 1) {
                buf[index++] = chunk[0];
                continue;
            }
            if (chunk.length < 76) {
                buf[index++] = (byte)(0xFF & chunk.length);
                System.arraycopy(chunk, 0, buf, index, chunk.length);
                index += chunk.length;
                continue;
            }
            if (chunk.length < 256) {
                buf[index++] = 76;
                buf[index++] = (byte)(0xFF & chunk.length);
                System.arraycopy(chunk, 0, buf, index, chunk.length);
                index += chunk.length;
                continue;
            }
            if (chunk.length < 65536) {
                buf[index++] = 77;
                buf[index++] = (byte)(0xFF & chunk.length);
                buf[index++] = (byte)(0xFF & chunk.length >> 8);
                System.arraycopy(chunk, 0, buf, index, chunk.length);
                index += chunk.length;
                continue;
            }
            buf[index++] = 78;
            buf[index++] = (byte)(0xFF & chunk.length);
            buf[index++] = (byte)(0xFF & chunk.length >> 8);
            buf[index++] = (byte)(0xFF & chunk.length >> 16);
            buf[index++] = (byte)(0xFF & chunk.length >> 24);
            System.arraycopy(chunk, 0, buf, index, chunk.length);
            index += chunk.length;
        }
        return buf;
    }

    private static final int calculateByteSize(byte[][] chunks) {
        int size = 0;
        for (byte[] chunk : chunks) {
            if (chunk.length == 1) {
                ++size;
                continue;
            }
            if (chunk.length < 76) {
                size += 1 + chunk.length;
                continue;
            }
            if (chunk.length < 256) {
                size += 2 + chunk.length;
                continue;
            }
            if (chunk.length < 65536) {
                size += 3 + chunk.length;
                continue;
            }
            size += 5 + chunk.length;
        }
        return size;
    }

    static {
        OP_CODE_MAP.put(0, "OP_FALSE");
        OP_CODE_MAP.put(76, "OP_PUSHDATA1");
        OP_CODE_MAP.put(77, "OP_PUSHDATA2");
        OP_CODE_MAP.put(78, "OP_PUSHDATA4");
        OP_CODE_MAP.put(79, "OP_1NEGATE");
        OP_CODE_MAP.put(81, "OP_TRUE");
        OP_CODE_MAP.put(82, "OP_2");
        OP_CODE_MAP.put(83, "OP_3");
        OP_CODE_MAP.put(84, "OP_4");
        OP_CODE_MAP.put(85, "OP_5");
        OP_CODE_MAP.put(86, "OP_6");
        OP_CODE_MAP.put(87, "OP_7");
        OP_CODE_MAP.put(88, "OP_8");
        OP_CODE_MAP.put(89, "OP_3");
        OP_CODE_MAP.put(90, "OP_10");
        OP_CODE_MAP.put(91, "OP_11");
        OP_CODE_MAP.put(92, "OP_12");
        OP_CODE_MAP.put(93, "OP_13");
        OP_CODE_MAP.put(94, "OP_14");
        OP_CODE_MAP.put(95, "OP_15");
        OP_CODE_MAP.put(96, "OP_16");
        OP_CODE_MAP.put(97, "OP_NOP");
        OP_CODE_MAP.put(99, "OP_IF");
        OP_CODE_MAP.put(105, "OP_VERIFY");
        OP_CODE_MAP.put(106, "OP_RETURN");
        OP_CODE_MAP.put(115, "OP_IFDUP");
        OP_CODE_MAP.put(116, "OP_DEPTH");
        OP_CODE_MAP.put(117, "OP_DROP");
        OP_CODE_MAP.put(118, "OP_DUP");
        OP_CODE_MAP.put(135, "OP_EQUAL");
        OP_CODE_MAP.put(136, "OP_EQUALVERIFY");
        OP_CODE_MAP.put(163, "OP_MIN");
        OP_CODE_MAP.put(168, "OP_SHA256");
        OP_CODE_MAP.put(169, "OP_HASH160");
        OP_CODE_MAP.put(172, "OP_CHECKSIG");
        OP_CODE_MAP.put(173, "OP_CHECKSIGVERIFY");
        OP_CODE_MAP.put(174, "OP_CHECKMULTISIG");
        OP_CODE_MAP.put(175, "OP_CHECKMULTISIGVERIFY");
        OP_CODE_MAP.put(176, "OP_NOP1");
        OP_CODE_MAP.put(177, "OP_NOP2");
    }

    public static class ScriptParsingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ScriptParsingException(byte[] script) {
            super("Unable to parse script: " + HexUtils.toHex(script));
        }

        public ScriptParsingException(String message) {
            super(message);
        }
    }
}

