/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.Script;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInputP2SHMultisig;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInputPubKey;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInputStandard;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutput;

public class ScriptInput
extends Script {
    private static final long serialVersionUID = 1L;
    public static final ScriptInput EMPTY = new ScriptInput(new byte[0]);

    public static ScriptInput fromScriptBytes(byte[] scriptBytes) throws Script.ScriptParsingException {
        byte[][] chunks = ScriptInput.chunksFromScriptBytes(scriptBytes);
        if (ScriptInputStandard.isScriptInputStandard(chunks)) {
            return new ScriptInputStandard(chunks, scriptBytes);
        }
        if (ScriptInputPubKey.isScriptInputPubKey(chunks)) {
            return new ScriptInputPubKey(chunks, scriptBytes);
        }
        if (ScriptInputP2SHMultisig.isScriptInputP2SHMultisig(chunks)) {
            return new ScriptInputP2SHMultisig(chunks, scriptBytes);
        }
        return new ScriptInput(scriptBytes);
    }

    public static ScriptInput fromOutputScript(ScriptOutput output) {
        return new ScriptInput(output._scriptBytes);
    }

    public static ScriptInput fromP2SHOutputBytes(byte[] script) {
        return new ScriptInput(script);
    }

    protected ScriptInput(byte[] scriptBytes) {
        super(scriptBytes, false);
    }

    protected ScriptInput(byte[] script, boolean isCoinBase) {
        super(script, isCoinBase);
    }

    public byte[] getUnmalleableBytes() {
        return null;
    }
}

