/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signatures;
import com.github.chouheiwa.wallet.socket.bitlib.model.Script;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInput;
import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScriptInputP2SHMultisig
extends ScriptInput {
    private static final long serialVersionUID = 1L;
    private List<byte[]> _signatures;
    private int m;
    private int n;
    private List<byte[]> _pubKeys;
    private byte[] _scriptHash;
    private byte[] _embeddedScript;

    protected ScriptInputP2SHMultisig(byte[][] chunks, byte[] scriptBytes) throws Script.ScriptParsingException {
        super(scriptBytes);
        this._signatures = new ArrayList<byte[]>(chunks.length - 1);
        this._signatures.addAll(Arrays.asList(chunks).subList(1, chunks.length - 1));
        this._embeddedScript = chunks[chunks.length - 1];
        byte[][] scriptChunks = ScriptInputP2SHMultisig.chunksFromScriptBytes(this._embeddedScript);
        this._scriptHash = HashUtils.addressHash(chunks[chunks.length - 1]);
        this.m = ScriptInputP2SHMultisig.opToIntValue(scriptChunks[0]);
        this.n = ScriptInputP2SHMultisig.opToIntValue(scriptChunks[scriptChunks.length - 2]);
        this._pubKeys = new ArrayList<byte[]>(this.n);
        this._pubKeys.addAll(Arrays.asList(scriptChunks).subList(1, this.n + 1));
    }

    public List<byte[]> getPubKeys() {
        return new ArrayList<byte[]>(this._pubKeys);
    }

    public List<byte[]> getSignatures() {
        return new ArrayList<byte[]>(this._signatures);
    }

    public byte[] getScriptHash() {
        return BitUtils.copyByteArray(this._scriptHash);
    }

    public byte[] getEmbeddedScript() {
        return BitUtils.copyByteArray(this._embeddedScript);
    }

    protected static boolean isScriptInputP2SHMultisig(byte[][] chunks) throws Script.ScriptParsingException {
        byte[][] scriptChunks;
        if (chunks.length < 3) {
            return false;
        }
        try {
            scriptChunks = ScriptInputP2SHMultisig.chunksFromScriptBytes(chunks[chunks.length - 1]);
        }
        catch (Script.ScriptParsingException e) {
            return false;
        }
        if (scriptChunks.length < 4) {
            return false;
        }
        if (!ScriptInputP2SHMultisig.isOP(chunks[0], 0)) {
            return false;
        }
        if (!ScriptInputP2SHMultisig.isOP(scriptChunks[scriptChunks.length - 1], 174)) {
            return false;
        }
        if (scriptChunks[0].length != 1 || scriptChunks[scriptChunks.length - 2].length != 1) {
            return false;
        }
        try {
            int m = ScriptInputP2SHMultisig.opToIntValue(scriptChunks[0]);
            int n = ScriptInputP2SHMultisig.opToIntValue(scriptChunks[scriptChunks.length - 2]);
            if (n < 1 || n > 16) {
                return false;
            }
            if (m > n || m < 1 || m > 16) {
                return false;
            }
            if (n != scriptChunks.length - 3) {
                return false;
            }
        }
        catch (IllegalStateException ex) {
            return false;
        }
        return true;
    }

    public int getSigNumberNeeded() {
        return this.m;
    }

    @Override
    public byte[] getUnmalleableBytes() {
        ByteWriter writer = new ByteWriter(1024);
        for (byte[] sig : this._signatures) {
            byte[][] bytes = Signatures.decodeSignatureParameterBytes(new ByteReader(sig));
            if (bytes == null) {
                return null;
            }
            writer.putBytes(bytes[0]);
            writer.putBytes(bytes[1]);
        }
        return writer.toBytes();
    }
}

