/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signatures;
import com.github.chouheiwa.wallet.socket.bitlib.model.Script;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInput;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;

public class ScriptInputPubKey
extends ScriptInput {
    private static final long serialVersionUID = 1L;
    private byte[] _signature;

    protected ScriptInputPubKey(byte[][] chunks, byte[] scriptBytes) {
        super(scriptBytes);
        this._signature = chunks[0];
    }

    protected static boolean isScriptInputPubKey(byte[][] chunks) throws Script.ScriptParsingException {
        try {
            if (chunks.length != 1) {
                return false;
            }
            ByteReader reader = new ByteReader(chunks[0]);
            if ((reader.get() & 0xFF) != 48) {
                return false;
            }
            int length = reader.get() & 0xFF;
            if (reader.available() < length) {
                return false;
            }
            if ((reader.get() & 0xFF) != 2) {
                return false;
            }
            int length1 = reader.get() & 0xFF;
            if (reader.available() < length1) {
                return false;
            }
            reader.skip(length1);
            if ((reader.get() & 0xFF) != 2) {
                return false;
            }
            int length2 = reader.get() & 0xFF;
            if (reader.available() < length2) {
                return false;
            }
            reader.skip(length2);
            if (reader.available() != 1) {
                return false;
            }
            return (reader.get() & 0xFF) == 1;
        }
        catch (ByteReader.InsufficientBytesException e) {
            throw new Script.ScriptParsingException("Unable to parse " + ScriptInputPubKey.class.getSimpleName());
        }
    }

    public byte[] getSignature() {
        return this._signature;
    }

    @Override
    public byte[] getUnmalleableBytes() {
        byte[][] bytes = Signatures.decodeSignatureParameterBytes(new ByteReader(this._signature));
        if (bytes == null) {
            return null;
        }
        ByteWriter writer = new ByteWriter(bytes[0].length + bytes[1].length);
        writer.putBytes(bytes[0]);
        writer.putBytes(bytes[1]);
        return writer.toBytes();
    }
}

