/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signatures;
import com.github.chouheiwa.wallet.socket.bitlib.model.Script;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInput;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;

public class ScriptInputStandard
extends ScriptInput {
    private static final long serialVersionUID = 1L;
    private byte[] _signature;
    private byte[] _publicKeyBytes;

    public ScriptInputStandard(byte[] signature, byte[] publicKeyBytes) {
        super(ScriptInputStandard.scriptEncodeChunks(new byte[][]{signature, publicKeyBytes}));
        this._signature = signature;
        this._publicKeyBytes = publicKeyBytes;
    }

    protected ScriptInputStandard(byte[][] chunks, byte[] scriptBytes) {
        super(scriptBytes);
        this._signature = chunks[0];
        this._publicKeyBytes = chunks[1];
    }

    protected static boolean isScriptInputStandard(byte[][] chunks) throws Script.ScriptParsingException {
        try {
            if (chunks.length != 2) {
                return false;
            }
            if (chunks[0].length < 6) {
                return false;
            }
            ByteReader reader = new ByteReader(chunks[0]);
            if ((reader.get() & 0xFF) != 48) {
                return false;
            }
            int length = reader.get() & 0xFF;
            if ((reader.get() & 0xFF) != 2) {
                return false;
            }
            int length1 = reader.get() & 0xFF;
            reader.skip(length1);
            if ((reader.get() & 0xFF) != 2) {
                return false;
            }
            int length2 = reader.get() & 0xFF;
            reader.skip(length2);
            if (2 + length1 + 2 + length2 != length) {
                return false;
            }
            return reader.available() == 1;
        }
        catch (ByteReader.InsufficientBytesException e) {
            throw new Script.ScriptParsingException("Unable to parse " + ScriptInputStandard.class.getSimpleName());
        }
    }

    public byte[] getSignature() {
        return this._signature;
    }

    public int getHashType() {
        return this._signature[this._signature.length - 1] & 0xFF;
    }

    public byte[] getPublicKeyBytes() {
        return this._publicKeyBytes;
    }

    @Override
    public byte[] getUnmalleableBytes() {
        byte[][] bytes = Signatures.decodeSignatureParameterBytes(new ByteReader(this._signature));
        if (bytes == null) {
            return null;
        }
        ByteWriter writer = new ByteWriter(bytes[0].length + bytes[1].length);
        writer.putBytes(bytes[0]);
        writer.putBytes(bytes[1]);
        return writer.toBytes();
    }
}

