/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.model.Script;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutputError;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutputMsg;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutputOpReturn;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutputP2SH;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutputPubkey;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutputStandard;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutputStrange;

public abstract class ScriptOutput
extends Script {
    private static final long serialVersionUID = 1L;

    public static ScriptOutput fromScriptBytes(byte[] scriptBytes) {
        byte[][] chunks;
        try {
            chunks = ScriptOutput.chunksFromScriptBytes(scriptBytes);
        }
        catch (Script.ScriptParsingException e) {
            return new ScriptOutputError(scriptBytes);
        }
        if (chunks == null) {
            return null;
        }
        if (ScriptOutputStandard.isScriptOutputStandard(chunks)) {
            return new ScriptOutputStandard(chunks, scriptBytes);
        }
        if (ScriptOutputPubkey.isScriptOutputPubkey(chunks)) {
            return new ScriptOutputPubkey(chunks, scriptBytes);
        }
        if (ScriptOutputP2SH.isScriptOutputP2SH(chunks)) {
            return new ScriptOutputP2SH(chunks, scriptBytes);
        }
        if (ScriptOutputMsg.isScriptOutputMsg(chunks)) {
            return new ScriptOutputMsg(chunks, scriptBytes);
        }
        if (ScriptOutputOpReturn.isScriptOutputOpReturn(chunks)) {
            return new ScriptOutputOpReturn(chunks, scriptBytes);
        }
        return new ScriptOutputStrange(chunks, scriptBytes);
    }

    protected ScriptOutput(byte[] scriptBytes) {
        super(scriptBytes, false);
    }

    public abstract Address getAddress(NetworkParameters var1);
}

