/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.model.Script;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutput;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ScriptOutputMsg
extends ScriptOutput
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] _messageBytes;
    private byte[] _publicKeyBytes;

    protected ScriptOutputMsg(byte[][] chunks, byte[] scriptBytes) {
        super(scriptBytes);
        this._messageBytes = chunks[0];
        this._publicKeyBytes = chunks[2];
    }

    protected static boolean isScriptOutputMsg(byte[][] chunks) {
        if (chunks.length != 4) {
            return false;
        }
        if (!Script.isOP(chunks[1], 117)) {
            return false;
        }
        return Script.isOP(chunks[3], 172);
    }

    public byte[] getMessageBytes() {
        return this._messageBytes;
    }

    public String getMessage() {
        try {
            return new String(this.getMessageBytes(), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public byte[] getPublicKeyBytes() {
        return this._publicKeyBytes;
    }

    @Override
    public Address getAddress(NetworkParameters network) {
        byte[] addressBytes = HashUtils.addressHash(this.getPublicKeyBytes());
        return Address.fromStandardBytes(addressBytes, network);
    }
}

