/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutput;
import java.io.Serializable;

public class ScriptOutputP2SH
extends ScriptOutput
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] _p2shAddressBytes;

    protected ScriptOutputP2SH(byte[][] chunks, byte[] scriptBytes) {
        super(scriptBytes);
        this._p2shAddressBytes = chunks[1];
    }

    protected static boolean isScriptOutputP2SH(byte[][] chunks) {
        if (chunks.length != 3) {
            return false;
        }
        if (!ScriptOutputP2SH.isOP(chunks[0], 169)) {
            return false;
        }
        if (chunks[1].length != 20) {
            return false;
        }
        return ScriptOutputP2SH.isOP(chunks[2], 135);
    }

    public ScriptOutputP2SH(byte[] addressBytes) {
        super(ScriptOutputP2SH.scriptEncodeChunks(new byte[][]{{-87}, addressBytes, {-121}}));
        this._p2shAddressBytes = addressBytes;
    }

    public byte[] getP2SHAddressBytes() {
        return this._p2shAddressBytes;
    }

    @Override
    public Address getAddress(NetworkParameters network) {
        byte[] addressBytes = this.getP2SHAddressBytes();
        return Address.fromP2SHBytes(addressBytes, network);
    }
}

