/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutput;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import java.io.Serializable;

public class ScriptOutputPubkey
extends ScriptOutput
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] _publicKeyBytes;

    protected ScriptOutputPubkey(byte[][] chunks, byte[] scriptBytes) {
        super(scriptBytes);
        this._publicKeyBytes = chunks[0];
    }

    protected static boolean isScriptOutputPubkey(byte[][] chunks) {
        if (chunks.length != 2) {
            return false;
        }
        return ScriptOutputPubkey.isOP(chunks[1], 172);
    }

    public byte[] getPublicKeyBytes() {
        return this._publicKeyBytes;
    }

    @Override
    public Address getAddress(NetworkParameters network) {
        byte[] addressBytes = HashUtils.addressHash(this.getPublicKeyBytes());
        return Address.fromStandardBytes(addressBytes, network);
    }
}

