/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutput;
import java.io.Serializable;

public class ScriptOutputStandard
extends ScriptOutput
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] _addressBytes;

    protected ScriptOutputStandard(byte[][] chunks, byte[] scriptBytes) {
        super(scriptBytes);
        this._addressBytes = chunks[2];
    }

    protected static boolean isScriptOutputStandard(byte[][] chunks) {
        if (chunks.length != 5 && chunks.length != 6) {
            return false;
        }
        if (!ScriptOutputStandard.isOP(chunks[0], 118)) {
            return false;
        }
        if (!ScriptOutputStandard.isOP(chunks[1], 169)) {
            return false;
        }
        if (chunks[2].length != 20) {
            return false;
        }
        if (!ScriptOutputStandard.isOP(chunks[3], 136)) {
            return false;
        }
        if (!ScriptOutputStandard.isOP(chunks[4], 172)) {
            return false;
        }
        return chunks.length != 6 || ScriptOutputStandard.isOP(chunks[5], 97);
    }

    public ScriptOutputStandard(byte[] addressBytes) {
        super(ScriptOutputStandard.scriptEncodeChunks(new byte[][]{{118}, {-87}, addressBytes, {-120}, {-84}}));
        this._addressBytes = addressBytes;
    }

    public byte[] getAddressBytes() {
        return this._addressBytes;
    }

    @Override
    public Address getAddress(NetworkParameters network) {
        return Address.fromStandardBytes(this.getAddressBytes(), network);
    }
}

