/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.OutPoint;
import com.github.chouheiwa.wallet.socket.bitlib.model.Script;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class SourcedTransactionOutput
implements Serializable {
    private static final long serialVersionUID = 1L;
    public OutPoint outPoint;
    public long value;
    public Address address;
    public Set<Address> senders;
    public byte[] script;

    public SourcedTransactionOutput(ByteReader reader) throws ByteReader.InsufficientBytesException, Script.ScriptParsingException {
        this.outPoint = new OutPoint(reader);
        this.value = reader.getLongLE();
        this.address = new Address(reader.getBytes(21));
        int numSenders = reader.getIntLE();
        this.senders = new HashSet<Address>();
        for (int i = 0; i < numSenders; ++i) {
            this.senders.add(new Address(reader.getBytes(21)));
        }
        int scriptLength = reader.getIntLE();
        this.script = reader.getBytes(scriptLength);
    }

    public SourcedTransactionOutput(OutPoint outPoint, long value, Address address2, Set<Address> senders, byte[] script) {
        this.outPoint = outPoint;
        this.value = value;
        this.address = address2;
        this.senders = senders;
        this.script = script;
    }

    public byte[] toBytes() {
        ByteWriter writer = new ByteWriter(1024);
        this.toByteWriter(writer);
        return writer.toBytes();
    }

    public void toByteWriter(ByteWriter writer) {
        this.outPoint.toByteWriter(writer);
        writer.putLongLE(this.value);
        writer.putBytes(this.address.getAllAddressBytes());
        writer.putIntLE(this.senders.size());
        for (Address sender : this.senders) {
            writer.putBytes(sender.getAllAddressBytes());
        }
        writer.putIntLE(this.script.length);
        writer.putBytes(this.script);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("outPoint:").append(this.outPoint).append(" value: ").append(this.value).append(" receiver: ").append(this.address).append(" senders: ").append(this.senders).append(" scriptLength: ").append(this.script.length);
        return sb.toString();
    }

    public int hashCode() {
        return this.outPoint.hash.hashCode() + this.outPoint.index;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SourcedTransactionOutput)) {
            return false;
        }
        SourcedTransactionOutput other = (SourcedTransactionOutput)obj;
        return this.outPoint.equals(other.outPoint);
    }
}

