/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.StandardTransactionBuilder;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInput;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInputCoinbase;
import com.github.chouheiwa.wallet.socket.bitlib.model.TransactionInput;
import com.github.chouheiwa.wallet.socket.bitlib.model.TransactionOutput;
import com.github.chouheiwa.wallet.socket.bitlib.model.UnspentTransactionOutput;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import com.google.common.primitives.UnsignedInteger;
import java.io.Serializable;

public class Transaction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long ONE_uBTC_IN_SATOSHIS = 100L;
    private static final long ONE_mBTC_IN_SATOSHIS = 100000L;
    public static final long MAX_MINER_FEE_PER_KB = 20000000L;
    public int version;
    public final TransactionInput[] inputs;
    public final TransactionOutput[] outputs;
    public int lockTime;
    private Sha256Hash _hash;
    private Sha256Hash _unmalleableHash;
    private transient Boolean _rbfAble = null;
    private transient int _txSize = -1;

    public static Transaction fromUnsignedTransaction(StandardTransactionBuilder.UnsignedTransaction unsignedTransaction) {
        TransactionInput[] input = new TransactionInput[unsignedTransaction.getFundingOutputs().length];
        int idx = 0;
        for (UnspentTransactionOutput u : unsignedTransaction.getFundingOutputs()) {
            input[idx++] = new TransactionInput(u.outPoint, new ScriptInput(u.script.getScriptBytes()));
        }
        return new Transaction(1, input, unsignedTransaction.getOutputs(), 0);
    }

    public static Transaction fromBytes(byte[] transaction2) throws TransactionParsingException {
        return Transaction.fromByteReader(new ByteReader(transaction2));
    }

    public static Transaction fromByteReader(ByteReader reader) throws TransactionParsingException {
        return Transaction.fromByteReader(reader, null);
    }

    public static Transaction fromByteReader(ByteReader reader, Sha256Hash knownTransactionHash) throws TransactionParsingException {
        int size = reader.available();
        try {
            int version = reader.getIntLE();
            int numInputs = (int)reader.getCompactInt();
            TransactionInput[] inputs = new TransactionInput[numInputs];
            for (int i = 0; i < numInputs; ++i) {
                try {
                    inputs[i] = TransactionInput.fromByteReader(reader);
                    continue;
                }
                catch (TransactionInput.TransactionInputParsingException e) {
                    throw new TransactionParsingException("Unable to parse transaction input at index " + i + ": " + e.getMessage(), e);
                }
                catch (IllegalStateException e) {
                    throw new TransactionParsingException("ISE - Unable to parse transaction input at index " + i + ": " + e.getMessage(), e);
                }
            }
            int numOutputs = (int)reader.getCompactInt();
            TransactionOutput[] outputs = new TransactionOutput[numOutputs];
            for (int i = 0; i < numOutputs; ++i) {
                try {
                    outputs[i] = TransactionOutput.fromByteReader(reader);
                    continue;
                }
                catch (TransactionOutput.TransactionOutputParsingException e) {
                    throw new TransactionParsingException("Unable to parse transaction output at index " + i + ": " + e.getMessage());
                }
            }
            int lockTime = reader.getIntLE();
            return new Transaction(version, inputs, outputs, lockTime, size, knownTransactionHash);
        }
        catch (ByteReader.InsufficientBytesException e) {
            throw new TransactionParsingException(e.getMessage());
        }
    }

    public Transaction copy() {
        try {
            return Transaction.fromByteReader(new ByteReader(this.toBytes()));
        }
        catch (TransactionParsingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toBytes() {
        ByteWriter writer = new ByteWriter(1024);
        this.toByteWriter(writer);
        return writer.toBytes();
    }

    public int getTxRawSize() {
        if (this._txSize == -1) {
            this._txSize = this.toBytes().length;
        }
        return this._txSize;
    }

    public void toByteWriter(ByteWriter writer) {
        writer.putIntLE(this.version);
        writer.putCompactInt(this.inputs.length);
        for (TransactionInput transactionInput : this.inputs) {
            transactionInput.toByteWriter(writer);
        }
        writer.putCompactInt(this.outputs.length);
        for (Serializable serializable : this.outputs) {
            ((TransactionOutput)serializable).toByteWriter(writer);
        }
        writer.putIntLE(this.lockTime);
    }

    public Transaction(int version, TransactionInput[] inputs, TransactionOutput[] outputs, int lockTime) {
        this(version, inputs, outputs, lockTime, -1);
    }

    private Transaction(int version, TransactionInput[] inputs, TransactionOutput[] outputs, int lockTime, int txSize) {
        this.version = version;
        this.inputs = inputs;
        this.outputs = outputs;
        this.lockTime = lockTime;
        this._txSize = txSize;
    }

    public Transaction(Transaction copyFrom) {
        this.version = copyFrom.version;
        this.inputs = copyFrom.inputs;
        this.outputs = copyFrom.outputs;
        this.lockTime = copyFrom.lockTime;
        this._txSize = copyFrom._txSize;
        this._hash = copyFrom._hash;
    }

    protected Transaction(int version, TransactionInput[] inputs, TransactionOutput[] outputs, int lockTime, int txSize, Sha256Hash knownTransactionHash) {
        this(version, inputs, outputs, lockTime, txSize);
        this._hash = knownTransactionHash;
    }

    public Sha256Hash getHash() {
        if (this._hash == null) {
            ByteWriter writer = new ByteWriter(2000);
            this.toByteWriter(writer);
            this._hash = HashUtils.doubleSha256(writer.toBytes()).reverse();
        }
        return this._hash;
    }

    public UnsignedInteger getMinSequenceNumber() {
        UnsignedInteger minVal = UnsignedInteger.MAX_VALUE;
        for (TransactionInput input : this.inputs) {
            UnsignedInteger nSequence = UnsignedInteger.fromIntBits((int)input.sequence);
            if (nSequence.compareTo(minVal) >= 0) continue;
            minVal = nSequence;
        }
        return minVal;
    }

    public boolean isRbfAble() {
        if (this._rbfAble == null) {
            this._rbfAble = this.getMinSequenceNumber().compareTo(UnsignedInteger.MAX_VALUE.minus(UnsignedInteger.ONE)) < 0;
        }
        return this._rbfAble;
    }

    public Sha256Hash getUnmalleableHash() {
        if (this._unmalleableHash == null) {
            ByteWriter writer = new ByteWriter(2000);
            for (TransactionInput i : this.inputs) {
                byte[] bytes = i.getUnmalleableBytes();
                if (bytes == null) {
                    return null;
                }
                writer.putBytes(bytes);
            }
            this._unmalleableHash = HashUtils.doubleSha256(writer.toBytes()).reverse();
        }
        return this._unmalleableHash;
    }

    public String toString() {
        return String.valueOf(this.getHash()) + " in: " + this.inputs.length + " out: " + this.outputs.length;
    }

    public int hashCode() {
        return this.getHash().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Transaction)) {
            return false;
        }
        return this.getHash().equals(((Transaction)other).getHash());
    }

    public boolean isCoinbase() {
        for (TransactionInput in : this.inputs) {
            if (!(in.script instanceof ScriptInputCoinbase)) continue;
            return true;
        }
        return false;
    }

    public static class TransactionParsingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TransactionParsingException(String message) {
            super(message);
        }

        public TransactionParsingException(String message, Exception e) {
            super(message, e);
        }
    }
}

