/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.OutPoint;
import com.github.chouheiwa.wallet.socket.bitlib.model.Script;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInput;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInputCoinbase;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HexUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import java.io.Serializable;

public class TransactionInput
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long SEQUENCE_NO_RBF = 0xFFFFFFFEL;
    private static final int NO_SEQUENCE = -1;
    public OutPoint outPoint;
    public ScriptInput script;
    public int sequence;

    public static TransactionInput fromByteReader(ByteReader reader) throws TransactionInputParsingException {
        try {
            ScriptInput inscript;
            Sha256Hash outPointHash = reader.getSha256Hash().reverse();
            int outPointIndex = reader.getIntLE();
            int scriptSize = (int)reader.getCompactInt();
            byte[] script = reader.getBytes(scriptSize);
            int sequence = reader.getIntLE();
            OutPoint outPoint = new OutPoint(outPointHash, outPointIndex);
            if (outPointHash.equals(Sha256Hash.ZERO_HASH)) {
                inscript = new ScriptInputCoinbase(script);
            } else {
                try {
                    inscript = ScriptInput.fromScriptBytes(script);
                }
                catch (Script.ScriptParsingException e) {
                    throw new TransactionInputParsingException(e.getMessage(), (Exception)e);
                }
            }
            return new TransactionInput(outPoint, inscript, sequence);
        }
        catch (ByteReader.InsufficientBytesException e) {
            throw new TransactionInputParsingException("Unable to parse transaction input: " + e.getMessage());
        }
    }

    public TransactionInput(OutPoint outPoint, ScriptInput script, int sequence) {
        this.outPoint = outPoint;
        this.script = script;
        this.sequence = sequence;
    }

    public TransactionInput(OutPoint outPoint, ScriptInput script) {
        this(outPoint, script, -1);
    }

    public ScriptInput getScript() {
        return this.script;
    }

    public boolean isMarkedForRbf() {
        return ((long)this.sequence & 0xFFFFFFFFL) < 0xFFFFFFFEL;
    }

    public void toByteWriter(ByteWriter writer) {
        writer.putSha256Hash(this.outPoint.hash, true);
        writer.putIntLE(this.outPoint.index);
        byte[] script = this.getScript().getScriptBytes();
        writer.putCompactInt(script.length);
        writer.putBytes(script);
        writer.putIntLE(this.sequence);
    }

    public byte[] getUnmalleableBytes() {
        byte[] scriptBytes = this.script.getUnmalleableBytes();
        if (scriptBytes == null) {
            return null;
        }
        ByteWriter writer = new ByteWriter(36 + scriptBytes.length + 4);
        writer.putSha256Hash(this.outPoint.hash, true);
        writer.putIntLE(this.outPoint.index);
        writer.putBytes(scriptBytes);
        writer.putIntLE(this.sequence);
        return writer.toBytes();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("outpoint: ").append(this.outPoint.hash).append(':').append(this.outPoint.index);
        sb.append(" scriptSize: ").append(this.script.getScriptBytes().length);
        return sb.toString();
    }

    public int hashCode() {
        return this.outPoint.hash.hashCode() + this.outPoint.index;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TransactionInput)) {
            return false;
        }
        TransactionInput otherInput = (TransactionInput)other;
        return this.outPoint.equals(otherInput.outPoint);
    }

    public static class TransactionInputParsingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TransactionInputParsingException(byte[] script) {
            this(script, null);
        }

        public TransactionInputParsingException(byte[] script, Exception e) {
            super("Unable to parse transaction input: " + HexUtils.toHex(script), e);
        }

        public TransactionInputParsingException(String message) {
            this(message, null);
        }

        public TransactionInputParsingException(String message, Exception e) {
            super(message, e);
        }
    }
}

