/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutput;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HexUtils;
import java.io.Serializable;

public class TransactionOutput
implements Serializable {
    private static final long serialVersionUID = 1L;
    public long value;
    public ScriptOutput script;

    public static TransactionOutput fromByteReader(ByteReader reader) throws TransactionOutputParsingException {
        try {
            long value = reader.getLongLE();
            int scriptSize = (int)reader.getCompactInt();
            byte[] scriptBytes = reader.getBytes(scriptSize);
            ScriptOutput script = ScriptOutput.fromScriptBytes(scriptBytes);
            return new TransactionOutput(value, script);
        }
        catch (ByteReader.InsufficientBytesException e) {
            throw new TransactionOutputParsingException("Unable to parse transaction output: " + e.getMessage());
        }
    }

    public TransactionOutput(long value, ScriptOutput script) {
        this.value = value;
        this.script = script;
    }

    public byte[] toBytes() {
        ByteWriter writer = new ByteWriter(1024);
        this.toByteWriter(writer);
        return writer.toBytes();
    }

    public void toByteWriter(ByteWriter writer) {
        writer.putLongLE(this.value);
        byte[] scriptBytes = this.script.getScriptBytes();
        writer.putCompactInt(scriptBytes.length);
        writer.putBytes(scriptBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("value: ").append(this.value).append(" script: ").append(this.script.dump());
        return sb.toString();
    }

    public static class TransactionOutputParsingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TransactionOutputParsingException(byte[] script) {
            super("Unable to parse transaction output: " + HexUtils.toHex(script));
        }

        public TransactionOutputParsingException(String message) {
            super(message);
        }
    }
}

