/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.OutPoint;
import com.github.chouheiwa.wallet.socket.bitlib.model.Script;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutput;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import java.io.Serializable;

public class UnspentTransactionOutput
implements Serializable {
    private static final long serialVersionUID = 1L;
    public OutPoint outPoint;
    public int height;
    public long value;
    public ScriptOutput script;

    public UnspentTransactionOutput(ByteReader reader) throws ByteReader.InsufficientBytesException, Script.ScriptParsingException {
        this.outPoint = new OutPoint(reader);
        this.height = reader.getIntLE();
        this.value = reader.getLongLE();
        int scriptSize = (int)reader.getCompactInt();
        byte[] scriptBytes = reader.getBytes(scriptSize);
        this.script = ScriptOutput.fromScriptBytes(scriptBytes);
    }

    public UnspentTransactionOutput(OutPoint outPoint, int height, long value, ScriptOutput script) {
        this.outPoint = outPoint;
        this.height = height;
        this.value = value;
        this.script = script;
    }

    public byte[] toBytes() {
        ByteWriter writer = new ByteWriter(1024);
        this.toByteWriter(writer);
        return writer.toBytes();
    }

    public void toByteWriter(ByteWriter writer) {
        this.outPoint.toByteWriter(writer);
        writer.putIntLE(this.height);
        writer.putLongLE(this.value);
        byte[] scriptBytes = this.script.getScriptBytes();
        writer.putCompactInt(scriptBytes.length);
        writer.putBytes(scriptBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("outPoint:").append(this.outPoint).append(" height:").append(this.height).append(" value: ").append(this.value).append(" script: ").append(this.script.dump());
        return sb.toString();
    }

    public int hashCode() {
        return this.outPoint.hash.hashCode() + this.outPoint.index;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnspentTransactionOutput)) {
            return false;
        }
        UnspentTransactionOutput other = (UnspentTransactionOutput)obj;
        return this.outPoint.equals(other.outPoint);
    }
}

