/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model.hdpath;

import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.model.hdpath.Bip44Account;
import com.github.chouheiwa.wallet.socket.bitlib.model.hdpath.Bip44Purpose;
import com.github.chouheiwa.wallet.socket.bitlib.model.hdpath.HdKeyPath;
import com.google.common.base.Optional;
import com.google.common.primitives.UnsignedInteger;

public class Bip44CoinType
extends Bip44Purpose {
    public Bip44CoinType(Bip44Purpose parent, UnsignedInteger index, boolean hardened) {
        super(parent, index, hardened);
    }

    public Bip44Account getAccount(UnsignedInteger id) {
        return new Bip44Account(this, id, true);
    }

    public Bip44Account getAccount(int id) {
        return new Bip44Account(this, UnsignedInteger.valueOf((long)id), true);
    }

    public boolean isTestnet() {
        Optional<Bip44CoinType> coinType = this.findPartOf(Bip44CoinType.class);
        if (coinType.isPresent()) {
            return ((Bip44CoinType)coinType.get()).index.intValue() == 1;
        }
        throw new RuntimeException("No cointype present");
    }

    public NetworkParameters getNetworkparameter() {
        if (this.isTestnet()) {
            return NetworkParameters.testNetwork;
        }
        return NetworkParameters.productionNetwork;
    }

    @Override
    protected HdKeyPath knownChildFactory(UnsignedInteger index, boolean hardened) {
        if (hardened) {
            return new Bip44Account(this, index, true);
        }
        return new HdKeyPath(this, index, hardened);
    }
}

