/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model.hdpath;

import com.github.chouheiwa.wallet.socket.bitlib.model.hdpath.Bip44CoinType;
import com.github.chouheiwa.wallet.socket.bitlib.model.hdpath.Bip44Purpose;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.primitives.UnsignedInteger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HdKeyPath
implements Serializable {
    public static final String HARDENED_MARKER = "'";
    private final HdKeyPath parent;
    protected final UnsignedInteger index;
    private final boolean hardened;
    public static final HdKeyPath ROOT = new HdKeyPath();
    public static final Bip44Purpose BIP44 = ROOT.getBip44Purpose();
    public static final HdKeyPath BIP32_ROOT = ROOT.getHardenedChild(0);
    public static final Bip44CoinType BIP44_TESTNET = BIP44.getCoinTypeBitcoinTestnet();
    public static final Bip44CoinType BIP44_PRODNET = BIP44.getCoinTypeBitcoin();

    public static HdKeyPath valueOf(String path) {
        Iterator<String> iterator = Splitter.on((String)"/").split((CharSequence)path).iterator();
        Preconditions.checkState((boolean)"m".equals(iterator.next()));
        return ROOT.getChild(iterator);
    }

    public HdKeyPath getChild(String path) {
        Iterator<String> iterator = Splitter.on((String)"/").split((CharSequence)path).iterator();
        return this.getChild(iterator);
    }

    private HdKeyPath getChild(Iterator<String> path) {
        if (!path.hasNext()) {
            return this;
        }
        String ak = path.next();
        int index = Integer.valueOf(ak.replace(HARDENED_MARKER, ""));
        if (ak.endsWith(HARDENED_MARKER)) {
            return this.getHardenedChild(index).getChild(path);
        }
        return this.getNonHardenedChild(index).getChild(path);
    }

    public <T extends HdKeyPath> Optional<T> findPartOf(Class<T> ofClass) {
        HdKeyPath ak = this;
        while (ak.parent != null && !ak.getClass().equals(ofClass)) {
            ak = ak.parent;
        }
        if (ak.getClass().equals(ofClass)) {
            return Optional.of((Object)ak);
        }
        return Optional.absent();
    }

    public HdKeyPath(HdKeyPath parent, UnsignedInteger index, boolean hardened) {
        this.parent = parent;
        this.hardened = hardened;
        this.index = index;
    }

    private HdKeyPath() {
        this.parent = null;
        this.index = UnsignedInteger.ZERO;
        this.hardened = true;
    }

    public boolean isHardened() {
        return this.hardened;
    }

    private HdKeyPath getChild(int index) {
        boolean hardened = index < 0;
        int value = index & Integer.MAX_VALUE;
        return hardened ? this.getHardenedChild(value) : this.getNonHardenedChild(value);
    }

    public HdKeyPath getNonHardenedChild(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        return this.knownChildFactory(UnsignedInteger.valueOf((long)index), false);
    }

    public HdKeyPath getHardenedChild(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        return this.knownChildFactory(UnsignedInteger.valueOf((long)index), true);
    }

    protected HdKeyPath knownChildFactory(UnsignedInteger index, boolean hardened) {
        if (index.equals((Object)UnsignedInteger.valueOf((long)44L)) && hardened) {
            return new Bip44Purpose(this, index, true);
        }
        return new HdKeyPath(this, index, hardened);
    }

    public Bip44Purpose getBip44Purpose() {
        return new Bip44Purpose(this, UnsignedInteger.valueOf((long)44L), true);
    }

    private int getValue() {
        return this.index.intValue() | (this.isHardened() ? Integer.MIN_VALUE : 0);
    }

    public List<Integer> getAddressN() {
        ArrayList<Integer> ret = new ArrayList<Integer>(10);
        HdKeyPath ak = this;
        while (ak.parent != null) {
            ret.add(0, ak.getValue());
            ak = ak.parent;
        }
        return ret;
    }

    public String toString() {
        if (this.parent == null) {
            return "m";
        }
        return this.parent.toString() + "/" + this.index + (this.isHardened() ? HARDENED_MARKER : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HdKeyPath)) {
            return false;
        }
        HdKeyPath hdKeyPath = (HdKeyPath)o;
        if (this.hardened != hdKeyPath.hardened) {
            return false;
        }
        if (!this.index.equals((Object)hdKeyPath.index)) {
            return false;
        }
        return this.parent.equals(hdKeyPath.parent);
    }

    public int hashCode() {
        int result = this.parent.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + (this.hardened ? 1 : 0);
        return result;
    }

    public int getLastRawIndex() {
        return this.getValue();
    }

    public int getLastIndex() {
        return this.index.intValue();
    }
}

