/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.PublicKey;
import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.hdpath.HdKeyPath;
import com.github.chouheiwa.wallet.socket.bitlib.util.HexUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BitlibJsonModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private static final Map<Class<?>, JsonDeserializer<?>> DESERIALIZERS = new HashMap();
    private static final List<JsonSerializer<?>> SERIALIZERS;

    public BitlibJsonModule() {
        super("BitLibJsonModule", Version.unknownVersion(), DESERIALIZERS, SERIALIZERS);
    }

    static {
        DESERIALIZERS.put(Address.class, new AddressDeserializer());
        DESERIALIZERS.put(PublicKey.class, new PublicKeyDeserializer());
        DESERIALIZERS.put(HdKeyPath.class, new HdKeyPathDeserializer());
        DESERIALIZERS.put(HdKeyPath.class, new Sha256HashDeserializer());
        SERIALIZERS = new ArrayList();
        SERIALIZERS.add(new AddressSerializer());
        SERIALIZERS.add(new PublicKeySerializer());
        SERIALIZERS.add(new HdKeyPathSerializer());
        SERIALIZERS.add(new Sha256HashSerializer());
    }

    private static class HdKeyPathSerializer
    extends JsonSerializer<HdKeyPath> {
        private HdKeyPathSerializer() {
        }

        public void serialize(HdKeyPath value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }

        public Class<HdKeyPath> handledType() {
            return HdKeyPath.class;
        }
    }

    private static class HdKeyPathDeserializer
    extends JsonDeserializer<HdKeyPath> {
        private HdKeyPathDeserializer() {
        }

        public HdKeyPath deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return HdKeyPath.valueOf(jp.getValueAsString());
        }
    }

    private static class PublicKeySerializer
    extends JsonSerializer<PublicKey> {
        private PublicKeySerializer() {
        }

        public void serialize(PublicKey value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(HexUtils.toHex(value.getPublicKeyBytes()));
        }

        public Class<PublicKey> handledType() {
            return PublicKey.class;
        }
    }

    private static class PublicKeyDeserializer
    extends JsonDeserializer<PublicKey> {
        private PublicKeyDeserializer() {
        }

        public PublicKey deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            byte[] pubKeyBytes;
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            try {
                pubKeyBytes = HexUtils.toBytes(node.asText());
            }
            catch (RuntimeException e) {
                throw new JsonParseException("Failed to convert string '" + node.asText() + "' into an public key bytes", JsonLocation.NA);
            }
            return new PublicKey(pubKeyBytes);
        }
    }

    private static class AddressSerializer
    extends JsonSerializer<Address> {
        private AddressSerializer() {
        }

        public void serialize(Address value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.toString());
        }

        public Class<Address> handledType() {
            return Address.class;
        }
    }

    private static class AddressDeserializer
    extends JsonDeserializer<Address> {
        private AddressDeserializer() {
        }

        public Address deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            Address address2 = Address.fromString(node.asText());
            if (address2 == null) {
                throw new JsonParseException("Failed to convert string '" + node.asText() + "' into an address", JsonLocation.NA);
            }
            return address2;
        }
    }

    private static class Sha256HashSerializer
    extends JsonSerializer<Sha256Hash> {
        private Sha256HashSerializer() {
        }

        public void serialize(Sha256Hash value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.toString());
        }

        public Class<Sha256Hash> handledType() {
            return Sha256Hash.class;
        }
    }

    private static class Sha256HashDeserializer
    extends JsonDeserializer<Sha256Hash> {
        private Sha256HashDeserializer() {
        }

        public Sha256Hash deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            Sha256Hash hash = Sha256Hash.fromString(node.asText());
            if (hash == null) {
                throw new JsonParseException("Failed to convert string '" + node.asText() + "' into a Sha256 hash", JsonLocation.NA);
            }
            return hash;
        }
    }
}

