/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.util;

import com.github.chouheiwa.wallet.socket.bitlib.model.CompactInt;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;

public class ByteReader {
    private byte[] _buf;
    private int _index;

    public ByteReader(byte[] buf) {
        this._buf = buf;
        this._index = 0;
    }

    public ByteReader(byte[] buf, int index) {
        this._buf = buf;
        this._index = index;
    }

    public byte get() throws InsufficientBytesException {
        this.checkAvailable(1);
        return this._buf[this._index++];
    }

    public boolean getBoolean() throws InsufficientBytesException {
        return this.get() != 0;
    }

    public int getShortLE() throws InsufficientBytesException {
        this.checkAvailable(2);
        return ((this._buf[this._index++] & 0xFF) << 0 | (this._buf[this._index++] & 0xFF) << 8) & 0xFFFF;
    }

    public int getIntLE() throws InsufficientBytesException {
        this.checkAvailable(4);
        return (this._buf[this._index++] & 0xFF) << 0 | (this._buf[this._index++] & 0xFF) << 8 | (this._buf[this._index++] & 0xFF) << 16 | (this._buf[this._index++] & 0xFF) << 24;
    }

    public int getIntBE() throws InsufficientBytesException {
        this.checkAvailable(4);
        return (this._buf[this._index++] & 0xFF) << 24 | (this._buf[this._index++] & 0xFF) << 16 | (this._buf[this._index++] & 0xFF) << 8 | (this._buf[this._index++] & 0xFF) << 0;
    }

    public long getLongLE() throws InsufficientBytesException {
        this.checkAvailable(8);
        return ((long)this._buf[this._index++] & 0xFFL) << 0 | ((long)this._buf[this._index++] & 0xFFL) << 8 | ((long)this._buf[this._index++] & 0xFFL) << 16 | ((long)this._buf[this._index++] & 0xFFL) << 24 | ((long)this._buf[this._index++] & 0xFFL) << 32 | ((long)this._buf[this._index++] & 0xFFL) << 40 | ((long)this._buf[this._index++] & 0xFFL) << 48 | ((long)this._buf[this._index++] & 0xFFL) << 56;
    }

    public byte[] getBytes(int size) throws InsufficientBytesException {
        this.checkAvailable(size);
        byte[] bytes = new byte[size];
        System.arraycopy(this._buf, this._index, bytes, 0, size);
        this._index += size;
        return bytes;
    }

    public String getString() throws InsufficientBytesException {
        int length = this.getIntLE();
        byte[] bytes = this.getBytes(length);
        return new String(bytes);
    }

    public void skip(int num) throws InsufficientBytesException {
        this.checkAvailable(num);
        this._index += num;
    }

    public void reset() {
        this._index = 0;
    }

    public long getCompactInt() throws InsufficientBytesException {
        return CompactInt.fromByteReader(this);
    }

    public Sha256Hash getSha256Hash() throws InsufficientBytesException {
        this.checkAvailable(32);
        return Sha256Hash.of(this.getBytes(32));
    }

    public int getPosition() {
        return this._index;
    }

    public void setPosition(int index) {
        this._index = index;
    }

    public final int available() {
        return this._buf.length - this._index;
    }

    private final void checkAvailable(int num) throws InsufficientBytesException {
        if (this._buf.length - this._index < num) {
            throw new InsufficientBytesException();
        }
    }

    public static class InsufficientBytesException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

