/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.util;

import com.github.chouheiwa.wallet.socket.bitlib.model.CompactInt;
import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import java.io.UnsupportedEncodingException;

public final class ByteWriter {
    private byte[] _buf;
    private int _index;

    public ByteWriter(int capacity) {
        this._buf = new byte[capacity];
        this._index = 0;
    }

    public ByteWriter(byte[] buf) {
        this._buf = buf;
        this._index = buf.length;
    }

    private final void ensureCapacity(int capacity) {
        if (this._buf.length - this._index < capacity) {
            byte[] temp = new byte[this._buf.length * 2 + capacity];
            System.arraycopy(this._buf, 0, temp, 0, this._index);
            this._buf = temp;
        }
    }

    public void put(byte b) {
        this.ensureCapacity(1);
        this._buf[this._index++] = b;
    }

    public void putBoolean(boolean b) {
        this.put(b ? (byte)1 : 0);
    }

    public void putShortLE(short value) {
        this.ensureCapacity(2);
        this._buf[this._index++] = (byte)(0xFF & value >> 0);
        this._buf[this._index++] = (byte)(0xFF & value >> 8);
    }

    public void putIntLE(int value) {
        this.ensureCapacity(4);
        this._buf[this._index++] = (byte)(0xFF & value >> 0);
        this._buf[this._index++] = (byte)(0xFF & value >> 8);
        this._buf[this._index++] = (byte)(0xFF & value >> 16);
        this._buf[this._index++] = (byte)(0xFF & value >> 24);
    }

    public void putIntBE(int value) {
        this.ensureCapacity(4);
        this._buf[this._index++] = (byte)(0xFF & value >> 24);
        this._buf[this._index++] = (byte)(0xFF & value >> 16);
        this._buf[this._index++] = (byte)(0xFF & value >> 8);
        this._buf[this._index++] = (byte)(0xFF & value >> 0);
    }

    public void putLongLE(long value) {
        this.ensureCapacity(8);
        this._buf[this._index++] = (byte)(0xFFL & value >> 0);
        this._buf[this._index++] = (byte)(0xFFL & value >> 8);
        this._buf[this._index++] = (byte)(0xFFL & value >> 16);
        this._buf[this._index++] = (byte)(0xFFL & value >> 24);
        this._buf[this._index++] = (byte)(0xFFL & value >> 32);
        this._buf[this._index++] = (byte)(0xFFL & value >> 40);
        this._buf[this._index++] = (byte)(0xFFL & value >> 48);
        this._buf[this._index++] = (byte)(0xFFL & value >> 56);
    }

    public void putLongBE(long value) {
        this.ensureCapacity(8);
        this._buf[this._index++] = (byte)(0xFFL & value >> 56);
        this._buf[this._index++] = (byte)(0xFFL & value >> 48);
        this._buf[this._index++] = (byte)(0xFFL & value >> 40);
        this._buf[this._index++] = (byte)(0xFFL & value >> 32);
        this._buf[this._index++] = (byte)(0xFFL & value >> 24);
        this._buf[this._index++] = (byte)(0xFFL & value >> 16);
        this._buf[this._index++] = (byte)(0xFFL & value >> 8);
        this._buf[this._index++] = (byte)(0xFFL & value >> 0);
    }

    public void putBytes(byte[] value) {
        this.ensureCapacity(value.length);
        System.arraycopy(value, 0, this._buf, this._index, value.length);
        this._index += value.length;
    }

    public void putBytes(byte[] value, int offset, int length) {
        this.ensureCapacity(length);
        System.arraycopy(value, offset, this._buf, this._index, length);
        this._index += length;
    }

    public void putCompactInt(long value) {
        this.putBytes(CompactInt.toBytes(value));
    }

    public void putSha256Hash(Sha256Hash hash) {
        this.putBytes(hash.getBytes());
    }

    public void putSha256Hash(Sha256Hash hash, boolean reverse) {
        if (reverse) {
            this.putBytes(BitUtils.reverseBytes(hash.getBytes()));
        } else {
            this.putBytes(hash.getBytes());
        }
    }

    public void putString(String s) {
        byte[] bytes = s.getBytes();
        this.putIntLE(bytes.length);
        this.putBytes(bytes);
    }

    public void putRawStringUtf8(String s) {
        try {
            byte[] bytes = s.getBytes("UTF-8");
            this.putBytes(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[this._index];
        System.arraycopy(this._buf, 0, bytes, 0, this._index);
        return bytes;
    }

    public int length() {
        return this._index;
    }
}

