/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.util;

import com.github.chouheiwa.wallet.socket.megiontechnologies.Bitcoins;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;

public class CoinUtil {
    private static final BigDecimal BTC_IN_SATOSHIS = new BigDecimal(100000000);
    private static final BigDecimal mBTC_IN_SATOSHIS = new BigDecimal(100000);
    private static final BigDecimal uBTC_IN_SATOSHIS = new BigDecimal(100);
    private static final BigDecimal BITS_IN_SATOSHIS = new BigDecimal(100);
    private static final DecimalFormat COIN_FORMAT = new DecimalFormat();
    public static final BigInteger BTC;
    private static HashMap<Integer, DecimalFormat> formatCache;

    public static String valueString(long value, boolean withThousandSeparator) {
        return CoinUtil.valueString(value, Denomination.BTC, withThousandSeparator);
    }

    public static String valueString(long value, Denomination denomination, boolean withThousandSeparator) {
        BigDecimal d = BigDecimal.valueOf(value);
        d = d.divide(denomination.getOneUnitInSatoshis());
        if (!withThousandSeparator) {
            return d.toPlainString();
        }
        return COIN_FORMAT.format(d);
    }

    public static String valueString(BigDecimal value, Denomination denomination, boolean withThousandSeparator) {
        Long satoshis = Bitcoins.nearestValue(value).getLongValue();
        return CoinUtil.valueString((long)satoshis, denomination, withThousandSeparator);
    }

    public static String valueString(long value, Denomination denomination, int precision) {
        BigDecimal d = BigDecimal.valueOf(value);
        d = d.divide(denomination.getOneUnitInSatoshis());
        if (!formatCache.containsKey(precision)) {
            DecimalFormat coinFormat = (DecimalFormat)COIN_FORMAT.clone();
            coinFormat.setMaximumFractionDigits(precision);
            formatCache.put(precision, coinFormat);
        }
        return formatCache.get(precision).format(d);
    }

    public static String fullValueString(long value) {
        return CoinUtil.fullValueString(value, Denomination.BTC);
    }

    public static String fullValueString(long value, Denomination denomination) {
        BigDecimal d = BigDecimal.valueOf(value);
        d = d.movePointLeft(denomination.getDecimalPlaces());
        return d.toPlainString();
    }

    static /* synthetic */ BigDecimal access$000() {
        return BTC_IN_SATOSHIS;
    }

    static /* synthetic */ BigDecimal access$100() {
        return mBTC_IN_SATOSHIS;
    }

    static /* synthetic */ BigDecimal access$200() {
        return uBTC_IN_SATOSHIS;
    }

    static /* synthetic */ BigDecimal access$300() {
        return BITS_IN_SATOSHIS;
    }

    static {
        COIN_FORMAT.setGroupingSize(3);
        COIN_FORMAT.setGroupingUsed(true);
        COIN_FORMAT.setMaximumFractionDigits(8);
        DecimalFormatSymbols symbols = COIN_FORMAT.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(' ');
        COIN_FORMAT.setDecimalFormatSymbols(symbols);
        BTC = new BigInteger("100000000", 10);
        formatCache = new HashMap(2);
    }

    public static enum Denomination {
        BTC(8, "BTC", "BTC", CoinUtil.access$000()),
        mBTC(5, "mBTC", "mBTC", CoinUtil.access$100()),
        uBTC(2, "uBTC", "\u00b5BTC", CoinUtil.access$200()),
        BITS(2, "bits", "bits", CoinUtil.access$300());

        private final int _decimalPlaces;
        private final String _asciiString;
        private final String _unicodeString;
        private final BigDecimal _oneUnitInSatoshis;

        private Denomination(int decimalPlaces, String asciiString, String unicodeString, BigDecimal oneUnitInSatoshis) {
            this._decimalPlaces = decimalPlaces;
            this._asciiString = asciiString;
            this._unicodeString = unicodeString;
            this._oneUnitInSatoshis = oneUnitInSatoshis;
        }

        public int getDecimalPlaces() {
            return this._decimalPlaces;
        }

        public String getAsciiName() {
            return this._asciiString;
        }

        public String getUnicodeName() {
            return this._unicodeString;
        }

        public BigDecimal getOneUnitInSatoshis() {
            return this._oneUnitInSatoshis;
        }

        public String toString() {
            return this._asciiString;
        }

        public static Denomination fromString(String string) {
            if (string == null) {
                return BTC;
            }
            if (string.equals("BTC")) {
                return BTC;
            }
            if (string.equals("mBTC")) {
                return mBTC;
            }
            if (string.equals("uBTC")) {
                return uBTC;
            }
            if (string.equals("bits")) {
                return BITS;
            }
            return BTC;
        }
    }
}

