/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.util;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.digest.RIPEMD160Digest;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha512Hash;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    private static final String SHA256 = "SHA-256";
    private static final String SHA512 = "SHA-512";

    public static Sha256Hash sha256(byte[] data) {
        MessageDigest digest = HashUtils.getSha256Digest();
        digest.update(data, 0, data.length);
        return Sha256Hash.of(digest.digest());
    }

    public static Sha256Hash sha256(byte[] data1, byte[] data2) {
        MessageDigest digest = HashUtils.getSha256Digest();
        digest.update(data1, 0, data1.length);
        digest.update(data2, 0, data2.length);
        return new Sha256Hash(digest.digest());
    }

    private static MessageDigest getSha256Digest() {
        try {
            return MessageDigest.getInstance(SHA256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static Sha256Hash doubleSha256(byte[] data) {
        return HashUtils.doubleSha256(data, 0, data.length);
    }

    public static Sha256Hash doubleSha256TwoBuffers(byte[] data1, byte[] data2) {
        MessageDigest digest = HashUtils.getSha256Digest();
        digest.update(data1, 0, data1.length);
        digest.update(data2, 0, data2.length);
        return new Sha256Hash(digest.digest(digest.digest()));
    }

    public static Sha256Hash doubleSha256(byte[] data, int offset, int length) {
        MessageDigest digest = HashUtils.getSha256Digest();
        digest.update(data, offset, length);
        return new Sha256Hash(digest.digest(digest.digest()));
    }

    public static Sha512Hash sha512(byte[] data) {
        MessageDigest digest = HashUtils.getSha512Digest();
        digest.update(data, 0, data.length);
        return Sha512Hash.of(digest.digest());
    }

    public static Sha256Hash sha256(byte[] data, int offset, int length) {
        MessageDigest digest = HashUtils.getSha256Digest();
        digest.update(data, offset, length);
        return new Sha256Hash(digest.digest());
    }

    public static Sha512Hash sha512(byte[] data1, byte[] data2) {
        MessageDigest digest = HashUtils.getSha512Digest();
        digest.update(data1, 0, data1.length);
        digest.update(data2, 0, data2.length);
        return new Sha512Hash(digest.digest());
    }

    private static MessageDigest getSha512Digest() {
        try {
            return MessageDigest.getInstance(SHA512);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] addressHash(byte[] pubkeyBytes) {
        byte[] sha256 = HashUtils.getSha256Digest().digest(pubkeyBytes);
        byte[] out = new byte[20];
        RIPEMD160Digest ripeMD160 = new RIPEMD160Digest();
        ripeMD160.update(sha256, 0, sha256.length);
        ripeMD160.doFinal(out, 0);
        return out;
    }
}

