/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.util;

import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.HexUtils;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;

public class Sha256Hash
implements Serializable,
Comparable<Sha256Hash> {
    private static final long serialVersionUID = 1L;
    public static final int HASH_LENGTH = 32;
    public static final Sha256Hash ZERO_HASH = Sha256Hash.of(new byte[32]);
    private final byte[] _bytes;
    private int _hash;

    public Sha256Hash(byte[] bytes) {
        Preconditions.checkArgument((bytes.length == 32 ? 1 : 0) != 0);
        this._bytes = bytes;
        this._hash = -1;
    }

    public static Sha256Hash fromString(String hexString) {
        try {
            byte[] b = HexUtils.toBytes(hexString);
            if (b.length != 32) {
                return null;
            }
            return new Sha256Hash(b);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Sha256Hash of(byte[] bytes) {
        return new Sha256Hash(bytes);
    }

    public static Sha256Hash copyOf(byte[] bytes, int offset) {
        return new Sha256Hash(bytes, offset);
    }

    private Sha256Hash(byte[] bytes, int offset) {
        this._bytes = new byte[32];
        System.arraycopy(bytes, offset, this._bytes, 0, 32);
        this._hash = -1;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Sha256Hash)) {
            return false;
        }
        return Arrays.equals(this._bytes, ((Sha256Hash)other)._bytes);
    }

    public int hashCode() {
        if (this._hash == -1) {
            int offset = this._bytes.length - 4;
            this._hash = 0;
            for (int i = 0; i < 4; ++i) {
                this._hash <<= 8;
                this._hash |= this._bytes[offset + i] & 0xFF;
            }
        }
        return this._hash;
    }

    public String toString() {
        return this.toHex();
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    @Override
    public int compareTo(Sha256Hash o) {
        for (int i = 0; i < 32; ++i) {
            byte myByte = this._bytes[i];
            byte otherByte = o._bytes[i];
            int compare = Ints.compare((int)myByte, (int)otherByte);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public Sha256Hash reverse() {
        return new Sha256Hash(BitUtils.reverseBytes(this._bytes));
    }

    public int length() {
        return 32;
    }

    public BigInteger toPositiveBigInteger() {
        return new BigInteger(1, this._bytes);
    }

    public boolean startsWith(byte[] checksum) {
        Preconditions.checkArgument((checksum.length < 32 ? 1 : 0) != 0);
        int checksumLength = checksum.length;
        for (int i = 0; i < checksumLength; ++i) {
            if (this._bytes[i] == checksum[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] firstFourBytes() {
        byte[] ret = new byte[4];
        System.arraycopy(this._bytes, 0, ret, 0, 4);
        return ret;
    }

    public byte[] firstNBytes(int n) {
        byte[] ret = new byte[n];
        System.arraycopy(this._bytes, 0, ret, 0, n);
        return ret;
    }

    public String toHex() {
        return HexUtils.toHex(this._bytes);
    }
}

