/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.util;

import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.HexUtils;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;

public class Sha512Hash
implements Serializable,
Comparable<Sha512Hash> {
    private static final long serialVersionUID = 1L;
    public static final int HASH_LENGTH = 64;
    public static final Sha512Hash ZERO_HASH = Sha512Hash.of(new byte[64]);
    private final byte[] _bytes;
    private int _hash;

    public Sha512Hash(byte[] bytes) {
        Preconditions.checkArgument((bytes.length == 64 ? 1 : 0) != 0);
        this._bytes = bytes;
        this._hash = -1;
    }

    public static Sha512Hash of(byte[] bytes) {
        return new Sha512Hash(bytes);
    }

    public static Sha512Hash copyOf(byte[] bytes, int offset) {
        return new Sha512Hash(bytes, offset);
    }

    private Sha512Hash(byte[] bytes, int offset) {
        this._bytes = new byte[64];
        System.arraycopy(bytes, offset, this._bytes, 0, 64);
        this._hash = -1;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Sha512Hash)) {
            return false;
        }
        return Arrays.equals(this._bytes, ((Sha512Hash)other)._bytes);
    }

    public int hashCode() {
        if (this._hash == -1) {
            int offset = this._bytes.length - 4;
            this._hash = 0;
            for (int i = 0; i < 4; ++i) {
                this._hash <<= 8;
                this._hash |= this._bytes[offset + i] & 0xFF;
            }
        }
        return this._hash;
    }

    public String toString() {
        return this.toHex();
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    @Override
    public int compareTo(Sha512Hash o) {
        for (int i = 0; i < 64; ++i) {
            byte myByte = this._bytes[i];
            byte otherByte = o._bytes[i];
            int compare = Ints.compare((int)myByte, (int)otherByte);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public Sha512Hash reverse() {
        return new Sha512Hash(BitUtils.reverseBytes(this._bytes));
    }

    public int length() {
        return 64;
    }

    public BigInteger toPositiveBigInteger() {
        return new BigInteger(1, this._bytes);
    }

    public boolean startsWith(byte[] checksum) {
        Preconditions.checkArgument((checksum.length < 64 ? 1 : 0) != 0);
        int checksumLength = checksum.length;
        for (int i = 0; i < checksumLength; ++i) {
            if (this._bytes[i] == checksum[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] firstFourBytes() {
        byte[] ret = new byte[4];
        System.arraycopy(this._bytes, 0, ret, 0, 4);
        return ret;
    }

    public String toHex() {
        return HexUtils.toHex(this._bytes);
    }
}

