/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.util;

import com.github.chouheiwa.wallet.socket.bitlib.util.HexUtils;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SslUtils {
    private static final Map<String, SSLSocketFactory> _sslSocketFactories = new HashMap<String, SSLSocketFactory>();
    public static final HostnameVerifier HOST_NAME_VERIFIER_ACCEPT_ALL = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    public static final SSLSocketFactory SSL_SOCKET_FACTORY_ACCEPT_ALL;

    public static synchronized SSLSocketFactory getSsLSocketFactory(String certificateThumbprint) {
        SSLSocketFactory factory = _sslSocketFactories.get(certificateThumbprint);
        if (factory == null) {
            factory = SslUtils.createSslSocketFactory(certificateThumbprint);
            _sslSocketFactories.put(certificateThumbprint, factory);
        }
        return factory;
    }

    private static SSLSocketFactory createSslSocketFactory(final String certificateThumbprint) {
        TrustManager[] trustOneCert = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                throw new CertificateException();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                if (certs == null || certs.length == 0) {
                    throw new CertificateException();
                }
                for (X509Certificate certificate : certs) {
                    String sslThumbprint = SslUtils.generateCertificateThumbprint(certificate);
                    if (!certificateThumbprint.equalsIgnoreCase(sslThumbprint)) continue;
                    return;
                }
                String providedCerts = "";
                for (X509Certificate certificate : certs) {
                    providedCerts = providedCerts + " " + SslUtils.generateCertificateThumbprint(certificate);
                }
                throw new CertificateException("Not expected certificate: " + providedCerts + " but expected: " + certificateThumbprint);
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustOneCert, null);
            return sc.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void configureTrustedCertificate(URLConnection connection, String serverThumbprint) {
        if (!(connection instanceof HttpsURLConnection)) {
            return;
        }
        HttpsURLConnection httpsUrlConnection = (HttpsURLConnection)connection;
        if (httpsUrlConnection.getHostnameVerifier() != HOST_NAME_VERIFIER_ACCEPT_ALL) {
            httpsUrlConnection.setHostnameVerifier(HOST_NAME_VERIFIER_ACCEPT_ALL);
        }
        SSLSocketFactory sslSocketFactory = SslUtils.getSsLSocketFactory(serverThumbprint);
        if (httpsUrlConnection.getSSLSocketFactory() != sslSocketFactory) {
            httpsUrlConnection.setSSLSocketFactory(sslSocketFactory);
        }
    }

    private static String generateCertificateThumbprint(Certificate certificate) {
        try {
            byte[] encoded;
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            try {
                encoded = certificate.getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
            return HexUtils.toHex(md.digest(encoded), ":");
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        TrustManager[] trustOneCert = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustOneCert, null);
            SSL_SOCKET_FACTORY_ACCEPT_ALL = sc.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

