/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.chain;

import com.github.chouheiwa.wallet.socket.asset;
import com.github.chouheiwa.wallet.socket.chain.asset_object;
import com.github.chouheiwa.wallet.socket.chain.object_id;
import com.github.chouheiwa.wallet.socket.chain.operations;
import com.github.chouheiwa.wallet.socket.chain.price;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.List;

public class fee_schedule {
    public static final int MAX_FEE_STABILIZATION_ITERATION = 4;
    private List<fee_parameters> parameters;
    private int scale = 10000;

    public asset calculate_fee(operations.operation_type operationType, price core_exchange_rate) {
        fee_parameters targetParam = null;
        for (fee_parameters param : this.parameters) {
            if (param.nOperationId != operationType.nOperationType) continue;
            targetParam = param;
            break;
        }
        operations.base_operation operationBase = (operations.base_operation)operationType.operationContent;
        long lFee = operationBase.calculate_fee(targetParam.objectFeeParametersType);
        BigInteger bigFee = BigInteger.valueOf(lFee);
        BigInteger bigScale = BigInteger.valueOf(this.scale);
        BigInteger bigScaled = bigFee.multiply(bigScale);
        BigInteger bigDefault = BigInteger.valueOf(10000L);
        long lResult = bigScaled.divide(bigDefault).longValue();
        asset assetResult = new asset(lResult, new object_id<asset_object>(0, asset_object.class)).multipy(core_exchange_rate);
        while (assetResult.multipy((price)core_exchange_rate).amount < lResult) {
            ++assetResult.amount;
        }
        return assetResult;
    }

    public asset set_fee(operations.operation_type operationType, price core_exchange_rate) {
        asset assetFee;
        asset assetFeeMax = assetFee = this.calculate_fee(operationType, core_exchange_rate);
        operations.base_operation operationBase = (operations.base_operation)operationType.operationContent;
        for (int i = 0; i < 4; ++i) {
            operationBase.set_fee(assetFee);
            asset assetNewFee = this.calculate_fee(operationType, core_exchange_rate);
            if (assetFee.amount == assetNewFee.amount) break;
            assetFee = assetNewFee;
            if (assetFeeMax.amount >= assetNewFee.amount) continue;
            assetFeeMax = assetNewFee;
        }
        return assetFeeMax;
    }

    public static class fee_parameters_deserializer
    implements JsonDeserializer<fee_parameters> {
        public fee_parameters deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray jsonArray = json.getAsJsonArray();
            int nOperationId = jsonArray.get(0).getAsInt();
            fee_parameters parameters = new fee_parameters();
            parameters.nOperationId = nOperationId;
            Type typeFee = operations.operations_map.getOperationFeeObjectById(nOperationId);
            JsonElement jsonElement = jsonArray.get(1);
            parameters.objectFeeParametersType = typeFee != null ? context.deserialize(jsonElement, typeFee) : context.deserialize(jsonElement, Object.class);
            return parameters;
        }
    }

    public static class fee_parameters {
        int nOperationId;
        Object objectFeeParametersType;
    }
}

