/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.chain;

import com.github.chouheiwa.wallet.socket.bitlib.bitcoinj.Base58;
import com.github.chouheiwa.wallet.socket.chain.types;
import com.github.chouheiwa.wallet.socket.fc.crypto.aes;
import com.github.chouheiwa.wallet.socket.fc.crypto.sha224_object;
import com.github.chouheiwa.wallet.socket.fc.crypto.sha256_object;
import com.github.chouheiwa.wallet.socket.fc.crypto.sha512_object;
import com.github.chouheiwa.wallet.socket.fc.io.base_encoder;
import com.github.chouheiwa.wallet.socket.fc.io.raw_type;
import com.github.chouheiwa.wallet.socket.private_key;
import com.github.chouheiwa.wallet.socket.public_key;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class memo_data {
    public types.public_key_type from;
    public types.public_key_type to;
    UnsignedLong nonce = UnsignedLong.ZERO;
    ByteBuffer message;

    public String get_message_data() {
        return Base58.encode(this.message.array());
    }

    public void set_message(private_key privateKey, public_key publicKey, String strMsg, long lCustomNonce) {
        if (lCustomNonce == 0L) {
            byte[] byteSecret = private_key.generate().get_secret();
            sha224_object sha224Object = sha224_object.create_from_byte_array(byteSecret, 0, byteSecret.length);
            byte[] byteEntropy = new byte[4];
            System.arraycopy(sha224Object.hash, 0, byteEntropy, 0, byteEntropy.length);
            raw_type rawType = new raw_type();
            long lEntropy = rawType.byte_array_to_int(byteEntropy);
            lEntropy <<= 32;
            this.nonce = UnsignedLong.fromLongBits((long)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFL | (lEntropy &= 0xFF00000000000000L)));
        } else {
            this.nonce = UnsignedLong.valueOf((long)lCustomNonce);
        }
        sha512_object sha512Object = privateKey.get_shared_secret(publicKey);
        String strNoncePlusSecret = this.nonce.toString() + sha512Object.toString();
        sha512Object = sha512_object.create_from_string(strNoncePlusSecret);
        sha256_object sha256Object = sha256_object.create_from_string(strMsg);
        byte[] byteChecksum = new byte[4];
        System.arraycopy(sha256Object.hash, 0, byteChecksum, 0, byteChecksum.length);
        raw_type rawType = new raw_type();
        int nChecksum = rawType.byte_array_to_int(byteChecksum);
        ByteBuffer byteBufferText = new memo_message(nChecksum, strMsg).serialize();
        byte[] byteKey = new byte[32];
        System.arraycopy(sha512Object.hash, 0, byteKey, 0, byteKey.length);
        byte[] ivBytes = new byte[16];
        System.arraycopy(sha512Object.hash, 32, ivBytes, 0, ivBytes.length);
        this.message = aes.encrypt(byteKey, ivBytes, byteBufferText.array());
    }

    public void write_to_encoder(base_encoder baseEncoder) {
        raw_type rawObject = new raw_type();
        baseEncoder.write(this.from.key_data);
        baseEncoder.write(this.to.key_data);
        baseEncoder.write(rawObject.get_byte_array(this.nonce));
        byte[] byteMessage = this.message.array();
        rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)byteMessage.length));
        baseEncoder.write(byteMessage);
    }

    public String get_message(private_key privateKey, public_key publicKey) {
        sha512_object sha512Object = privateKey.get_shared_secret(publicKey);
        String strNoncePlusSecret = this.nonce.toString() + sha512Object.toString();
        sha512Object = sha512_object.create_from_string(strNoncePlusSecret);
        byte[] byteKey = new byte[32];
        System.arraycopy(sha512Object.hash, 0, byteKey, 0, byteKey.length);
        byte[] ivBytes = new byte[16];
        System.arraycopy(sha512Object.hash, 32, ivBytes, 0, ivBytes.length);
        ByteBuffer byteDecrypt = aes.decrypt(byteKey, ivBytes, this.message.array());
        memo_message memoMessage = memo_message.deserialize(byteDecrypt);
        sha256_object messageHash = sha256_object.create_from_string(memoMessage.text);
        byte[] byteChecksum = new byte[4];
        System.arraycopy(messageHash.hash, 0, byteChecksum, 0, byteChecksum.length);
        raw_type rawType = new raw_type();
        int nChecksum = rawType.byte_array_to_int(byteChecksum);
        if (nChecksum == memoMessage.checksum) {
            return memoMessage.text;
        }
        return "";
    }

    public static class memo_message {
        public int checksum;
        public String text;

        public memo_message(int nChecksum, String strText) {
            this.checksum = nChecksum;
            this.text = strText;
        }

        public ByteBuffer serialize() {
            raw_type rawType = new raw_type();
            byte[] bytesChecksum = rawType.get_byte_array(this.checksum);
            byte[] bytesContent = this.text.getBytes(Charset.forName("UTF-8"));
            ByteBuffer byteBuffer = ByteBuffer.allocate(bytesContent.length + 4);
            byteBuffer.put(bytesChecksum);
            byteBuffer.put(bytesContent);
            return byteBuffer;
        }

        public static memo_message deserialize(ByteBuffer byteBuffer) {
            byte[] byteSerial = byteBuffer.array();
            String strBuffer = new String(byteSerial, 4, byteSerial.length - 4, Charset.forName("UTF-8"));
            byte[] byteChecksum = new byte[4];
            System.arraycopy(byteSerial, 0, byteChecksum, 0, byteChecksum.length);
            raw_type rawType = new raw_type();
            return new memo_message(rawType.byte_array_to_int(byteChecksum), strBuffer);
        }
    }
}

