/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.chain;

import com.github.chouheiwa.wallet.socket.account_object;
import com.github.chouheiwa.wallet.socket.chain.asset_object;
import com.github.chouheiwa.wallet.socket.chain.limit_order_object;
import com.github.chouheiwa.wallet.socket.chain.vesting_balance_object;
import com.github.chouheiwa.wallet.socket.fc.io.base_encoder;
import com.github.chouheiwa.wallet.socket.fc.io.raw_type;
import com.google.common.primitives.UnsignedInteger;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;

public class object_id<T> {
    static ObjectIdManager objectIdManager = new ObjectIdManager();
    int space_id;
    int type_id;
    int instance;

    public <T> object_id(int nInstance, Class<T> classOfT) {
        this.instance = nInstance;
        this.type_id = (Integer)objectIdManager.mMapTypeToId.get(classOfT);
        this.space_id = 1;
    }

    public void write_to_encoder(base_encoder baseEncoder) {
        raw_type rawObject = new raw_type();
        rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.get_instance()));
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%d.%d.%d", this.space_id, this.type_id, this.instance);
    }

    public boolean equals(Object obj) {
        object_id objectId = (object_id)obj;
        return this.space_id == objectId.space_id && this.type_id == objectId.type_id && this.instance == objectId.instance;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public object_id(int nSpaceId, int nTypeId, int nInstance) {
        this.space_id = nSpaceId;
        this.type_id = nTypeId;
        this.instance = nInstance;
    }

    public int get_instance() {
        return this.instance;
    }

    public static <T> object_id<T> create_from_string(String strId) {
        if (!strId.matches("\\d+.\\d+.\\d+")) {
            return null;
        }
        int nFirstDot = strId.indexOf(46);
        int nSecondDot = strId.indexOf(46, nFirstDot + 1);
        if (nFirstDot == -1 || nSecondDot == -1) {
            return null;
        }
        int nSpaceId = Integer.valueOf(strId.substring(0, nFirstDot));
        int nTypeId = Integer.valueOf(strId.substring(nFirstDot + 1, nSecondDot));
        int nInstance = Integer.valueOf(strId.substring(nSecondDot + 1));
        object_id<T> objectId = new object_id<T>(nSpaceId, nTypeId, nInstance);
        return objectId;
    }

    public static class object_id_serializer
    implements JsonSerializer<object_id> {
        public JsonElement serialize(object_id src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }

    public static class object_id_deserializer
    implements JsonDeserializer<object_id> {
        public object_id deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String strContent = json.getAsString();
            int nFirstDot = strContent.indexOf(46);
            int nSecondDot = strContent.indexOf(46, nFirstDot + 1);
            if (nFirstDot == -1 || nSecondDot == -1) {
                throw new JsonParseException(strContent + " is invalid");
            }
            int nSpaceId = Integer.valueOf(strContent.substring(0, nFirstDot));
            int nTypeId = Integer.valueOf(strContent.substring(nFirstDot + 1, nSecondDot));
            int nInstance = Integer.valueOf(strContent.substring(nSecondDot + 1));
            object_id objectId = new object_id(nSpaceId, nTypeId, nInstance);
            return objectId;
        }
    }

    static class ObjectIdManager {
        private HashMap<Type, Integer> mMapTypeToId = new HashMap();

        ObjectIdManager() {
            this.mMapTypeToId.put((Type)((Object)asset_object.class), 3);
            this.mMapTypeToId.put((Type)((Object)account_object.class), 2);
            this.mMapTypeToId.put((Type)((Object)limit_order_object.class), 7);
            this.mMapTypeToId.put((Type)((Object)vesting_balance_object.class), 13);
        }
    }
}

