/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.chain;

import com.github.chouheiwa.wallet.socket.account_object;
import com.github.chouheiwa.wallet.socket.asset;
import com.github.chouheiwa.wallet.socket.authority;
import com.github.chouheiwa.wallet.socket.chain.asset_object;
import com.github.chouheiwa.wallet.socket.chain.asset_options;
import com.github.chouheiwa.wallet.socket.chain.bitasset_options;
import com.github.chouheiwa.wallet.socket.chain.global_config_object;
import com.github.chouheiwa.wallet.socket.chain.limit_order_object;
import com.github.chouheiwa.wallet.socket.chain.memo_data;
import com.github.chouheiwa.wallet.socket.chain.object_id;
import com.github.chouheiwa.wallet.socket.chain.price_feed;
import com.github.chouheiwa.wallet.socket.chain.types;
import com.github.chouheiwa.wallet.socket.chain.vesting_balance_object;
import com.github.chouheiwa.wallet.socket.fc.io.base_encoder;
import com.github.chouheiwa.wallet.socket.fc.io.datastream_size_encoder;
import com.github.chouheiwa.wallet.socket.fc.io.raw_type;
import com.google.common.primitives.UnsignedInteger;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class operations {
    public static final int ID_TRANSER_OPERATION = 0;
    public static final int ID_CREATE_LIMIT_ORDER_OPERATION = 1;
    public static final int ID_CANCEL_LMMIT_ORDER_OPERATION = 2;
    public static final int ID_UPDATE_LMMIT_ORDER_OPERATION = 3;
    public static final int ID_FILL_LMMIT_ORDER_OPERATION = 4;
    public static final int ID_CREATE_ACCOUNT_OPERATION = 5;
    public static final int ID_ACCOUNT_UPDATE_OPERATION = 6;
    public static final int ID_ACCOUNT_WHITELIST_OPERATION = 7;
    public static final int ID_UPGRADE_ACCOUNT_OPERATION = 8;
    public static final int ID_ACCOUNT_TRANSFER_OPERATION = 9;
    public static final int ID_ASSET_CREATE_OPERATION = 10;
    public static final int ID_ASSET_ISSUE_OPERATION = 14;
    public static final int ID_PUBLISHING_ASSET_FEED_OPERATION = 19;
    public static final int ID_VESTING_WITHDRAW_OPERATION = 33;
    public static operation_id_map operations_map = new operation_id_map();

    public static class asset_publish_feed_operation
    implements base_operation {
        public asset fee;
        public object_id<account_object> publisher;
        public object_id<asset_object> asset_id;
        public price_feed feed;
        public Set extensions;

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> array = new ArrayList<object_id<account_object>>();
            array.add(this.fee_payer());
            return array;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            raw_type rawObject = new raw_type();
            this.fee.write_to_encoder(baseEncoder);
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.publisher.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.asset_id.get_instance()));
            this.feed.write_to_encoder(baseEncoder);
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            return feeParametersType.fee;
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.publisher;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            return new ArrayList<object_id<asset_object>>();
        }

        class fee_parameters_type {
            long fee = 100000L;

            fee_parameters_type() {
            }
        }
    }

    public static class asset_issue_operation
    implements base_operation {
        public asset fee;
        public object_id<account_object> issuer;
        public asset asset_to_issue;
        public object_id<account_object> issue_to_account;
        public memo_data memo;
        public Set extensions = new HashSet();

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> array = new ArrayList<object_id<account_object>>();
            array.add(this.fee_payer());
            return array;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            this.fee.write_to_encoder(baseEncoder);
            this.issuer.write_to_encoder(baseEncoder);
            this.asset_to_issue.write_to_encoder(baseEncoder);
            this.issue_to_account.write_to_encoder(baseEncoder);
            raw_type rawObject = new raw_type();
            baseEncoder.write(rawObject.get_byte(this.memo != null));
            if (this.memo != null) {
                this.memo.write_to_encoder(baseEncoder);
            }
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            return this.calculate_fee(feeParametersType);
        }

        public long calculate_fee(fee_parameters_type feeParametersType) {
            long lFee = feeParametersType.fee;
            datastream_size_encoder size_encoder = new datastream_size_encoder();
            size_encoder.write(new raw_type().get_byte(this.memo != null));
            if (this.memo != null) {
                this.memo.write_to_encoder(size_encoder);
            }
            BigInteger nSize = BigInteger.valueOf(size_encoder.getSize());
            BigInteger nPrice = BigInteger.valueOf(feeParametersType.price_per_kbyte);
            BigInteger nKbyte = BigInteger.valueOf(1024L);
            BigInteger nAmount = nPrice.multiply(nSize).divide(nKbyte);
            return lFee += nAmount.longValue();
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.issuer;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            return null;
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            return null;
        }

        class fee_parameters_type {
            long fee = 2000000L;
            long price_per_kbyte = 100000L;

            fee_parameters_type() {
            }
        }
    }

    public static class asset_create_operation
    implements base_operation {
        public asset fee;
        public object_id<account_object> issuer;
        public String symbol;
        public short precision;
        public asset_options common_options;
        public bitasset_options bitasset_opts;
        public boolean is_prediction_market = false;
        public Set extensions = new HashSet();

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> array = new ArrayList<object_id<account_object>>();
            array.add(this.fee_payer());
            return array;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            raw_type raw_object = new raw_type();
            if (this.fee == null) {
                new asset(1L, object_id.create_from_string("1.3.0")).write_to_encoder(baseEncoder);
            } else {
                this.fee.write_to_encoder(baseEncoder);
            }
            this.issuer.write_to_encoder(baseEncoder);
            raw_object.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.symbol.length()));
            baseEncoder.write(this.symbol.getBytes());
            raw_object.pack(baseEncoder, UnsignedInteger.valueOf((long)this.precision));
            this.common_options.write_to_encoder(baseEncoder);
            baseEncoder.write(raw_object.get_byte(this.bitasset_opts != null));
            if (this.bitasset_opts != null) {
                this.bitasset_opts.write_to_encoder(baseEncoder);
            }
            baseEncoder.write(raw_object.get_byte(this.is_prediction_market));
            raw_object.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            long fee = feeParametersType.long_symbol;
            switch (this.symbol.length()) {
                case 3: {
                    fee = feeParametersType.symbol3;
                    break;
                }
                case 4: {
                    fee = feeParametersType.symbol4;
                    break;
                }
            }
            datastream_size_encoder size_encoder = new datastream_size_encoder();
            this.write_to_encoder(size_encoder);
            BigInteger nSize = BigInteger.valueOf(size_encoder.getSize());
            BigInteger nPrice = BigInteger.valueOf(feeParametersType.price_per_kbyte);
            BigInteger nKbyte = BigInteger.valueOf(1024L);
            BigInteger nAmount = nPrice.multiply(nSize).divide(nKbyte);
            return fee += nAmount.longValue();
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.issuer;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            return new ArrayList<object_id<asset_object>>();
        }

        class fee_parameters_type {
            long symbol3 = -1539607552L;
            long symbol4 = -64771072L;
            long long_symbol = 500000000L;
            int price_per_kbyte = 10;

            fee_parameters_type() {
            }
        }
    }

    public static class account_create_operation
    implements base_operation {
        public asset fee;
        public object_id<account_object> registrar;
        public object_id<account_object> referrer;
        public int referrer_percent;
        public String name;
        public authority owner;
        public authority active;
        public types.account_options options;
        public HashMap extensions;

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> activeList = new ArrayList<object_id<account_object>>();
            activeList.add(this.fee_payer());
            return activeList;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            raw_type rawObject = new raw_type();
            if (this.fee == null) {
                new asset(1L, object_id.create_from_string("1.3.0")).write_to_encoder(baseEncoder);
            } else {
                this.fee.write_to_encoder(baseEncoder);
            }
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.registrar.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.referrer.get_instance()));
            Integer reffer = this.referrer_percent;
            baseEncoder.write(rawObject.get_byte_array(reffer.shortValue()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.name.length()));
            baseEncoder.write(this.name.getBytes());
            this.owner.write_to_endcode(baseEncoder);
            this.active.write_to_endcode(baseEncoder);
            this.options.write_to_encode(baseEncoder);
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }

        private boolean is_cheap_name() {
            for (int i = 0; i < this.name.length(); ++i) {
                char c = this.name.charAt(i);
                switch (c) {
                    case 'a': 
                    case 'e': 
                    case 'i': 
                    case 'o': 
                    case 'u': 
                    case 'y': {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            long fee = feeParametersType.basic_fee;
            if (!this.is_cheap_name()) {
                fee = feeParametersType.premium_fee;
            }
            datastream_size_encoder size_encoder = new datastream_size_encoder();
            this.write_to_encoder(size_encoder);
            BigInteger nSize = BigInteger.valueOf(size_encoder.getSize());
            BigInteger nPrice = BigInteger.valueOf(feeParametersType.price_per_kbyte);
            BigInteger nKbyte = BigInteger.valueOf(1024L);
            BigInteger nAmount = nPrice.multiply(nSize).divide(nKbyte);
            return fee += nAmount.longValue();
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.registrar;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            ArrayList<object_id<account_object>> listAccountId = new ArrayList<object_id<account_object>>();
            listAccountId.add(this.registrar);
            listAccountId.add(this.referrer);
            return listAccountId;
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            ArrayList<object_id<asset_object>> listAssetId = new ArrayList<object_id<asset_object>>();
            return listAssetId;
        }

        class fee_parameters_type {
            long basic_fee = 500000L;
            long premium_fee = 200000000L;
            int price_per_kbyte = 100000;

            fee_parameters_type() {
            }
        }
    }

    public static class account_update_operation
    implements base_operation {
        public asset fee;
        public object_id<account_object> account;
        public authority owner;
        public authority active;
        public types.account_options new_options;
        public HashMap extensions = new HashMap();

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> activeList = new ArrayList<object_id<account_object>>();
            activeList.add(this.fee_payer());
            return activeList;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            raw_type rawObject = new raw_type();
            if (this.fee == null) {
                new asset(1L, object_id.create_from_string("1.3.0")).write_to_encoder(baseEncoder);
            } else {
                this.fee.write_to_encoder(baseEncoder);
            }
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.account.get_instance()));
            baseEncoder.write(rawObject.get_byte(this.owner != null));
            if (this.owner != null) {
                this.owner.write_to_endcode(baseEncoder);
            }
            baseEncoder.write(rawObject.get_byte(this.active != null));
            if (this.active != null) {
                this.active.write_to_endcode(baseEncoder);
            }
            baseEncoder.write(rawObject.get_byte(this.new_options != null));
            if (this.new_options != null) {
                this.new_options.write_to_encode(baseEncoder);
            }
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            long fee = feeParametersType.fee;
            datastream_size_encoder size_encoder = new datastream_size_encoder();
            this.write_to_encoder(size_encoder);
            BigInteger nSize = BigInteger.valueOf(size_encoder.getSize());
            BigInteger nPrice = BigInteger.valueOf(feeParametersType.price_per_kbyte);
            BigInteger nKbyte = BigInteger.valueOf(1024L);
            BigInteger nAmount = nPrice.multiply(nSize).divide(nKbyte);
            return fee += nAmount.longValue();
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.account;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            return new ArrayList<object_id<asset_object>>();
        }

        class fee_parameters_type {
            long fee = 2000000L;
            int price_per_kbyte = 100000;

            fee_parameters_type() {
            }
        }
    }

    public static class withdraw_vesting_operation
    implements base_operation {
        public asset fee;
        public object_id<vesting_balance_object> vesting_balance;
        public object_id<account_object> owner;
        public asset amount;

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> activeList = new ArrayList<object_id<account_object>>();
            activeList.add(this.fee_payer());
            return activeList;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            raw_type rawObject = new raw_type();
            baseEncoder.write(rawObject.get_byte_array(this.fee.amount));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.fee.asset_id.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.vesting_balance.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.owner.get_instance()));
            baseEncoder.write(rawObject.get_byte_array(this.amount.amount));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.amount.asset_id.get_instance()));
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            return feeParametersType.fee;
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.owner;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            return null;
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            return null;
        }

        class fee_parameters_type {
            long fee = 2000000L;

            fee_parameters_type() {
            }
        }
    }

    public static class account_upgrade_operation
    implements base_operation {
        public asset fee;
        public object_id<account_object> account_to_upgrade;
        public boolean upgrade_to_lifetime_member;
        public Set<types.void_t> extensions;

        public long calculate_fee(fee_parameters_type feeParametersType) {
            if (this.upgrade_to_lifetime_member) {
                return feeParametersType.membership_lifetime_fee;
            }
            return feeParametersType.membershhip_annual_fee;
        }

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> activeList = new ArrayList<object_id<account_object>>();
            activeList.add(this.fee_payer());
            return activeList;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            raw_type rawObject = new raw_type();
            baseEncoder.write(rawObject.get_byte_array(this.fee.amount));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.fee.asset_id.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.account_to_upgrade.get_instance()));
            baseEncoder.write(rawObject.get_byte(this.upgrade_to_lifetime_member));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            if (this.upgrade_to_lifetime_member) {
                return feeParametersType.membership_lifetime_fee;
            }
            return feeParametersType.membershhip_annual_fee;
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.account_to_upgrade;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            ArrayList<object_id<account_object>> listAccountId = new ArrayList<object_id<account_object>>();
            listAccountId.add(this.account_to_upgrade);
            return listAccountId;
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            ArrayList<object_id<asset_object>> listAssetId = new ArrayList<object_id<asset_object>>();
            return listAssetId;
        }

        class fee_parameters_type {
            long membershhip_annual_fee = 200000000L;
            long membership_lifetime_fee = 1000000000L;

            fee_parameters_type() {
            }
        }
    }

    public static class fill_order_operation
    implements base_operation {
        public object_id order_id;
        public object_id<account_object> account_id;
        public asset pays;
        public asset receives;
        public asset fee;

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            return null;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return null;
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            return 0L;
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.account_id;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            ArrayList<object_id<account_object>> listAccountId = new ArrayList<object_id<account_object>>();
            listAccountId.add(this.account_id);
            return listAccountId;
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            ArrayList<object_id<asset_object>> listAssetId = new ArrayList<object_id<asset_object>>();
            listAssetId.add(this.pays.asset_id);
            listAssetId.add(this.receives.asset_id);
            return listAssetId;
        }

        class fee_parameters_type {
            fee_parameters_type() {
            }
        }
    }

    public static class call_order_update_operation
    implements base_operation {
        public asset fee;
        public object_id<account_object> funding_account;
        public asset delta_collateral;
        public asset delta_debt;
        public Set<types.void_t> extensions;

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> activeList = new ArrayList<object_id<account_object>>();
            activeList.add(this.fee_payer());
            return activeList;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            raw_type rawObject = new raw_type();
            baseEncoder.write(rawObject.get_byte_array(this.fee.amount));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.fee.asset_id.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.funding_account.get_instance()));
            baseEncoder.write(rawObject.get_byte_array(this.delta_collateral.amount));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.delta_collateral.asset_id.get_instance()));
            baseEncoder.write(rawObject.get_byte_array(this.delta_debt.amount));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.delta_debt.asset_id.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            return feeParametersType.fee;
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.funding_account;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            ArrayList<object_id<account_object>> listAccountId = new ArrayList<object_id<account_object>>();
            listAccountId.add(this.funding_account);
            return listAccountId;
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            ArrayList<object_id<asset_object>> listAssetId = new ArrayList<object_id<asset_object>>();
            listAssetId.add(this.delta_collateral.asset_id);
            listAssetId.add(this.delta_debt.asset_id);
            return listAssetId;
        }

        class fee_parameters_type {
            long fee = 2000000L;

            fee_parameters_type() {
            }
        }
    }

    public static class limit_order_cancel_operation
    implements base_operation {
        public asset fee;
        public object_id<limit_order_object> order;
        public object_id<account_object> fee_paying_account;
        public Set<types.void_t> extensions;

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> activeList = new ArrayList<object_id<account_object>>();
            activeList.add(this.fee_payer());
            return activeList;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            raw_type rawObject = new raw_type();
            baseEncoder.write(rawObject.get_byte_array(this.fee.amount));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.fee.asset_id.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.fee_paying_account.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.order.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            return feeParametersType.fee;
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.fee_paying_account;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            ArrayList<object_id<account_object>> listAccountId = new ArrayList<object_id<account_object>>();
            listAccountId.add(this.fee_paying_account);
            return listAccountId;
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            ArrayList<object_id<asset_object>> listAssetId = new ArrayList<object_id<asset_object>>();
            return listAssetId;
        }

        class fee_parameters_type {
            long fee = 0L;

            fee_parameters_type() {
            }
        }
    }

    public static class limit_order_create_operation
    implements base_operation {
        public asset fee;
        public object_id<account_object> seller;
        public asset amount_to_sell;
        public asset min_to_receive;
        public Date expiration;
        public boolean fill_or_kill = false;
        public Set<types.void_t> extensions;

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> activeList = new ArrayList<object_id<account_object>>();
            activeList.add(this.fee_payer());
            return activeList;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            raw_type rawObject = new raw_type();
            baseEncoder.write(rawObject.get_byte_array(this.fee.amount));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.fee.asset_id.get_instance()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.seller.get_instance()));
            baseEncoder.write(rawObject.get_byte_array(this.amount_to_sell.amount));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.amount_to_sell.asset_id.get_instance()));
            baseEncoder.write(rawObject.get_byte_array(this.min_to_receive.amount));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.min_to_receive.asset_id.get_instance()));
            baseEncoder.write(rawObject.get_byte_array(this.expiration));
            baseEncoder.write(rawObject.get_byte(this.fill_or_kill));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            return feeParametersType.fee;
        }

        @Override
        public void set_fee(asset fee) {
            this.fee = fee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.seller;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            ArrayList<object_id<account_object>> listAccountId = new ArrayList<object_id<account_object>>();
            listAccountId.add(this.seller);
            return listAccountId;
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            ArrayList<object_id<asset_object>> listAssetId = new ArrayList<object_id<asset_object>>();
            listAssetId.add(this.amount_to_sell.asset_id);
            listAssetId.add(this.min_to_receive.asset_id);
            return listAssetId;
        }

        static class fee_parameters_type {
            long fee = 500000L;

            fee_parameters_type() {
            }
        }
    }

    public static class transfer_operation
    implements base_operation {
        public asset fee;
        public object_id<account_object> from;
        public object_id<account_object> to;
        public asset amount;
        public memo_data memo;
        public Set<types.void_t> extensions;

        @Override
        public List<authority> get_required_authorities() {
            return new ArrayList<authority>();
        }

        @Override
        public List<object_id<account_object>> get_required_active_authorities() {
            ArrayList<object_id<account_object>> activeList = new ArrayList<object_id<account_object>>();
            activeList.add(this.fee_payer());
            return activeList;
        }

        @Override
        public List<object_id<account_object>> get_required_owner_authorities() {
            return new ArrayList<object_id<account_object>>();
        }

        @Override
        public void write_to_encoder(base_encoder baseEncoder) {
            raw_type rawObject = new raw_type();
            this.fee.write_to_encoder(baseEncoder);
            this.from.write_to_encoder(baseEncoder);
            this.to.write_to_encoder(baseEncoder);
            this.amount.write_to_encoder(baseEncoder);
            baseEncoder.write(rawObject.get_byte(this.memo != null));
            if (this.memo != null) {
                this.memo.write_to_encoder(baseEncoder);
            }
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }

        @Override
        public long calculate_fee(Object objectFeeParameter) {
            assert (fee_parameters_type.class.isInstance(objectFeeParameter));
            fee_parameters_type feeParametersType = (fee_parameters_type)objectFeeParameter;
            return this.calculate_fee(feeParametersType);
        }

        @Override
        public void set_fee(asset assetFee) {
            this.fee = assetFee;
        }

        @Override
        public object_id<account_object> fee_payer() {
            return this.from;
        }

        @Override
        public List<object_id<account_object>> get_account_id_list() {
            ArrayList<object_id<account_object>> listAccountId = new ArrayList<object_id<account_object>>();
            listAccountId.add(this.from);
            listAccountId.add(this.to);
            return listAccountId;
        }

        @Override
        public List<object_id<asset_object>> get_asset_id_list() {
            ArrayList<object_id<asset_object>> listAssetId = new ArrayList<object_id<asset_object>>();
            listAssetId.add(this.amount.asset_id);
            return listAssetId;
        }

        public long calculate_fee(fee_parameters_type feeParametersType) {
            long lFee = feeParametersType.fee;
            if (this.memo != null) {
                Gson gson = global_config_object.getInstance().getGsonBuilder().create();
                BigInteger nSize = BigInteger.valueOf(gson.toJson((Object)this.memo).length());
                BigInteger nPrice = BigInteger.valueOf(feeParametersType.price_per_kbyte);
                BigInteger nKbyte = BigInteger.valueOf(1024L);
                BigInteger nAmount = nPrice.multiply(nSize).divide(nKbyte);
                lFee += nAmount.longValue();
            }
            return lFee;
        }

        public static class fee_parameters_type {
            long fee = 2000000L;
            long price_per_kbyte = 1000000L;
        }
    }

    public static interface base_operation {
        public List<authority> get_required_authorities();

        public List<object_id<account_object>> get_required_active_authorities();

        public List<object_id<account_object>> get_required_owner_authorities();

        public void write_to_encoder(base_encoder var1);

        public long calculate_fee(Object var1);

        public void set_fee(asset var1);

        public object_id<account_object> fee_payer();

        public List<object_id<account_object>> get_account_id_list();

        public List<object_id<asset_object>> get_asset_id_list();
    }

    public static class operation_type {
        public int nOperationType;
        public Object operationContent;

        public static class operation_type_serializer
        implements JsonSerializer<operation_type> {
            public JsonElement serialize(operation_type src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray jsonArray = new JsonArray();
                jsonArray.add((Number)src.nOperationType);
                Type type = operations_map.getOperationObjectById(src.nOperationType);
                assert (type != null);
                jsonArray.add(context.serialize(src.operationContent, type));
                return jsonArray;
            }
        }

        public static class operation_type_deserializer
        implements JsonDeserializer<operation_type> {
            public operation_type deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                operation_type operationType = new operation_type();
                JsonArray jsonArray = json.getAsJsonArray();
                operationType.nOperationType = jsonArray.get(0).getAsInt();
                Type type = operations_map.getOperationObjectById(operationType.nOperationType);
                operationType.operationContent = type != null ? context.deserialize(jsonArray.get(1), type) : context.deserialize(jsonArray.get(1), Object.class);
                return operationType;
            }
        }
    }

    public static class operation_id_map {
        private HashMap<Integer, Type> mHashId2Operation = new HashMap();
        private HashMap<Integer, Type> mHashId2OperationFee = new HashMap();
        private HashMap<Type, Integer> mHashOperation2Id = new HashMap();

        public operation_id_map() {
            this.mHashId2Operation.put(0, (Type)((Object)transfer_operation.class));
            this.mHashId2Operation.put(1, (Type)((Object)limit_order_create_operation.class));
            this.mHashId2Operation.put(2, (Type)((Object)limit_order_cancel_operation.class));
            this.mHashId2Operation.put(3, (Type)((Object)call_order_update_operation.class));
            this.mHashId2Operation.put(4, (Type)((Object)fill_order_operation.class));
            this.mHashId2Operation.put(5, (Type)((Object)account_create_operation.class));
            this.mHashId2Operation.put(6, (Type)((Object)account_update_operation.class));
            this.mHashId2Operation.put(8, (Type)((Object)account_upgrade_operation.class));
            this.mHashId2Operation.put(19, (Type)((Object)asset_publish_feed_operation.class));
            this.mHashId2Operation.put(33, (Type)((Object)withdraw_vesting_operation.class));
            this.mHashId2Operation.put(10, (Type)((Object)asset_create_operation.class));
            this.mHashId2Operation.put(14, (Type)((Object)asset_issue_operation.class));
            this.mHashOperation2Id.put((Type)((Object)transfer_operation.class), 0);
            this.mHashOperation2Id.put((Type)((Object)limit_order_create_operation.class), 1);
            this.mHashOperation2Id.put((Type)((Object)limit_order_cancel_operation.class), 2);
            this.mHashOperation2Id.put((Type)((Object)call_order_update_operation.class), 3);
            this.mHashOperation2Id.put((Type)((Object)fill_order_operation.class), 4);
            this.mHashOperation2Id.put((Type)((Object)account_create_operation.class), 5);
            this.mHashOperation2Id.put((Type)((Object)account_update_operation.class), 6);
            this.mHashOperation2Id.put((Type)((Object)account_upgrade_operation.class), 8);
            this.mHashOperation2Id.put((Type)((Object)asset_publish_feed_operation.class), 19);
            this.mHashOperation2Id.put((Type)((Object)withdraw_vesting_operation.class), 33);
            this.mHashOperation2Id.put((Type)((Object)asset_create_operation.class), 10);
            this.mHashOperation2Id.put((Type)((Object)asset_issue_operation.class), 14);
            this.mHashId2OperationFee.put(0, (Type)((Object)transfer_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(1, (Type)((Object)limit_order_create_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(2, (Type)((Object)limit_order_cancel_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(3, (Type)((Object)call_order_update_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(4, (Type)((Object)fill_order_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(5, (Type)((Object)account_create_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(6, (Type)((Object)account_update_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(8, (Type)((Object)account_upgrade_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(19, (Type)((Object)asset_publish_feed_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(33, (Type)((Object)withdraw_vesting_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(10, (Type)((Object)asset_create_operation.fee_parameters_type.class));
            this.mHashId2OperationFee.put(14, (Type)((Object)asset_issue_operation.fee_parameters_type.class));
        }

        public int getIdByOperationObject(Type type) {
            return this.mHashOperation2Id.get(type);
        }

        public Type getOperationObjectById(int nId) {
            return this.mHashId2Operation.get(nId);
        }

        public Type getOperationFeeObjectById(int nId) {
            return this.mHashId2OperationFee.get(nId);
        }
    }
}

