/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.chain;

import com.github.chouheiwa.wallet.socket.account_object;
import com.github.chouheiwa.wallet.socket.authority;
import com.github.chouheiwa.wallet.socket.chain.object_id;
import com.github.chouheiwa.wallet.socket.chain.operations;
import com.github.chouheiwa.wallet.socket.chain.types;
import com.github.chouheiwa.wallet.socket.common.UnsignedShort;
import com.github.chouheiwa.wallet.socket.fc.bitutil;
import com.github.chouheiwa.wallet.socket.fc.crypto.ripemd160_object;
import com.github.chouheiwa.wallet.socket.fc.crypto.sha256_object;
import com.github.chouheiwa.wallet.socket.fc.io.raw_type;
import com.google.common.primitives.UnsignedInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class transaction {
    public UnsignedShort ref_block_num = UnsignedShort.ZERO;
    public UnsignedInteger ref_block_prefix = UnsignedInteger.ZERO;
    public Date expiration;
    public List<operations.operation_type> operations;
    public Set<types.void_t> extensions;

    public ripemd160_object id() {
        return null;
    }

    public void set_reference_block(ripemd160_object reference_block) {
        this.ref_block_num = new UnsignedShort((short)bitutil.endian_reverse_u32(reference_block.hash[0]));
        this.ref_block_prefix = UnsignedInteger.fromIntBits((int)reference_block.hash[1]);
    }

    public void set_expiration(Date expiration_time) {
        this.expiration = expiration_time;
    }

    public required_authorities get_required_authorities() {
        required_authorities requiredAuthorities = new required_authorities();
        requiredAuthorities.active = new ArrayList<object_id<account_object>>();
        requiredAuthorities.owner = new ArrayList<object_id<account_object>>();
        requiredAuthorities.other = new ArrayList<authority>();
        for (operations.operation_type operationType : this.operations) {
            operations.base_operation baseOperation = (operations.base_operation)operationType.operationContent;
            requiredAuthorities.active.addAll(baseOperation.get_required_active_authorities());
            requiredAuthorities.owner.addAll(baseOperation.get_required_owner_authorities());
            requiredAuthorities.other.addAll(baseOperation.get_required_authorities());
        }
        return requiredAuthorities;
    }

    public sha256_object ids() {
        sha256_object.encoder enc = new sha256_object.encoder();
        raw_type rawTypeObject = new raw_type();
        enc.write(rawTypeObject.get_byte_array(this.ref_block_num.shortValue()));
        enc.write(rawTypeObject.get_byte_array(this.ref_block_prefix.intValue()));
        enc.write(rawTypeObject.get_byte_array(this.expiration));
        rawTypeObject.pack(enc, UnsignedInteger.fromIntBits((int)this.operations.size()));
        for (operations.operation_type operationType : this.operations) {
            rawTypeObject.pack(enc, UnsignedInteger.fromIntBits((int)operationType.nOperationType));
            operations.base_operation baseOperation = (operations.base_operation)operationType.operationContent;
            baseOperation.write_to_encoder(enc);
        }
        rawTypeObject.pack(enc, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        return enc.result();
    }

    public sha256_object sig_digest(sha256_object chain_id) {
        sha256_object.encoder enc = new sha256_object.encoder();
        enc.write(chain_id.hash, 0, chain_id.hash.length);
        raw_type rawTypeObject = new raw_type();
        enc.write(rawTypeObject.get_byte_array(this.ref_block_num.shortValue()));
        enc.write(rawTypeObject.get_byte_array(this.ref_block_prefix.intValue()));
        enc.write(rawTypeObject.get_byte_array(this.expiration));
        rawTypeObject.pack(enc, UnsignedInteger.fromIntBits((int)this.operations.size()));
        for (operations.operation_type operationType : this.operations) {
            rawTypeObject.pack(enc, UnsignedInteger.fromIntBits((int)operationType.nOperationType));
            operations.base_operation baseOperation = (operations.base_operation)operationType.operationContent;
            baseOperation.write_to_encoder(enc);
        }
        rawTypeObject.pack(enc, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        return enc.result();
    }

    public class required_authorities {
        public List<object_id<account_object>> active;
        public List<object_id<account_object>> owner;
        public List<authority> other;
    }
}

