/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.chain;

import com.github.chouheiwa.wallet.socket.account_object;
import com.github.chouheiwa.wallet.socket.bitlib.bitcoinj.Base58;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.digest.RIPEMD160Digest;
import com.github.chouheiwa.wallet.socket.chain.config;
import com.github.chouheiwa.wallet.socket.chain.object_id;
import com.github.chouheiwa.wallet.socket.fc.io.base_encoder;
import com.github.chouheiwa.wallet.socket.fc.io.raw_type;
import com.github.chouheiwa.wallet.socket.private_key;
import com.github.chouheiwa.wallet.socket.public_key;
import com.google.common.primitives.UnsignedInteger;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import org.spongycastle.crypto.digests.SHA256Digest;

public class types {
    public static final int charge_market_fee = 1;
    public static final int white_list = 2;
    public static final int override_authority = 4;
    public static final int transfer_restricted = 8;
    public static final int disable_force_settle = 16;
    public static final int global_settle = 32;
    public static final int disable_confidential = 64;
    public static final int witness_fed_asset = 128;
    public static final int committee_fed_asset = 256;
    public static final int ASSET_ISSUER_PERMISSION_MASK = 511;
    public static final int UIA_ASSET_ISSUER_PERMISSION_MASK = 79;

    public static class TestClass2 {
        public object_id<account_object> id;
    }

    public static class TestClass {
        public String id;
    }

    class void_t {
        void_t() {
        }
    }

    public static class public_type_serializer
    implements JsonSerializer<public_key_type> {
        public JsonElement serialize(public_key_type src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }

    public static class public_key_type_deserializer
    implements JsonDeserializer<public_key_type> {
        public public_key_type deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String strPublicKey = json.getAsString();
            try {
                return new public_key_type(strPublicKey);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new JsonParseException("pubic key is invalid.");
            }
        }
    }

    public static class account_options {
        public public_key_type memo_key;
        public object_id<account_object> voting_account;
        public Integer num_witness;
        public Integer num_committee;
        public HashSet<vote_id_type> votes;
        public HashSet<String> extensions;

        public void write_to_encode(base_encoder baseEncoder) {
            raw_type rawObject = new raw_type();
            baseEncoder.write(this.memo_key.key_data);
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.voting_account.get_instance()));
            baseEncoder.write(rawObject.get_byte_array(this.num_witness.shortValue()));
            baseEncoder.write(rawObject.get_byte_array(this.num_committee.shortValue()));
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.votes.size()));
            for (vote_id_type type : this.votes) {
                rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)type.content));
            }
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.extensions.size()));
        }
    }

    public static class vote_id_type_deserializer
    implements JsonDeserializer<vote_id_type> {
        public vote_id_type deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String strSerial = json.getAsString();
            return new vote_id_type(strSerial);
        }
    }

    public static class vote_id_type {
        int content;

        public vote_id_type(String strSerial) {
            int nIndex = strSerial.indexOf(58);
            if (nIndex == -1) {
                throw new RuntimeException("vote_id_type invalid serial");
            }
            int nType = Integer.valueOf(strSerial.substring(0, nIndex));
            int nInstance = Integer.valueOf(strSerial.substring(nIndex + 1));
            this.content = nInstance << 8 | nType;
        }
    }

    public static class private_key_type {
        private byte[] key_data = new byte[32];

        public String toString() {
            byte[] data = new byte[this.key_data.length + 1 + 4];
            data[0] = -128;
            System.arraycopy(this.key_data, 0, data, 1, this.key_data.length);
            SHA256Digest digest = new SHA256Digest();
            digest.update(data, 0, this.key_data.length + 1);
            byte[] out = new byte[32];
            digest.doFinal(out, 0);
            digest.update(out, 0, out.length);
            digest.doFinal(out, 0);
            System.arraycopy(out, 0, data, this.key_data.length + 1, 4);
            return Base58.encode(data);
        }

        public private_key_type(String strBase58) {
            byte[] wif_bytes = Base58.decode(strBase58);
            if (wif_bytes != null) {
                if (wif_bytes.length < 5) {
                    // empty if block
                }
                System.arraycopy(wif_bytes, 1, this.key_data, 0, this.key_data.length);
                SHA256Digest digest = new SHA256Digest();
                digest.update(wif_bytes, 0, wif_bytes.length - 4);
                byte[] hashCheck = new byte[32];
                digest.doFinal(hashCheck, 0);
                byte[] hashCheck2 = new byte[32];
                digest.update(hashCheck, 0, hashCheck.length);
                digest.doFinal(hashCheck2, 0);
                byte[] check = new byte[4];
                System.arraycopy(wif_bytes, wif_bytes.length - check.length, check, 0, check.length);
                byte[] check1 = new byte[4];
                byte[] check2 = new byte[4];
                System.arraycopy(hashCheck, 0, check1, 0, check1.length);
                System.arraycopy(hashCheck2, 0, check2, 0, check2.length);
                if (Arrays.equals(check1, check) || !Arrays.equals(check2, check)) {
                    // empty if block
                }
            }
        }

        public private_key_type(private_key privateKey) {
            this.key_data = privateKey.get_secret();
        }

        public private_key getPrivateKey() {
            return new private_key(this.key_data);
        }
    }

    public static class public_key_type {
        private String prefix;
        public byte[] key_data = new byte[33];

        public public_key_type() {
        }

        public int hashCode() {
            return Arrays.hashCode(this.key_data);
        }

        public boolean equals(Object obj) {
            public_key_type publicKeyType = (public_key_type)obj;
            return Arrays.equals(this.key_data, publicKeyType.key_data);
        }

        public public_key_type(public_key publicKey) {
            this.key_data = publicKey.getKeyByte();
        }

        public String toString() {
            RIPEMD160Digest dig = new RIPEMD160Digest();
            dig.update(this.key_data, 0, this.key_data.length);
            byte[] out = new byte[20];
            dig.doFinal(out, 0);
            byte[] byteKeyData = new byte[37];
            System.arraycopy(this.key_data, 0, byteKeyData, 0, this.key_data.length);
            System.arraycopy(out, 0, byteKeyData, this.key_data.length, byteKeyData.length - this.key_data.length);
            String strResult = config.GRAPHENE_ADDRESS_PREFIX;
            strResult = strResult + Base58.encode(byteKeyData);
            return strResult;
        }

        public public_key_type(String strBase58) throws NoSuchAlgorithmException {
            String strPrefix = config.GRAPHENE_ADDRESS_PREFIX;
            byte[] byteKeyData = Base58.decode(strBase58.substring(strPrefix.length()));
            binary_key binaryKey = new binary_key(byteKeyData);
            RIPEMD160Digest digest = new RIPEMD160Digest();
            digest.update(binaryKey.data, 0, binaryKey.data.length);
            byte[] out = new byte[20];
            digest.doFinal(out, 0);
            byte[] byteOut = new byte[4];
            System.arraycopy(out, 0, byteOut, 0, byteOut.length);
            int nByteOut = ByteBuffer.wrap(byteOut).getInt();
            if (nByteOut != binaryKey.check) {
                throw new RuntimeException("Public key is not valid");
            }
            this.key_data = binaryKey.data;
        }

        public public_key getPublicKey() {
            return new public_key(this.key_data);
        }

        public boolean compare(public_key_type publicKeyType) {
            return Arrays.equals(this.key_data, publicKeyType.key_data);
        }
    }

    public static class binary_key {
        public byte[] data = new byte[33];
        public int check;

        public binary_key(byte[] key) {
            System.arraycopy(key, 0, this.data, 0, this.data.length);
            byte[] byteCheck = new byte[4];
            System.arraycopy(key, this.data.length, byteCheck, 0, 4);
            this.check = ByteBuffer.wrap(byteCheck).getInt();
        }
    }

    static enum impl_object_type {
        impl_global_property_object_type,
        impl_dynamic_global_property_object_type,
        impl_reserved0_object_type,
        impl_asset_dynamic_data_type,
        impl_asset_bitasset_data_type,
        impl_account_balance_object_type,
        impl_account_statistics_object_type,
        impl_transaction_object_type,
        impl_block_summary_object_type,
        impl_account_transaction_history_object_type,
        impl_blinded_balance_object_type,
        impl_chain_property_object_type,
        impl_witness_schedule_object_type,
        impl_budget_record_object_type,
        impl_special_authority_object_type,
        impl_buyback_object_type,
        impl_fba_accumulator_object_type;

    }

    public static class object_type {
        public static final int null_object_type = 0;
        public static final int base_object_type = 1;
        public static final int account_object_type = 2;
        public static final int asset_object_type = 3;
        public static final int limit_order_object_type = 7;
        public static final int vesting_balance_object_type = 13;
    }

    static enum reserved_spaces {
        relative_protocol_ids,
        protocol_ids,
        implementation_ids;

    }
}

