/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.megiontechnologies;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class Bitcoins
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long SATOSHIS_PER_BITCOIN = 100000000L;
    private static final BigDecimal SATOSHIS_PER_BITCOIN_BD = BigDecimal.valueOf(100000000L);
    public static final long MAX_VALUE = 2100000000000000L;
    public static final String BITCOIN_SYMBOL = "BTC";
    private final long satoshis;

    public static Bitcoins valueOf(double btc) {
        return Bitcoins.valueOf(Bitcoins.toLongExact(btc));
    }

    public static Bitcoins valueOf(String btc) {
        return Bitcoins.valueOf(new BigDecimal(btc).multiply(SATOSHIS_PER_BITCOIN_BD).longValueExact());
    }

    public static Bitcoins nearestValue(double v) {
        return new Bitcoins(Math.round(v * 1.0E8));
    }

    public static Bitcoins nearestValue(BigDecimal bitcoinAmount) {
        BigDecimal satoshis = bitcoinAmount.multiply(SATOSHIS_PER_BITCOIN_BD);
        long satoshisExact = satoshis.setScale(0, RoundingMode.HALF_UP).longValueExact();
        return new Bitcoins(satoshisExact);
    }

    public static Bitcoins valueOf(long satoshis) {
        return new Bitcoins(satoshis);
    }

    private static long toLongExact(double origValue) {
        double satoshis = origValue * 1.0E8;
        return Math.round(satoshis);
    }

    private Bitcoins(long satoshis) {
        if (satoshis < 0L) {
            throw new IllegalArgumentException(String.format("Bitcoin values must be debt-free and positive, but was %s", satoshis));
        }
        if (satoshis >= 2100000000000000L) {
            throw new IllegalArgumentException(String.format("Bitcoin values must be smaller than 21 Million BTC, but was %s", satoshis));
        }
        this.satoshis = satoshis;
    }

    public BigDecimal multiply(BigDecimal pricePerBtc) {
        return this.toBigDecimal().multiply(BigDecimal.valueOf(this.satoshis));
    }

    protected Bitcoins parse(String input) {
        return Bitcoins.valueOf(input);
    }

    public String toString() {
        return this.toBigDecimal().toPlainString();
    }

    public String toString(int decimals) {
        return this.toBigDecimal().setScale(decimals, RoundingMode.DOWN).toPlainString();
    }

    public BigDecimal toBigDecimal() {
        return BigDecimal.valueOf(this.satoshis).divide(SATOSHIS_PER_BITCOIN_BD);
    }

    public int hashCode() {
        return (int)(this.satoshis ^ this.satoshis >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bitcoins bitcoins = (Bitcoins)o;
        return this.satoshis == bitcoins.satoshis;
    }

    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.satoshis);
    }

    public long getLongValue() {
        return this.satoshis;
    }

    public String toCurrencyString() {
        return "BTC " + this.toString();
    }

    public String toCurrencyString(int decimals) {
        return "BTC " + this.toString(decimals);
    }

    public Bitcoins roundToSignificantFigures(int n) {
        return Bitcoins.valueOf(Bitcoins.roundToSignificantFigures(this.satoshis, n));
    }

    private static long roundToSignificantFigures(long num, int n) {
        if (num == 0L) {
            return 0L;
        }
        double d = Math.ceil(Math.log10(num < 0L ? (double)(-num) : (double)num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round((double)num * magnitude);
        return (long)((double)shifted / magnitude);
    }
}

