/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket;

import com.github.chouheiwa.wallet.net.model.AllHistory;
import com.github.chouheiwa.wallet.net.model.HistoryResponseModel;
import com.github.chouheiwa.wallet.socket.account_object;
import com.github.chouheiwa.wallet.socket.asset;
import com.github.chouheiwa.wallet.socket.authority;
import com.github.chouheiwa.wallet.socket.chain.CallOrder;
import com.github.chouheiwa.wallet.socket.chain.asset_object;
import com.github.chouheiwa.wallet.socket.chain.asset_options;
import com.github.chouheiwa.wallet.socket.chain.bitasset_options;
import com.github.chouheiwa.wallet.socket.chain.block_chain_info;
import com.github.chouheiwa.wallet.socket.chain.block_header;
import com.github.chouheiwa.wallet.socket.chain.block_object;
import com.github.chouheiwa.wallet.socket.chain.bucket_object;
import com.github.chouheiwa.wallet.socket.chain.dynamic_global_property_object;
import com.github.chouheiwa.wallet.socket.chain.fee_schedule;
import com.github.chouheiwa.wallet.socket.chain.global_config_object;
import com.github.chouheiwa.wallet.socket.chain.global_property_object;
import com.github.chouheiwa.wallet.socket.chain.limit_order_object;
import com.github.chouheiwa.wallet.socket.chain.memo_data;
import com.github.chouheiwa.wallet.socket.chain.object_id;
import com.github.chouheiwa.wallet.socket.chain.operation_history_object;
import com.github.chouheiwa.wallet.socket.chain.operation_types_histoy_object;
import com.github.chouheiwa.wallet.socket.chain.operations;
import com.github.chouheiwa.wallet.socket.chain.price;
import com.github.chouheiwa.wallet.socket.chain.price_feed;
import com.github.chouheiwa.wallet.socket.chain.signed_transaction;
import com.github.chouheiwa.wallet.socket.chain.transaction;
import com.github.chouheiwa.wallet.socket.chain.types;
import com.github.chouheiwa.wallet.socket.exception.NetworkStatusException;
import com.github.chouheiwa.wallet.socket.fc.crypto.aes;
import com.github.chouheiwa.wallet.socket.fc.crypto.sha256_object;
import com.github.chouheiwa.wallet.socket.fc.crypto.sha512_object;
import com.github.chouheiwa.wallet.socket.fc.io.base_encoder;
import com.github.chouheiwa.wallet.socket.fc.io.datastream_encoder;
import com.github.chouheiwa.wallet.socket.fc.io.datastream_size_encoder;
import com.github.chouheiwa.wallet.socket.fc.io.raw_type;
import com.github.chouheiwa.wallet.socket.full_account_object;
import com.github.chouheiwa.wallet.socket.market.MarketTicker;
import com.github.chouheiwa.wallet.socket.market.OrderBook;
import com.github.chouheiwa.wallet.socket.private_key;
import com.github.chouheiwa.wallet.socket.public_key;
import com.github.chouheiwa.wallet.socket.websocket_api;
import com.github.chouheiwa.wallet.utils.CalculateUtils;
import com.github.chouheiwa.wallet.utils.NumberUtils;
import com.github.chouheiwa.wallet.utils.TextUtils;
import com.google.common.primitives.UnsignedInteger;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.ECKey;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.digests.SHA512Digest;

public class wallet_api {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private websocket_api mWebsocketApi = new websocket_api();
    private wallet_object mWalletObject;
    private boolean mbLogin = false;
    private HashMap<types.public_key_type, types.private_key_type> mHashMapPub2Priv = new HashMap();
    private sha512_object mCheckSum = new sha512_object();
    private String ws_server;

    public wallet_api(String ws_server) {
        this.ws_server = ws_server;
    }

    public int initialize(String chain_id) {
        int nRet = this.mWebsocketApi.connect(this.ws_server);
        if (nRet == 0) {
            sha256_object sha256Object = sha256_object.create_from_chain_id(chain_id);
            if (this.mWalletObject == null) {
                this.mWalletObject = new wallet_object();
                this.mWalletObject.chain_id = sha256Object;
            } else if (this.mWalletObject.chain_id != null && !this.mWalletObject.chain_id.equals(sha256Object)) {
                nRet = -1;
            }
        }
        return nRet;
    }

    public int reset() {
        this.mWebsocketApi.close();
        this.mWalletObject = null;
        this.mbLogin = false;
        this.mHashMapPub2Priv.clear();
        this.mCheckSum = new sha512_object();
        return 0;
    }

    public void close() {
        this.mWebsocketApi.close();
    }

    public boolean is_locked() {
        return this.mWalletObject.cipher_keys.array().length > 0 && this.mCheckSum.equals(new sha512_object());
    }

    private void encrypt_keys() {
        plain_keys data = new plain_keys();
        data.keys = new HashMap<types.public_key_type, String>();
        for (Map.Entry<types.public_key_type, types.private_key_type> entry : this.mHashMapPub2Priv.entrySet()) {
            data.keys.put(entry.getKey(), entry.getValue().toString());
        }
        data.checksum = this.mCheckSum;
        datastream_size_encoder sizeEncoder = new datastream_size_encoder();
        data.write_to_encoder(sizeEncoder);
        datastream_encoder encoder2 = new datastream_encoder(sizeEncoder.getSize());
        data.write_to_encoder(encoder2);
        byte[] byteKey = new byte[32];
        System.arraycopy(this.mCheckSum.hash, 0, byteKey, 0, byteKey.length);
        byte[] ivBytes = new byte[16];
        System.arraycopy(this.mCheckSum.hash, 32, ivBytes, 0, ivBytes.length);
        this.mWalletObject.cipher_keys = aes.encrypt(byteKey, ivBytes, encoder2.getData());
    }

    public int lock() {
        this.encrypt_keys();
        this.mCheckSum = new sha512_object();
        this.mHashMapPub2Priv.clear();
        return 0;
    }

    public int unlock(String strPassword) {
        assert (strPassword.length() > 0);
        sha512_object passwordHash = sha512_object.create_from_string(strPassword);
        if (passwordHash == null || passwordHash.hash == null) {
            return -1;
        }
        byte[] byteKey = new byte[32];
        System.arraycopy(passwordHash.hash, 0, byteKey, 0, byteKey.length);
        byte[] ivBytes = new byte[16];
        System.arraycopy(passwordHash.hash, 32, ivBytes, 0, ivBytes.length);
        if (this.mWalletObject == null || this.mWalletObject.cipher_keys == null) {
            return -1;
        }
        ByteBuffer byteDecrypt = aes.decrypt(byteKey, ivBytes, this.mWalletObject.cipher_keys.array());
        if (byteDecrypt == null || byteDecrypt.array().length == 0) {
            return -1;
        }
        plain_keys dataResult = plain_keys.from_input_stream(new ByteArrayInputStream(byteDecrypt.array()));
        for (Map.Entry<types.public_key_type, String> entry : dataResult.keys.entrySet()) {
            types.private_key_type privateKeyType = new types.private_key_type(entry.getValue());
            if (TextUtils.isEmpty(privateKeyType.toString())) continue;
            this.mHashMapPub2Priv.put(entry.getKey(), privateKeyType);
        }
        this.mCheckSum = passwordHash;
        if (passwordHash.equals(dataResult.checksum)) {
            return 0;
        }
        return -1;
    }

    public boolean is_new() {
        if (this.mWalletObject == null || this.mWalletObject.cipher_keys == null) {
            return true;
        }
        return this.mWalletObject.cipher_keys.array().length == 0 && this.mCheckSum.equals(new sha512_object());
    }

    public String getWifKeyWithAccount(String accountName) {
        String result = "";
        for (int i = 0; i < this.list_my_accounts().size(); ++i) {
            types.private_key_type privateKeyType;
            types.public_key_type pubKeyType;
            account_object accountObject = this.list_my_accounts().get(i);
            String account_name = accountObject.name.toString();
            if (!account_name.equals(accountName) || (pubKeyType = accountObject.owner.get_keys().get(0)) == null || (privateKeyType = this.mHashMapPub2Priv.get(pubKeyType)) == null) continue;
            result = privateKeyType.toString();
        }
        return result;
    }

    public String getAccountNameById(String account_id) {
        String result = "";
        for (int i = 0; i < this.list_my_accounts().size(); ++i) {
            account_object accountObject = this.list_my_accounts().get(i);
            String accountid = accountObject.id.toString();
            if (!accountid.equals(account_id)) continue;
            result = accountObject.name.toString();
            break;
        }
        return result;
    }

    public int load_wallet_file(String strFileName, String password) {
        try {
            FileInputStream fileInputStream = new FileInputStream(strFileName);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            Gson gson = global_config_object.getInstance().getGsonBuilder().create();
            this.mWalletObject = (wallet_object)gson.fromJson((Reader)inputStreamReader, wallet_object.class);
            return 0;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
            return -1;
        }
        catch (JsonIOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int set_passwrod(String strPassword) {
        this.mCheckSum = sha512_object.create_from_string(strPassword);
        this.lock();
        return 0;
    }

    public List<account_object> list_my_accounts() {
        ArrayList<account_object> accountObjectList = new ArrayList<account_object>();
        if (this.mWalletObject != null) {
            accountObjectList.addAll(this.mWalletObject.my_accounts);
        }
        return accountObjectList;
    }

    public account_object get_account(String strAccountNameOrId) throws NetworkStatusException {
        object_id accountObjectId = object_id.create_from_string(strAccountNameOrId);
        if (accountObjectId == null) {
            List<account_object> listAccountObject = this.lookup_account_names(strAccountNameOrId);
            if (listAccountObject == null) {
                return null;
            }
            if (listAccountObject.isEmpty()) {
                return null;
            }
            return listAccountObject.get(0);
        }
        ArrayList<object_id<account_object>> listAccountObjectId = new ArrayList<object_id<account_object>>();
        listAccountObjectId.add(accountObjectId);
        List<account_object> listAccountObject = this.mWebsocketApi.get_accounts(listAccountObjectId);
        if (listAccountObject == null) {
            return null;
        }
        if (listAccountObject.isEmpty()) {
            return null;
        }
        return listAccountObject.get(0);
    }

    public List<account_object> get_accounts(List<object_id<account_object>> listAccountObjectId) throws NetworkStatusException {
        return this.mWebsocketApi.get_accounts(listAccountObjectId);
    }

    public String get_Fee(String id, int op) throws NetworkStatusException {
        return this.mWebsocketApi.get_Fee(id, op);
    }

    public List<account_object> lookup_account_names(String strAccountName) throws NetworkStatusException {
        return this.mWebsocketApi.lookup_account_names(strAccountName);
    }

    public List<asset> list_account_balance(object_id<account_object> accountId) throws NetworkStatusException {
        return this.mWebsocketApi.list_account_balances(accountId);
    }

    public List<operation_history_object> get_account_history(object_id<account_object> accountId, int nLimit) throws NetworkStatusException {
        return this.mWebsocketApi.get_account_history(accountId, nLimit);
    }

    public operation_types_histoy_object get_account_history_by_operations(String accountIdOrName, List<Integer> operation_types, int start, int nLimit) throws NetworkStatusException {
        object_id<account_object> id = object_id.create_from_string(accountIdOrName);
        if (id == null) {
            List<account_object> list = this.lookup_account_names(accountIdOrName);
            if (list.size() == 0) {
                return null;
            }
            id = list.get((int)0).id;
        }
        return this.mWebsocketApi.get_account_history_by_operations(id, operation_types, start, nLimit);
    }

    public List<operation_history_object> get_account_history_with_last_id(object_id<account_object> accountId, int nLimit, String id) throws NetworkStatusException {
        List<operation_history_object> list = this.mWebsocketApi.get_account_history_with_last_id(accountId, nLimit, id);
        for (operation_history_object ob : list) {
            if (ob.op.nOperationType != 0) continue;
            operations.transfer_operation transfer = (operations.transfer_operation)ob.op.operationContent;
            if (transfer.memo != null) {
                ob.memo = this.decrypt_memo_message(transfer.memo);
            }
            asset_object asset2 = this.lookup_asset_symbols(transfer.amount.asset_id.toString());
            account_object from = this.mWebsocketApi.get_account(transfer.from.toString());
            account_object to = this.mWebsocketApi.get_account(transfer.to.toString());
            asset_object fee = this.lookup_asset_symbols(transfer.fee.asset_id.toString());
            ob.description = "Transfer " + CalculateUtils.div(transfer.amount.amount, Double.parseDouble(asset2.get_scaled_precision() + ""), 5) + " " + asset2.symbol + " from " + from.name + " to " + to.name + " (Fee: " + String.valueOf((float)transfer.fee.amount / Float.parseFloat(String.valueOf(fee.get_scaled_precision()))) + " " + fee.symbol + ")";
        }
        return list;
    }

    public sha256_object get_chain_id() throws Exception {
        return this.mWebsocketApi.get_chain_id();
    }

    public List<HistoryResponseModel.DataBean> get_transfer_history(object_id<account_object> accountId, int nLimit) throws NetworkStatusException, JSONException, Exception {
        return this.mWebsocketApi.get_transfer_history(accountId, nLimit);
    }

    public List<HistoryResponseModel.DataBean> get_transfer_history_by_flag(object_id<account_object> accountId, int nLimit, String flag) throws NetworkStatusException, JSONException, Exception {
        return this.mWebsocketApi.get_transfer_history_by_flag(accountId, nLimit, flag);
    }

    public List<asset_object> list_assets_obj(String strLowerBound, int nLimit) throws NetworkStatusException {
        return this.mWebsocketApi.list_assets(strLowerBound, nLimit);
    }

    public List<asset_object> get_assets(List<object_id<asset_object>> listAssetObjectId) throws NetworkStatusException {
        return this.mWebsocketApi.get_assets(listAssetObjectId);
    }

    public block_header get_block_header(int nBlockNumber) throws NetworkStatusException {
        return this.mWebsocketApi.get_block_header(nBlockNumber);
    }

    public block_object get_block(int nBlockNumber) throws NetworkStatusException {
        return this.mWebsocketApi.get_block(nBlockNumber);
    }

    public asset_object lookup_asset_symbols(String strAssetSymbol) throws NetworkStatusException {
        return this.mWebsocketApi.lookup_asset_symbols(strAssetSymbol);
    }

    public String lookup_asset_symbols_rate(String strAssetSymbol) throws NetworkStatusException {
        return this.mWebsocketApi.lookup_asset_symbols_rate(strAssetSymbol);
    }

    public int import_brain_key(String strAccountNameOrId, String strBrainKey) throws NetworkStatusException, NoSuchAlgorithmException, UnsupportedEncodingException {
        account_object accountObject = this.get_account(strAccountNameOrId);
        if (accountObject == null) {
            return -4;
        }
        HashMap<types.public_key_type, types.private_key_type> mapPublic2Private = new HashMap<types.public_key_type, types.private_key_type>();
        for (int i = 0; i < 10; ++i) {
            String encoded = String.format("%s %d", strBrainKey, i);
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            byte[] bytes = md.digest(encoded.getBytes("UTF-8"));
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            byte[] result = sha256.digest(bytes);
            ECKey ecKey = ECKey.fromPrivate((byte[])result);
            private_key privateKey = new private_key(ecKey.getPrivKeyBytes());
            types.private_key_type privateKeyType = new types.private_key_type(privateKey);
            types.public_key_type publicKeyType = new types.public_key_type(privateKey.get_public_key());
            if (!accountObject.active.is_public_key_type_exist(publicKeyType) && !accountObject.owner.is_public_key_type_exist(publicKeyType) && !accountObject.options.memo_key.compare(publicKeyType)) continue;
            mapPublic2Private.put(publicKeyType, privateKeyType);
        }
        if (mapPublic2Private.isEmpty()) {
            return -5;
        }
        this.mWalletObject.update_account(accountObject);
        ArrayList listPublicKeyType = new ArrayList();
        listPublicKeyType.addAll(mapPublic2Private.keySet());
        this.mWalletObject.extra_keys.put(accountObject.id, listPublicKeyType);
        this.mHashMapPub2Priv.putAll(mapPublic2Private);
        this.encrypt_keys();
        return 0;
    }

    public int import_key(String account_name_or_id, String wif_key) throws NetworkStatusException {
        if (this.is_locked() && !this.is_new()) {
            return -1;
        }
        types.private_key_type privateKeyType = new types.private_key_type(wif_key);
        public_key publicKey = privateKeyType.getPrivateKey().get_public_key();
        types.public_key_type publicKeyType = new types.public_key_type(publicKey);
        account_object accountObject = this.get_account(account_name_or_id);
        if (accountObject == null) {
            return -4;
        }
        if (!(accountObject.active.is_public_key_type_exist(publicKeyType) || accountObject.owner.is_public_key_type_exist(publicKeyType) || accountObject.options.memo_key.compare(publicKeyType))) {
            return -1;
        }
        this.mWalletObject.update_account(accountObject);
        ArrayList<types.public_key_type> listPublicKeyType = new ArrayList<types.public_key_type>();
        listPublicKeyType.add(publicKeyType);
        this.mWalletObject.extra_keys.put(accountObject.id, listPublicKeyType);
        this.mHashMapPub2Priv.put(publicKeyType, privateKeyType);
        this.encrypt_keys();
        return 0;
    }

    public int import_keys(String account_name_or_id, String wif_key_1, String wif_key_2) throws NetworkStatusException {
        assert (!this.is_locked() && !this.is_new());
        types.private_key_type privateKeyType1 = new types.private_key_type(wif_key_1);
        types.private_key_type privateKeyType2 = new types.private_key_type(wif_key_2);
        public_key publicKey1 = privateKeyType1.getPrivateKey().get_public_key();
        public_key publicKey2 = privateKeyType1.getPrivateKey().get_public_key();
        types.public_key_type publicKeyType1 = new types.public_key_type(publicKey1);
        types.public_key_type publicKeyType2 = new types.public_key_type(publicKey2);
        account_object accountObject = this.get_account(account_name_or_id);
        if (accountObject == null) {
            return -4;
        }
        if (!(accountObject.active.is_public_key_type_exist(publicKeyType1) || accountObject.owner.is_public_key_type_exist(publicKeyType1) || accountObject.options.memo_key.compare(publicKeyType1))) {
            return -1;
        }
        if (!(accountObject.active.is_public_key_type_exist(publicKeyType2) || accountObject.owner.is_public_key_type_exist(publicKeyType2) || accountObject.options.memo_key.compare(publicKeyType2))) {
            return -1;
        }
        this.mWalletObject.update_account(accountObject);
        ArrayList<types.public_key_type> listPublicKeyType = new ArrayList<types.public_key_type>();
        listPublicKeyType.add(publicKeyType1);
        listPublicKeyType.add(publicKeyType2);
        this.mWalletObject.extra_keys.put(accountObject.id, listPublicKeyType);
        this.mHashMapPub2Priv.put(publicKeyType1, privateKeyType1);
        this.mHashMapPub2Priv.put(publicKeyType2, privateKeyType2);
        this.encrypt_keys();
        return 0;
    }

    public int import_account_password(String strAccountName, String strPassword) throws NetworkStatusException {
        private_key privateActiveKey = private_key.from_seed(strAccountName + "active" + strPassword);
        private_key privateOwnerKey = private_key.from_seed(strAccountName + "owner" + strPassword);
        types.public_key_type publicActiveKeyType = new types.public_key_type(privateActiveKey.get_public_key());
        types.public_key_type publicOwnerKeyType = new types.public_key_type(privateOwnerKey.get_public_key());
        account_object accountObject = this.get_account(strAccountName);
        if (accountObject == null) {
            return -4;
        }
        if (!accountObject.active.is_public_key_type_exist(publicActiveKeyType) && !accountObject.owner.is_public_key_type_exist(publicOwnerKeyType)) {
            return -6;
        }
        ArrayList<types.public_key_type> listPublicKeyType = new ArrayList<types.public_key_type>();
        listPublicKeyType.add(publicActiveKeyType);
        listPublicKeyType.add(publicOwnerKeyType);
        this.mWalletObject.update_account(accountObject);
        this.mWalletObject.extra_keys.put(accountObject.id, listPublicKeyType);
        this.mHashMapPub2Priv.put(publicActiveKeyType, new types.private_key_type(privateActiveKey));
        this.mHashMapPub2Priv.put(publicOwnerKeyType, new types.private_key_type(privateOwnerKey));
        this.encrypt_keys();
        return 0;
    }

    public asset transfer_calculate_fee(String strAmount, String strAssetSymbol, String strMemo) throws NetworkStatusException {
        asset_object assetObject;
        object_id assetObjectId = object_id.create_from_string(strAssetSymbol);
        if (assetObjectId == null) {
            assetObject = this.lookup_asset_symbols(strAssetSymbol);
        } else {
            ArrayList<object_id<asset_object>> listAssetObjectId = new ArrayList<object_id<asset_object>>();
            listAssetObjectId.add(assetObjectId);
            assetObject = this.get_assets(listAssetObjectId).get(0);
        }
        if (assetObject == null) {
            return null;
        }
        operations.transfer_operation transferOperation = new operations.transfer_operation();
        transferOperation.from = new object_id<account_object>(0, account_object.class);
        transferOperation.to = new object_id<account_object>(0, account_object.class);
        transferOperation.amount = assetObject.amount_from_string(strAmount);
        transferOperation.extensions = new HashSet<types.void_t>();
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 0;
        operationType.operationContent = transferOperation;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        return transferOperation.fee;
    }

    public signed_transaction transfer(String strFrom, String strTo, String strAmount, String strAssetSymbol, String strMemo, String amount_to_fee, String symbol_to_fee) throws NetworkStatusException {
        asset_object assetObject;
        object_id assetObjectId = object_id.create_from_string(strAssetSymbol);
        if (assetObjectId == null) {
            assetObject = this.lookup_asset_symbols(strAssetSymbol);
        } else {
            ArrayList<object_id<asset_object>> listAssetObjectId = new ArrayList<object_id<asset_object>>();
            listAssetObjectId.add(assetObjectId);
            assetObject = this.get_assets(listAssetObjectId).get(0);
        }
        if (assetObject == null) {
            return null;
        }
        account_object accountObjectFrom = this.get_account(strFrom);
        account_object accountObjectTo = this.get_account(strTo);
        if (accountObjectTo == null) {
            return null;
        }
        operations.transfer_operation transferOperation = new operations.transfer_operation();
        transferOperation.from = accountObjectFrom.id;
        transferOperation.to = accountObjectTo.id;
        transferOperation.amount = assetObject.amount_from_string(strAmount);
        transferOperation.extensions = new HashSet<types.void_t>();
        if (!TextUtils.isEmpty(strMemo)) {
            transferOperation.memo = new memo_data();
            transferOperation.memo.from = accountObjectFrom.options.memo_key;
            transferOperation.memo.to = accountObjectTo.options.memo_key;
            types.private_key_type privateKeyType = this.mHashMapPub2Priv.get(accountObjectFrom.options.memo_key);
            if (privateKeyType == null || privateKeyType.getPrivateKey() == null) {
                return null;
            }
            transferOperation.memo.set_message(privateKeyType.getPrivateKey(), accountObjectTo.options.memo_key.getPublicKey(), strMemo, 0L);
            transferOperation.memo.get_message(privateKeyType.getPrivateKey(), accountObjectTo.options.memo_key.getPublicKey());
        }
        if (!TextUtils.isEmpty(symbol_to_fee)) {
            object_id feeAssetObjectId = object_id.create_from_string(symbol_to_fee);
            ArrayList<object_id<asset_object>> listAssetObjectId = new ArrayList<object_id<asset_object>>();
            listAssetObjectId.add(feeAssetObjectId);
            asset_object feeAssetObject = this.get_assets(listAssetObjectId).get(0);
            transferOperation.fee = feeAssetObject.amount_from_string(amount_to_fee);
        }
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 0;
        operationType.operationContent = transferOperation;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        if (transferOperation.fee == null) {
            this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        }
        return this.sign_transaction(tx);
    }

    public asset calculate_sell_asset_fee(String amountToSell, asset_object assetToSell, String minToReceive, asset_object assetToReceive, global_property_object globalPropertyObject) {
        operations.limit_order_create_operation op = new operations.limit_order_create_operation();
        op.amount_to_sell = assetToSell.amount_from_string(amountToSell);
        op.min_to_receive = assetToReceive.amount_from_string(minToReceive);
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 1;
        operationType.operationContent = op;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, globalPropertyObject.parameters.current_fees);
        return op.fee;
    }

    public asset calculate_sell_fee(asset_object assetToSell, asset_object assetToReceive, double rate, double amount, global_property_object globalPropertyObject) {
        String strAmount = Double.toString(amount);
        String strMinToReceive = Double.toString(rate * amount);
        if (strAmount == null) {
            return null;
        }
        if (strMinToReceive == null) {
            return null;
        }
        return this.calculate_sell_asset_fee(strAmount, assetToSell, strMinToReceive, assetToReceive, globalPropertyObject);
    }

    public asset calculate_buy_fee(asset_object assetToReceive, asset_object assetToSell, double rate, double amount, global_property_object globalPropertyObject) {
        String strAmount = Double.toString(rate * amount);
        if (strAmount == null) {
            return null;
        }
        String strMinToReceive = Double.toString(amount);
        if (strMinToReceive == null) {
            return null;
        }
        return this.calculate_sell_asset_fee(strAmount, assetToSell, strMinToReceive, assetToReceive, globalPropertyObject);
    }

    public signed_transaction sell_asset(String amountToSell, String symbolToSell, String minToReceive, String symbolToReceive, int timeoutSecs, boolean fillOrKill, String amount_to_fee, String symbol_to_fee, int index) throws NetworkStatusException {
        operations.limit_order_create_operation op = new operations.limit_order_create_operation();
        if (index < this.list_my_accounts().size()) {
            account_object accountObject = this.list_my_accounts().get(index);
            op.seller = accountObject.id;
        }
        BigDecimal db = new BigDecimal(minToReceive);
        String minToReceiveStr = db.toPlainString();
        BigDecimal db2 = new BigDecimal(amountToSell);
        String amountToSellStr = db2.toPlainString();
        asset_object assetToSell = this.lookup_asset_symbols(symbolToSell);
        asset_object assetToReceive = this.lookup_asset_symbols(symbolToReceive);
        if (assetToSell == null || assetToReceive == null) {
            return null;
        }
        op.amount_to_sell = assetToSell.amount_from_string(amountToSellStr);
        op.min_to_receive = assetToReceive.amount_from_string(minToReceiveStr);
        op.expiration = timeoutSecs > 0 ? new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutSecs)) : new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(360L));
        op.fill_or_kill = fillOrKill;
        op.extensions = new HashSet<types.void_t>();
        if (!TextUtils.isEmpty(symbol_to_fee)) {
            object_id feeAssetObjectId = object_id.create_from_string(symbol_to_fee);
            ArrayList<object_id<asset_object>> listAssetObjectId = new ArrayList<object_id<asset_object>>();
            listAssetObjectId.add(feeAssetObjectId);
            asset_object feeAssetObject = this.get_assets(listAssetObjectId).get(0);
            op.fee = feeAssetObject.amount_from_string(amount_to_fee);
        }
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 1;
        operationType.operationContent = op;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        if (op.fee == null) {
            if (null != this.get_global_properties().parameters) {
                this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
            } else {
                return null;
            }
        }
        return this.sign_transaction(tx);
    }

    public signed_transaction borrow_asset(String amount_to_borrow, String asset_symbol, String amount_to_collateral, int index) throws NetworkStatusException {
        operations.call_order_update_operation op = new operations.call_order_update_operation();
        if (index < this.list_my_accounts().size()) {
            account_object accountObject = this.list_my_accounts().get(index);
            op.funding_account = accountObject.id;
        }
        asset_object asset_borrow = this.lookup_asset_symbols(asset_symbol);
        object_id<asset_object> base_asset = new object_id<asset_object>(0, asset_object.class);
        ArrayList<object_id<asset_object>> list = new ArrayList<object_id<asset_object>>();
        list.add(base_asset);
        asset_object asset_collateratl = this.get_assets(list).get(0);
        op.delta_debt = asset_borrow.amount_from_string(amount_to_borrow);
        op.delta_collateral = asset_collateratl.amount_from_string(amount_to_collateral);
        op.extensions = new HashSet<types.void_t>();
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 3;
        operationType.operationContent = op;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        if (op.fee == null) {
            if (null != this.get_global_properties().parameters) {
                this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
            } else {
                return null;
            }
        }
        return this.sign_transaction(tx);
    }

    public signed_transaction create_transcation(operations.base_operation base_operation2) throws NetworkStatusException {
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = new operations.operation_id_map().getIdByOperationObject(base_operation2.getClass());
        operationType.operationContent = base_operation2;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        return this.sign_transaction(tx);
    }

    public signed_transaction sell(String symbolToSell, String symbolToReceive, double minToReceive, double amount, String amount_to_fee, String symbol_to_fee, int index) throws NetworkStatusException {
        return this.sell_asset(Double.toString(amount), symbolToSell, minToReceive + "", symbolToReceive, 0, false, amount_to_fee, symbol_to_fee, index);
    }

    public signed_transaction sell(String symbolToSell, String symbolToReceive, double rate, double amount, int timeoutSecs, String amount_to_fee, String symbol_to_fee, int index) throws NetworkStatusException {
        String minToReceive = Double.toString(rate * amount);
        if (minToReceive.contains(".") && (symbolToReceive.equalsIgnoreCase("BTC") || symbolToReceive.equalsIgnoreCase("LTC") || symbolToReceive.equalsIgnoreCase("ETH"))) {
            minToReceive = NumberUtils.formatNumber8(Double.toString(rate * amount) + "");
        }
        return this.sell_asset(Double.toString(amount), symbolToSell, minToReceive, symbolToReceive, timeoutSecs, false, amount_to_fee, symbol_to_fee, index);
    }

    public signed_transaction buy(String symbolToReceive, String symbolToSell, double amountToSell, double amount, String amount_to_fee, String symbol_to_fee, int index) throws NetworkStatusException {
        return this.sell_asset(amountToSell + "", symbolToSell, Double.toString(amount), symbolToReceive, 0, false, amount_to_fee, symbol_to_fee, index);
    }

    public signed_transaction buy(String symbolToReceive, String symbolToSell, double rate, double amount, int timeoutSecs, String amount_to_fee, String symbol_to_fee, int index) throws NetworkStatusException {
        String amountToSell = Double.toString(rate * amount);
        if (amountToSell.contains(".")) {
            amountToSell = symbolToSell.equalsIgnoreCase("BTC") || symbolToSell.equalsIgnoreCase("LTC") || symbolToSell.equalsIgnoreCase("ETH") ? NumberUtils.formatNumber8(Double.toString(rate * amount) + "") : NumberUtils.formatNumber(Double.toString(rate * amount) + "");
        }
        return this.sell_asset(amountToSell, symbolToSell, Double.toString(amount), symbolToReceive, 0, false, amount_to_fee, symbol_to_fee, index);
    }

    public signed_transaction cancel_order(object_id<limit_order_object> id) throws NetworkStatusException {
        operations.limit_order_cancel_operation op = new operations.limit_order_cancel_operation();
        op.fee_paying_account = this.mWebsocketApi.get_limit_order(id).seller;
        op.order = id;
        op.extensions = new HashSet<types.void_t>();
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 2;
        operationType.operationContent = op;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        return this.sign_transaction(tx);
    }

    public global_property_object get_global_properties() throws NetworkStatusException {
        return this.mWebsocketApi.get_global_properties();
    }

    public block_chain_info get_info() throws NetworkStatusException {
        block_chain_info bchain = new block_chain_info();
        global_property_object global_props = this.get_global_properties();
        if (global_props == null) {
            return null;
        }
        dynamic_global_property_object dynamic_props = this.get_dynamic_global_properties();
        if (dynamic_props == null) {
            return null;
        }
        if (dynamic_props != null) {
            bchain.head_block_num = Integer.toString(dynamic_props.head_block_number);
            bchain.head_block_id = dynamic_props.head_block_id.toString();
            Date currentDateTime = new Date();
            long diff = currentDateTime.getTime() - dynamic_props.time.getTime();
            if (diff < 0L) {
                diff = dynamic_props.time.getTime() - currentDateTime.getTime();
            }
            long sec = diff / 1000L;
            bchain.head_block_age = sec + " second old";
            Date maintenanceDateTime = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                String dateStr = dynamic_props.next_maintenance_time.replace("T", " ");
                maintenanceDateTime = sdf.parse(dateStr);
                long diff_main = currentDateTime.getTime() - maintenanceDateTime.getTime();
                if (diff_main < 0L) {
                    diff_main = maintenanceDateTime.getTime() - currentDateTime.getTime();
                }
                long hour = diff_main / 3600000L;
                bchain.next_maintenance_time = hour + " hours in the future";
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (global_props != null) {
            bchain.active_committee_memberts_count = global_props.active_committee_members.size();
            bchain.active_witnesses_count = global_props.active_witnesses.size();
        }
        return bchain;
    }

    public dynamic_global_property_object get_dynamic_global_properties() throws NetworkStatusException {
        return this.mWebsocketApi.get_dynamic_global_properties();
    }

    public signed_transaction upgrade_account(String name, boolean upgrade_to_lifetime_member) throws NetworkStatusException {
        account_object object = this.mWebsocketApi.get_account(name);
        operations.account_upgrade_operation operation = new operations.account_upgrade_operation();
        operation.account_to_upgrade = object.id;
        operation.upgrade_to_lifetime_member = upgrade_to_lifetime_member;
        operation.extensions = new HashSet<types.void_t>();
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 8;
        operationType.operationContent = operation;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        return this.sign_transaction(tx);
    }

    public signed_transaction withdraw_vesting(String name_or_id, String vesting_name, String amount, String asset_symbol) throws NetworkStatusException {
        object_id object_witness_id = object_id.create_from_string(name_or_id);
        Object vesting_object = null;
        if (object_witness_id == null) {
            return null;
        }
        account_object vesting_owner = this.get_account(vesting_name);
        if (vesting_owner == null) {
            return null;
        }
        asset_object symbol = this.lookup_asset_symbols(asset_symbol);
        if (symbol == null) {
            return null;
        }
        operations.withdraw_vesting_operation operation = new operations.withdraw_vesting_operation();
        operation.vesting_balance = object_witness_id;
        operation.owner = vesting_owner.id;
        operation.amount = symbol.amount_from_string(amount);
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 33;
        operationType.operationContent = operation;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        return this.sign_transaction(tx);
    }

    public signed_transaction create_asset(String issuer, String symbol, short precision, asset_options common, bitasset_options bitasset_opts) throws NetworkStatusException {
        assert (this.lookup_asset_symbols(symbol) == null);
        List<account_object> account_list = this.lookup_account_names(issuer);
        assert (account_list != null);
        assert (account_list.size() != 0);
        account_object issuer_account = account_list.get(0);
        operations.asset_create_operation operation = new operations.asset_create_operation();
        operation.issuer = issuer_account.id;
        operation.precision = precision;
        operation.symbol = symbol;
        operation.common_options = common;
        operation.bitasset_opts = bitasset_opts;
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 10;
        operationType.operationContent = operation;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        return this.sign_transaction(tx);
    }

    public signed_transaction change_account_key(String account, String pubkey) throws Exception {
        account_object account_object2 = this.get_account(account);
        assert (account_object2 != null);
        operations.account_update_operation operation = new operations.account_update_operation();
        operation.account = account_object2.id;
        types.public_key_type public_key_type2 = new types.public_key_type(pubkey);
        operation.active = new authority(1, public_key_type2, 1);
        operation.owner = new authority(1, public_key_type2, 1);
        operation.new_options = account_object2.options;
        operation.new_options.memo_key = public_key_type2;
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 6;
        operationType.operationContent = operation;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        return this.sign_transaction(tx);
    }

    public signed_transaction issue_asset(String to_account, String amount, String symbol, String memo) throws Exception {
        asset_object issue_asset = this.lookup_asset_symbols(symbol);
        assert (issue_asset == null);
        List<account_object> account_list = this.lookup_account_names(to_account);
        assert (account_list != null);
        assert (account_list.size() != 0);
        account_object to_account_obj = account_list.get(0);
        operations.asset_issue_operation operation = new operations.asset_issue_operation();
        operation.issuer = issue_asset.issuer;
        operation.asset_to_issue = issue_asset.amount_from_string(amount);
        operation.issue_to_account = to_account_obj.id;
        if (memo != null && memo.length() != 0) {
            account_list = this.lookup_account_names(issue_asset.issuer.toString());
            assert (account_list != null);
            assert (account_list.size() != 0);
            account_object from_account = account_list.get(0);
            operation.memo = new memo_data();
            types.private_key_type privateKeyType = this.mHashMapPub2Priv.get(from_account.options.memo_key);
            operation.memo.set_message(privateKeyType.getPrivateKey(), to_account_obj.options.memo_key.getPublicKey(), memo, 0L);
            operation.memo.get_message(privateKeyType.getPrivateKey(), to_account_obj.options.memo_key.getPublicKey());
        }
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 14;
        operationType.operationContent = operation;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        return this.sign_transaction(tx);
    }

    public signed_transaction publish_asset_feed(String publishing_account, String symbol, long core_exchange_base_amount, long core_exchange_quote_amount, double maintenance_collateral_ratio, double maximum_short_squeeze_ratio) throws Exception {
        assert (maintenance_collateral_ratio >= 1.0 && maintenance_collateral_ratio <= 10.0);
        assert (maximum_short_squeeze_ratio >= 1.0 && maximum_short_squeeze_ratio <= 10.0);
        List<account_object> account_list = this.lookup_account_names(publishing_account);
        assert (account_list != null);
        account_object account = account_list.get(0);
        assert (account != null);
        asset_object asset2 = this.lookup_asset_symbols(symbol);
        asset_object asset_base = this.lookup_asset_symbols("1.3.0");
        assert (asset2 != null);
        price_feed feed = new price_feed();
        feed.settlement_price = new price(new asset(core_exchange_base_amount, asset2.id), new asset(core_exchange_quote_amount, asset_base.id));
        feed.core_exchange_rate = new price(new asset(core_exchange_base_amount, asset2.id), new asset(core_exchange_quote_amount, asset_base.id));
        feed.maintenance_collateral_ratio = Double.valueOf(maintenance_collateral_ratio * 1000.0).shortValue();
        feed.maximum_short_squeeze_ratio = Double.valueOf(maximum_short_squeeze_ratio * 1000.0).shortValue();
        operations.asset_publish_feed_operation operation = new operations.asset_publish_feed_operation();
        operation.publisher = account.id;
        operation.asset_id = asset2.id;
        operation.feed = feed;
        operation.extensions = new HashSet();
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 19;
        operationType.operationContent = operation;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        return this.sign_transaction(tx);
    }

    public signed_transaction create_account_with_pub_key(String publicKey, String strAccountName, String strRegistar, String strReferrer, int refferPercent) throws NetworkStatusException {
        if (refferPercent > 100 || refferPercent < 0) {
            return null;
        }
        types.public_key_type publicOwnerKey = null;
        types.public_key_type publicActiveKey = null;
        types.public_key_type publicMemoKey = null;
        try {
            publicMemoKey = new types.public_key_type(publicKey);
            publicActiveKey = new types.public_key_type(publicKey);
            publicOwnerKey = new types.public_key_type(publicKey);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        operations.account_create_operation operation = new operations.account_create_operation();
        operation.name = strAccountName;
        if (operation.options == null) {
            operation.options = new types.account_options();
        }
        operation.options.num_committee = 0;
        operation.options.num_witness = 0;
        operation.options.voting_account = new object_id(1, 2, 5);
        operation.options.votes = new HashSet();
        operation.options.extensions = new HashSet();
        operation.extensions = new HashMap();
        if (publicMemoKey != null) {
            operation.options.memo_key = publicOwnerKey;
        }
        operation.active = new authority(1, publicActiveKey, 1);
        operation.owner = new authority(1, publicOwnerKey, 1);
        account_object accountRegistrar = this.get_account(strRegistar);
        account_object accountReferr = this.get_account(strReferrer);
        operation.referrer = accountReferr.id;
        operation.registrar = accountRegistrar.id;
        operation.referrer_percent = refferPercent * 100;
        operations.operation_type operationType = new operations.operation_type();
        operationType.nOperationType = 5;
        operationType.operationContent = operation;
        signed_transaction tx = new signed_transaction();
        tx.operations = new ArrayList();
        tx.operations.add(operationType);
        tx.extensions = new HashSet();
        this.set_operation_fees(tx, this.get_global_properties().parameters.current_fees);
        return this.sign_create_account_transaction(tx);
    }

    private signed_transaction sign_create_account_transaction(signed_transaction tx) throws NetworkStatusException {
        Object accountObject;
        transaction.required_authorities requiresAuthorities = tx.get_required_authorities();
        HashSet<object_id<account_object>> req_active_approvals = new HashSet<object_id<account_object>>();
        req_active_approvals.addAll(requiresAuthorities.active);
        HashSet<object_id<account_object>> req_owner_approvals = new HashSet<object_id<account_object>>();
        req_owner_approvals.addAll(requiresAuthorities.owner);
        for (authority authorityObject : requiresAuthorities.other) {
            for (object_id<account_object> accountObjectId : authorityObject.account_auths().keySet()) {
                req_active_approvals.add(accountObjectId);
            }
        }
        HashSet<object_id<account_object>> accountObjectAll = new HashSet<object_id<account_object>>();
        accountObjectAll.addAll(req_active_approvals);
        accountObjectAll.addAll(req_owner_approvals);
        ArrayList<object_id<account_object>> listAccountObjectId = new ArrayList<object_id<account_object>>();
        listAccountObjectId.addAll(accountObjectAll);
        List<account_object> listAccountObject = this.get_accounts(listAccountObjectId);
        HashMap<object_id<account_object>, account_object> hashMapIdToObject = new HashMap<object_id<account_object>, account_object>();
        for (account_object account_object2 : listAccountObject) {
            hashMapIdToObject.put(account_object2.id, account_object2);
        }
        HashSet<types.public_key_type> approving_key_set = new HashSet<types.public_key_type>();
        for (object_id object_id2 : req_active_approvals) {
            accountObject = (account_object)hashMapIdToObject.get(object_id2);
            approving_key_set.addAll(((account_object)accountObject).active.get_keys());
        }
        for (object_id object_id3 : req_owner_approvals) {
            accountObject = (account_object)hashMapIdToObject.get(object_id3);
            approving_key_set.addAll(((account_object)accountObject).owner.get_keys());
        }
        for (authority authority2 : requiresAuthorities.other) {
            for (types.public_key_type public_key_type2 : authority2.get_keys()) {
                approving_key_set.add(public_key_type2);
            }
        }
        dynamic_global_property_object dynamic_global_property_object2 = this.get_dynamic_global_properties();
        tx.set_reference_block(dynamic_global_property_object2.head_block_id);
        Date date = dynamic_global_property_object2.time;
        Calendar calender = Calendar.getInstance();
        calender.setTime(date);
        calender.add(13, 30);
        Date date2 = calender.getTime();
        tx.set_expiration(date2);
        for (types.public_key_type pulicKeyType : approving_key_set) {
            types.private_key_type privateKey = this.mHashMapPub2Priv.get(pulicKeyType);
            if (privateKey == null) continue;
            tx.sign(privateKey, this.mWalletObject.chain_id);
        }
        int n = this.mWebsocketApi.broadcast_json_transaction(tx, "");
        if (n == 0) {
            return tx;
        }
        return null;
    }

    private signed_transaction sign_transaction(signed_transaction tx) throws NetworkStatusException {
        Object accountObject;
        transaction.required_authorities requiresAuthorities = tx.get_required_authorities();
        HashSet<object_id<account_object>> req_active_approvals = new HashSet<object_id<account_object>>();
        req_active_approvals.addAll(requiresAuthorities.active);
        HashSet<object_id<account_object>> req_owner_approvals = new HashSet<object_id<account_object>>();
        req_owner_approvals.addAll(requiresAuthorities.owner);
        for (authority authorityObject : requiresAuthorities.other) {
            for (object_id<account_object> accountObjectId : authorityObject.account_auths().keySet()) {
                req_active_approvals.add(accountObjectId);
            }
        }
        HashSet<object_id<account_object>> accountObjectAll = new HashSet<object_id<account_object>>();
        accountObjectAll.addAll(req_active_approvals);
        accountObjectAll.addAll(req_owner_approvals);
        ArrayList<object_id<account_object>> listAccountObjectId = new ArrayList<object_id<account_object>>();
        listAccountObjectId.addAll(accountObjectAll);
        List<account_object> listAccountObject = this.get_accounts(listAccountObjectId);
        HashMap<object_id<account_object>, account_object> hashMapIdToObject = new HashMap<object_id<account_object>, account_object>();
        for (account_object account_object2 : listAccountObject) {
            hashMapIdToObject.put(account_object2.id, account_object2);
        }
        HashSet<types.public_key_type> approving_key_set = new HashSet<types.public_key_type>();
        for (object_id object_id2 : req_active_approvals) {
            accountObject = (account_object)hashMapIdToObject.get(object_id2);
            approving_key_set.addAll(((account_object)accountObject).active.get_keys());
        }
        for (object_id object_id3 : req_owner_approvals) {
            accountObject = (account_object)hashMapIdToObject.get(object_id3);
            approving_key_set.addAll(((account_object)accountObject).owner.get_keys());
        }
        for (authority authority2 : requiresAuthorities.other) {
            for (types.public_key_type public_key_type2 : authority2.get_keys()) {
                approving_key_set.add(public_key_type2);
            }
        }
        dynamic_global_property_object dynamic_global_property_object2 = this.get_dynamic_global_properties();
        tx.set_reference_block(dynamic_global_property_object2.head_block_id);
        Date date = dynamic_global_property_object2.time;
        Calendar calender = Calendar.getInstance();
        calender.setTime(date);
        calender.add(13, 43200);
        Date date2 = calender.getTime();
        tx.set_expiration(date2);
        for (types.public_key_type pulicKeyType : approving_key_set) {
            types.private_key_type privateKey = this.mHashMapPub2Priv.get(pulicKeyType);
            if (privateKey == null) continue;
            tx.sign(privateKey, this.mWalletObject.chain_id);
        }
        int n = this.mWebsocketApi.broadcast_transaction(tx);
        if (n == 0) {
            return tx;
        }
        return null;
    }

    public List<CallOrder> get_call_orders(object_id asset_id, Integer limit) throws NetworkStatusException {
        return this.mWebsocketApi.get_call_orders(asset_id, limit);
    }

    public List<bucket_object> get_market_history(object_id<asset_object> assetObjectId1, object_id<asset_object> assetObjectId2, int nBucket, Date dateStart, Date dateEnd) throws NetworkStatusException {
        return this.mWebsocketApi.get_market_history(assetObjectId1, assetObjectId2, nBucket, dateStart, dateEnd);
    }

    public MarketTicker get_ticker(String base, String quote) throws NetworkStatusException {
        return this.mWebsocketApi.get_ticker(base, quote);
    }

    private void set_operation_fees(signed_transaction tx, fee_schedule feeSchedule) {
        for (operations.operation_type operationType : tx.operations) {
            feeSchedule.set_fee(operationType, price.unit_price(new object_id<asset_object>(0, asset_object.class)));
        }
    }

    private private_key derive_private_key(String strWifKey, int nSeqNumber) {
        String strData = strWifKey + " " + nSeqNumber;
        byte[] bytesBuffer = strData.getBytes();
        SHA512Digest digest = new SHA512Digest();
        digest.update(bytesBuffer, 0, bytesBuffer.length);
        byte[] out = new byte[64];
        digest.doFinal(out, 0);
        SHA256Digest digest256 = new SHA256Digest();
        byte[] outSeed = new byte[32];
        byte[] outSeed2 = new byte[64];
        digest256.update(out, 0, out.length);
        digest.doFinal(outSeed2, 0);
        System.arraycopy(outSeed2, 0, outSeed, 0, 32);
        return new private_key(outSeed);
    }

    private int find_first_unused_derived_key_index(private_key privateKey) {
        int first_unused_index = 0;
        int number_of_consecutive_unused_keys = 0;
        String strWifKey = new types.private_key_type(privateKey).toString();
        int key_index = 0;
        while (true) {
            private_key derivedPrivateKey;
            types.public_key_type publicKeyType;
            if (!this.mHashMapPub2Priv.containsKey(publicKeyType = new types.public_key_type((derivedPrivateKey = this.derive_private_key(strWifKey, key_index)).get_public_key()))) {
                if (number_of_consecutive_unused_keys != 0) {
                    if (++number_of_consecutive_unused_keys > 5) {
                        return first_unused_index;
                    }
                } else {
                    first_unused_index = key_index;
                    number_of_consecutive_unused_keys = 1;
                }
            } else {
                first_unused_index = 0;
                number_of_consecutive_unused_keys = 0;
            }
            ++key_index;
        }
    }

    public String decrypt_memo_message(memo_data memoData) {
        assert (!this.is_locked());
        String strMessage = null;
        types.private_key_type privateKeyType = this.mHashMapPub2Priv.get(memoData.to);
        if (privateKeyType != null) {
            strMessage = memoData.get_message(privateKeyType.getPrivateKey(), memoData.from.getPublicKey());
        } else {
            privateKeyType = this.mHashMapPub2Priv.get(memoData.from);
            if (privateKeyType != null) {
                strMessage = memoData.get_message(privateKeyType.getPrivateKey(), memoData.to.getPublicKey());
            }
        }
        return strMessage;
    }

    public List<limit_order_object> get_limit_orders(object_id<asset_object> base, object_id<asset_object> quote, int limit) throws NetworkStatusException {
        return this.mWebsocketApi.get_limit_orders(base, quote, limit);
    }

    public String get_bitasset_data(String symbol) throws NetworkStatusException {
        asset_object asset2 = this.lookup_asset_symbols(symbol);
        if (asset2.bitasset_data_id == null) {
            return null;
        }
        return this.mWebsocketApi.get_object(asset2.bitasset_data_id.toString());
    }

    public String get_object(String object) throws NetworkStatusException {
        return this.mWebsocketApi.get_object(object);
    }

    public AllHistory get_all_history(String baseSymbolId, String qouteSymbolId, int nLimit) throws NetworkStatusException {
        return this.mWebsocketApi.get_all_history(baseSymbolId, qouteSymbolId, nLimit);
    }

    public OrderBook get_order_book(String base, String quote, int limit) throws NetworkStatusException {
        return this.mWebsocketApi.get_order_book(base, quote, limit);
    }

    public List<full_account_object> get_full_accounts(List<String> names, boolean subscribe) throws NetworkStatusException {
        return this.mWebsocketApi.get_full_accounts(names, subscribe);
    }

    public HashMap<types.public_key_type, types.private_key_type> get_wallet_hash() {
        return this.mHashMapPub2Priv;
    }

    public boolean is_public_key_registered(String pub_key) throws NetworkStatusException {
        return this.mWebsocketApi.is_public_key_registered(pub_key);
    }

    public Map<private_key, public_key> generateKeyFromPassword(String account_name, String password) {
        HashMap<private_key, public_key> keys = new HashMap<private_key, public_key>();
        if (account_name != null && password != null) {
            String seed = account_name + "owner" + password;
            private_key privKey = private_key.from_seed(seed);
            public_key pubKey = privKey.get_public_key();
            keys.put(privKey, pubKey);
        }
        return keys;
    }

    public operations.operation_type get_history_object(Integer object) throws NetworkStatusException {
        return this.mWebsocketApi.get_history_object(object);
    }

    static class plain_keys {
        Map<types.public_key_type, String> keys;
        sha512_object checksum;

        plain_keys() {
        }

        public void write_to_encoder(base_encoder encoder2) {
            raw_type rawType = new raw_type();
            rawType.pack(encoder2, UnsignedInteger.fromIntBits((int)this.keys.size()));
            for (Map.Entry<types.public_key_type, String> entry : this.keys.entrySet()) {
                encoder2.write(entry.getKey().key_data);
                byte[] byteValue = entry.getValue().getBytes();
                rawType.pack(encoder2, UnsignedInteger.fromIntBits((int)byteValue.length));
                encoder2.write(byteValue);
            }
            encoder2.write(this.checksum.hash);
        }

        public static plain_keys from_input_stream(InputStream inputStream) {
            plain_keys keysResult = new plain_keys();
            keysResult.keys = new HashMap<types.public_key_type, String>();
            keysResult.checksum = new sha512_object();
            raw_type rawType = new raw_type();
            UnsignedInteger size = rawType.unpack(inputStream);
            try {
                int i = 0;
                while ((long)i < size.longValue()) {
                    types.public_key_type publicKeyType = new types.public_key_type();
                    inputStream.read(publicKeyType.key_data);
                    UnsignedInteger strSize = rawType.unpack(inputStream);
                    byte[] byteBuffer = new byte[strSize.intValue()];
                    inputStream.read(byteBuffer);
                    String strPrivateKey = new String(byteBuffer);
                    keysResult.keys.put(publicKeyType, strPrivateKey);
                    ++i;
                }
                inputStream.read(keysResult.checksum.hash);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return keysResult;
        }
    }

    class wallet_object {
        sha256_object chain_id;
        List<account_object> my_accounts = new ArrayList<account_object>();
        ByteBuffer cipher_keys;
        HashMap<object_id<account_object>, List<types.public_key_type>> extra_keys = new HashMap();

        wallet_object() {
        }

        public void update_account(account_object accountObject) {
            boolean bUpdated = false;
            for (int i = 0; i < this.my_accounts.size(); ++i) {
                if (this.my_accounts.get((int)i).id != accountObject.id) continue;
                this.my_accounts.remove(i);
                this.my_accounts.add(accountObject);
                bUpdated = true;
                break;
            }
            if (!bUpdated) {
                this.my_accounts.add(accountObject);
            }
        }
    }
}

