/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket;

import com.github.chouheiwa.wallet.net.model.AllHistory;
import com.github.chouheiwa.wallet.net.model.HistoryResponseModel;
import com.github.chouheiwa.wallet.socket.BitsharesWalletWraper;
import com.github.chouheiwa.wallet.socket.account_object;
import com.github.chouheiwa.wallet.socket.asset;
import com.github.chouheiwa.wallet.socket.chain.CallOrder;
import com.github.chouheiwa.wallet.socket.chain.asset_object;
import com.github.chouheiwa.wallet.socket.chain.block_header;
import com.github.chouheiwa.wallet.socket.chain.block_object;
import com.github.chouheiwa.wallet.socket.chain.bucket_object;
import com.github.chouheiwa.wallet.socket.chain.dynamic_global_property_object;
import com.github.chouheiwa.wallet.socket.chain.global_config_object;
import com.github.chouheiwa.wallet.socket.chain.global_property_object;
import com.github.chouheiwa.wallet.socket.chain.limit_order_object;
import com.github.chouheiwa.wallet.socket.chain.object_id;
import com.github.chouheiwa.wallet.socket.chain.operation_history_object;
import com.github.chouheiwa.wallet.socket.chain.operation_types_histoy_object;
import com.github.chouheiwa.wallet.socket.chain.operations;
import com.github.chouheiwa.wallet.socket.chain.signed_transaction;
import com.github.chouheiwa.wallet.socket.chain.transaction;
import com.github.chouheiwa.wallet.socket.chain.vesting_balance_object;
import com.github.chouheiwa.wallet.socket.exception.NetworkStatusException;
import com.github.chouheiwa.wallet.socket.fc.crypto.sha256_object;
import com.github.chouheiwa.wallet.socket.full_account_object;
import com.github.chouheiwa.wallet.socket.market.MarketTicker;
import com.github.chouheiwa.wallet.socket.market.OrderBook;
import com.github.chouheiwa.wallet.socket.websocketClient.websocketClient;
import com.github.chouheiwa.wallet.socket.websocketClient.websocketInterface;
import com.github.chouheiwa.wallet.utils.CalculateUtils;
import com.github.chouheiwa.wallet.utils.NumberUtils;
import com.github.chouheiwa.wallet.utils.TextUtils;
import com.github.chouheiwa.wallet.utils.TimeUtils;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class websocket_api
implements websocketInterface {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private int _nDatabaseId = -1;
    private int _nHistoryId = -1;
    private int _nBroadcastId = -1;
    private websocketClient mWebsocket;
    private int mnConnectStatus = WEBSOCKET_CONNECT_INVALID;
    private int mnCliConnectStatus = WEBSOCKET_CONNECT_INVALID;
    public static int WEBSOCKET_CONNECT_INVALID = -1;
    private static int WEBSOCKET_CONNECT_SUCCESS = 0;
    private static int WEBSOCKET_ALL_READY = 0;
    private static int WEBSOCKET_CONNECT_FAIL = 1;
    private AtomicInteger mnCallId = new AtomicInteger(1);
    private HashMap<Integer, IReplyObjectProcess> mHashMapIdToProcess = new HashMap();
    private String gRespJson;
    long startTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpen() {
        websocketClient websocketClient2 = this.mWebsocket;
        synchronized (websocketClient2) {
            this.mnConnectStatus = WEBSOCKET_CONNECT_SUCCESS;
            ((Object)((Object)this.mWebsocket)).notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(String resultMsg) {
        try {
            long endTime = System.currentTimeMillis();
            this.log.info("\u63a5\u6536Send\u8bf7\u6c42" + (endTime - this.startTime));
            Gson gson = new Gson();
            ReplyBase replyObjectBase = (ReplyBase)gson.fromJson(resultMsg, ReplyBase.class);
            IReplyObjectProcess iReplyObjectProcess = null;
            HashMap<Integer, IReplyObjectProcess> hashMap = this.mHashMapIdToProcess;
            synchronized (hashMap) {
                if (this.mHashMapIdToProcess.containsKey(replyObjectBase.id)) {
                    iReplyObjectProcess = this.mHashMapIdToProcess.get(replyObjectBase.id);
                    this.log.info("\u63a5\u6536Send\u8bf7\u6c42  mapid=" + replyObjectBase.id);
                }
            }
            if (iReplyObjectProcess != null) {
                iReplyObjectProcess.processTextToObject(resultMsg + "\t\n");
                iReplyObjectProcess.notify();
            }
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Exception e) {
        if (e instanceof IOException && this.mWebsocket != null) {
            websocketClient websocketClient2 = this.mWebsocket;
            synchronized (websocketClient2) {
                this.mnConnectStatus = WEBSOCKET_CONNECT_FAIL;
                ((Object)((Object)this.mWebsocket)).notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int connect(String ws_server) {
        if (this.mnConnectStatus == WEBSOCKET_ALL_READY) {
            return 0;
        }
        String strServer = ws_server;
        if (TextUtils.isEmpty(strServer)) {
            return -9;
        }
        try {
            this.mWebsocket = new websocketClient(strServer, this);
            this.mWebsocket.connect();
        }
        catch (URISyntaxException e) {
            return -9;
        }
        websocketClient e = this.mWebsocket;
        synchronized (e) {
            if (this.mnConnectStatus == WEBSOCKET_CONNECT_INVALID) {
                try {
                    ((Object)((Object)this.mWebsocket)).wait(10000L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                if (this.mnConnectStatus != WEBSOCKET_CONNECT_SUCCESS) {
                    return -9;
                }
            }
        }
        int nRet = 0;
        try {
            boolean bLogin = this.login("", "");
            if (bLogin) {
                this._nDatabaseId = this.get_websocket_bitshares_api_id("database");
                this._nHistoryId = this.get_websocket_bitshares_api_id("history");
                this._nBroadcastId = this.get_websocket_bitshares_api_id("network_broadcast");
            } else {
                nRet = -9;
            }
        }
        catch (NetworkStatusException e3) {
            e3.printStackTrace();
            nRet = -9;
        }
        if (nRet != 0) {
            this.mWebsocket.close(1000, "");
            this.mWebsocket = null;
            this.mnConnectStatus = WEBSOCKET_CONNECT_INVALID;
        } else {
            this.mnConnectStatus = WEBSOCKET_ALL_READY;
        }
        return nRet;
    }

    public synchronized int close() {
        this.mHashMapIdToProcess.clear();
        if (this.mWebsocket != null) {
            this.mWebsocket.close(1000, "Close");
        }
        this.mWebsocket = null;
        this.mnConnectStatus = WEBSOCKET_CONNECT_INVALID;
        this._nDatabaseId = -1;
        this._nBroadcastId = -1;
        this._nHistoryId = -1;
        return 0;
    }

    private boolean login(String strUserName, String strPassword) throws NetworkStatusException {
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(1);
        callObject.params.add("login");
        ArrayList<String> listLoginParams = new ArrayList<String>();
        listLoginParams.add(strUserName);
        listLoginParams.add(strPassword);
        callObject.params.add(listLoginParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<Boolean>>(){}.getType());
        Reply replyLogin = this.sendForReplyImpl(callObject, replyObject);
        if (replyLogin == null) {
            return false;
        }
        return (Boolean)replyLogin.result;
    }

    private int get_websocket_bitshares_api_id(String strApiName) throws NetworkStatusException {
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(1);
        callObject.params.add(strApiName);
        ArrayList listDatabaseParams = new ArrayList();
        callObject.params.add(listDatabaseParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<Integer>>(){}.getType());
        Reply replyApiId = this.sendForReplyImpl(callObject, replyObject);
        if (replyApiId == null) {
            return -1;
        }
        return (Integer)replyApiId.result;
    }

    private int get_database_api_id() throws NetworkStatusException {
        if (this._nDatabaseId != -1) {
            return this._nDatabaseId;
        }
        int id = this.get_websocket_bitshares_api_id("database");
        if (-1 != id) {
            this._nDatabaseId = id;
        } else {
            this.close();
            this.connect(this.mWebsocket.getURI().toString());
            this._nDatabaseId = this.get_websocket_bitshares_api_id("database");
        }
        return this._nDatabaseId;
    }

    private int get_history_api_id() throws NetworkStatusException {
        if (this._nHistoryId != -1) {
            return this._nHistoryId;
        }
        int id = this.get_websocket_bitshares_api_id("history");
        if (-1 != id) {
            this._nHistoryId = id;
        } else {
            this.close();
            this.connect(this.mWebsocket.getURI().toString());
            this._nHistoryId = this.get_websocket_bitshares_api_id("history");
        }
        return this._nHistoryId;
    }

    private int get_broadcast_api_id() throws NetworkStatusException {
        if (this._nBroadcastId != -1) {
            return this._nBroadcastId;
        }
        int id = this.get_websocket_bitshares_api_id("network_broadcast");
        if (-1 != id) {
            this._nBroadcastId = id;
        } else {
            this.close();
            this.connect(this.mWebsocket.getURI().toString());
            this._nBroadcastId = this.get_websocket_bitshares_api_id("network_broadcast");
        }
        return this._nBroadcastId;
    }

    public sha256_object get_chain_id() throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_chain_id");
        ArrayList listDatabaseParams = new ArrayList();
        callObject.params.add(listDatabaseParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<sha256_object>>(){}.getType());
        Reply replyDatabase = this.sendForReply(callObject, replyObject);
        if (replyDatabase == null) {
            return null;
        }
        return (sha256_object)replyDatabase.result;
    }

    public List<CallOrder> get_call_orders(object_id asset_id, Integer limit) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_call_orders");
        ArrayList<Object> listDatabaseParams = new ArrayList<Object>();
        listDatabaseParams.add(asset_id);
        listDatabaseParams.add(limit);
        callObject.params.add(listDatabaseParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<CallOrder>>>(){}.getType());
        Reply replyDatabase = this.sendForReply(callObject, replyObject);
        System.out.println(replyObject.getResponse());
        if (replyDatabase == null) {
            return null;
        }
        return (List)replyDatabase.result;
    }

    public List<account_object> lookup_account_names(String strAccountName) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("lookup_account_names");
        ArrayList<String> listAccountNames = new ArrayList<String>();
        listAccountNames.add(strAccountName);
        ArrayList<ArrayList<String>> listAccountNamesParams = new ArrayList<ArrayList<String>>();
        listAccountNamesParams.add(listAccountNames);
        callObject.params.add(listAccountNamesParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<account_object>>>(){}.getType());
        Reply replyAccountObjectList = this.sendForReply(callObject, replyObject);
        if (replyAccountObjectList == null) {
            return null;
        }
        return (List)replyAccountObjectList.result;
    }

    public List<account_object> get_accounts(List<object_id<account_object>> listAccountObjectId) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_accounts");
        ArrayList<List<object_id<account_object>>> listAccountIds = new ArrayList<List<object_id<account_object>>>();
        listAccountIds.add(listAccountObjectId);
        ArrayList<ArrayList<List<object_id<account_object>>>> listAccountNamesParams = new ArrayList<ArrayList<List<object_id<account_object>>>>();
        listAccountNamesParams.add(listAccountIds);
        callObject.params.add(listAccountIds);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<account_object>>>(){}.getType());
        Reply replyAccountObjectList = this.sendForReply(callObject, replyObject);
        if (replyAccountObjectList == null) {
            ArrayList<account_object> Obj = new ArrayList<account_object>();
            return Obj;
        }
        return (List)replyAccountObjectList.result;
    }

    public List<asset> list_account_balances(object_id<account_object> accountId) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_account_balances");
        ArrayList<Object> listAccountBalancesParam = new ArrayList<Object>();
        listAccountBalancesParam.add(accountId);
        listAccountBalancesParam.add(new ArrayList());
        callObject.params.add(listAccountBalancesParam);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<asset>>>(){}.getType());
        Reply replyLookupAccountNames = this.sendForReply(callObject, replyObject);
        if (replyLookupAccountNames == null) {
            ArrayList<asset> Obj = new ArrayList<asset>();
            return Obj;
        }
        return (List)replyLookupAccountNames.result;
    }

    public List<operation_history_object> get_account_history(object_id<account_object> accountId, int nLimit) throws NetworkStatusException {
        this._nHistoryId = this.get_history_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nHistoryId);
        callObject.params.add("get_account_history");
        ArrayList<Object> listAccountHistoryParam = new ArrayList<Object>();
        listAccountHistoryParam.add(accountId);
        listAccountHistoryParam.add("1.11.0");
        listAccountHistoryParam.add(nLimit);
        listAccountHistoryParam.add("1.11.0");
        callObject.params.add(listAccountHistoryParam);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<operation_history_object>>>(){}.getType());
        Reply replyAccountHistory = this.sendForReply(callObject, replyObject);
        if (replyAccountHistory == null) {
            return null;
        }
        return (List)replyAccountHistory.result;
    }

    public operation_types_histoy_object get_account_history_by_operations(object_id<account_object> accountId, List<Integer> operation_types, int start, int nLimit) throws NetworkStatusException {
        this._nHistoryId = this.get_history_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nHistoryId);
        callObject.params.add("get_account_history_by_operations");
        ArrayList<Object> listAccountHistoryParam = new ArrayList<Object>();
        listAccountHistoryParam.add(accountId);
        listAccountHistoryParam.add(operation_types);
        listAccountHistoryParam.add(start);
        listAccountHistoryParam.add(nLimit);
        callObject.params.add(listAccountHistoryParam);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<operation_types_histoy_object>>(){}.getType());
        Reply replyAccountHistory = this.sendForReply(callObject, replyObject);
        if (replyAccountHistory == null) {
            return null;
        }
        return (operation_types_histoy_object)replyAccountHistory.result;
    }

    public List<operation_history_object> get_account_history_with_last_id(object_id<account_object> accountId, int nLimit, String id) throws NetworkStatusException {
        this._nHistoryId = this.get_history_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nHistoryId);
        callObject.params.add("get_account_history");
        ArrayList<Object> listAccountHistoryParam = new ArrayList<Object>();
        listAccountHistoryParam.add(accountId);
        listAccountHistoryParam.add("1.11.0");
        listAccountHistoryParam.add(nLimit);
        listAccountHistoryParam.add(id);
        callObject.params.add(listAccountHistoryParam);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<operation_history_object>>>(){}.getType());
        Reply replyAccountHistory = this.sendForReply(callObject, replyObject);
        if (replyAccountHistory == null) {
            return null;
        }
        return (List)replyAccountHistory.result;
    }

    public account_object get_account(String strAccountNameOrId) throws NetworkStatusException {
        object_id accountObjectId = object_id.create_from_string(strAccountNameOrId);
        if (accountObjectId == null) {
            List<account_object> listAccountObject = this.lookup_account_names(strAccountNameOrId);
            if (listAccountObject == null) {
                return null;
            }
            if (listAccountObject.isEmpty()) {
                return null;
            }
            if (listAccountObject.size() > 0) {
                return listAccountObject.get(0);
            }
            return null;
        }
        ArrayList<object_id<account_object>> listAccountObjectId = new ArrayList<object_id<account_object>>();
        listAccountObjectId.add(accountObjectId);
        List<account_object> listAccountObject = this.get_accounts(listAccountObjectId);
        if (listAccountObject == null) {
            return null;
        }
        if (listAccountObject.isEmpty()) {
            return null;
        }
        if (listAccountObject.size() > 0) {
            return listAccountObject.get(0);
        }
        return null;
    }

    public account_object get_witness(String strAccountNameOrId) throws NetworkStatusException {
        object_id accountObjectId = object_id.create_from_string(strAccountNameOrId);
        if (accountObjectId == null) {
            List<account_object> listAccountObject = this.lookup_account_names(strAccountNameOrId);
            if (listAccountObject == null) {
                return null;
            }
            if (listAccountObject.isEmpty()) {
                return null;
            }
            if (listAccountObject.size() > 0) {
                return listAccountObject.get(0);
            }
            return null;
        }
        ArrayList<object_id<account_object>> listAccountObjectId = new ArrayList<object_id<account_object>>();
        listAccountObjectId.add(accountObjectId);
        List<account_object> listAccountObject = this.get_accounts(listAccountObjectId);
        if (listAccountObject == null) {
            return null;
        }
        if (listAccountObject.isEmpty()) {
            return null;
        }
        if (listAccountObject.size() > 0) {
            return listAccountObject.get(0);
        }
        return null;
    }

    public List<HistoryResponseModel.DataBean> get_transfer_history(object_id<account_object> accountId, int nLimit) throws NetworkStatusException, JSONException, Exception {
        this._nHistoryId = this.get_history_api_id();
        BitsharesWalletWraper bww = new BitsharesWalletWraper();
        List<asset_object> objAssets = bww.list_assets_obj("", 100);
        if (objAssets == null) {
            return null;
        }
        ArrayList<HistoryResponseModel.DataBean> list = new ArrayList<HistoryResponseModel.DataBean>();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nHistoryId);
        callObject.params.add("get_account_history");
        ArrayList<Object> listAccountHistoryParam = new ArrayList<Object>();
        listAccountHistoryParam.add(accountId);
        listAccountHistoryParam.add("1.11.0");
        listAccountHistoryParam.add(nLimit);
        listAccountHistoryParam.add("1.11.0");
        callObject.params.add(listAccountHistoryParam);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<operation_history_object>>>(){}.getType());
        Reply replyAccountHistory = this.sendForReply(callObject, replyObject);
        if (replyAccountHistory == null) {
            ArrayList<HistoryResponseModel.DataBean> Obj = new ArrayList<HistoryResponseModel.DataBean>();
            return Obj;
        }
        String jsonRpc = replyObject.getResponse();
        try {
            JSONObject jsonObject = new JSONObject(jsonRpc);
            JSONArray jsonArray = jsonObject.optJSONArray("result");
            HistoryResponseModel.DataBean dataBean = null;
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject1 = jsonArray.optJSONObject(i);
                JSONArray jsonArray1 = jsonObject1.optJSONArray("op");
                if (!jsonArray1.getString(0).equalsIgnoreCase("0")) continue;
                dataBean = new HistoryResponseModel.DataBean();
                String block_order_id = jsonObject1.optString("id");
                JSONObject jsonObject2 = jsonArray1.getJSONObject(1);
                String fromId = jsonObject2.optString("from");
                String toId = jsonObject2.optString("to");
                String amount = jsonObject2.optJSONObject("amount").optString("amount");
                String type = jsonObject2.optJSONObject("amount").optString("asset_id");
                dataBean.setId(block_order_id);
                for (asset_object objAsset : objAssets) {
                    if (!objAsset.id.toString().equalsIgnoreCase(type)) continue;
                    dataBean.setSymbol(objAsset.symbol);
                    asset_object.asset_object_legible myasset = objAsset.get_legible_asset_object(Long.parseLong(amount));
                    dataBean.setAmount(NumberUtils.formatNumber(myasset.count));
                    String sFromName = this.get_account((String)fromId).name;
                    String sToName = this.get_account((String)toId).name;
                    dataBean.setFrom(sFromName);
                    dataBean.setTo(sToName);
                    list.add(dataBean);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    public List<HistoryResponseModel.DataBean> get_transfer_history_by_flag(object_id<account_object> accountId, int nLimit, String lastBlockIndex) throws NetworkStatusException, JSONException, Exception {
        this._nHistoryId = this.get_history_api_id();
        BitsharesWalletWraper bww = new BitsharesWalletWraper();
        List<asset_object> objAssets = bww.list_assets_obj("", 100);
        if (objAssets == null) {
            return null;
        }
        ArrayList<HistoryResponseModel.DataBean> list = new ArrayList<HistoryResponseModel.DataBean>();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nHistoryId);
        callObject.params.add("get_account_history");
        ArrayList<Object> listAccountHistoryParam = new ArrayList<Object>();
        listAccountHistoryParam.add(accountId);
        listAccountHistoryParam.add("1.11.0");
        listAccountHistoryParam.add(nLimit);
        if (null == lastBlockIndex || "".equals(lastBlockIndex)) {
            listAccountHistoryParam.add("1.11.0");
        } else {
            listAccountHistoryParam.add(lastBlockIndex);
        }
        callObject.params.add(listAccountHistoryParam);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<operation_history_object>>>(){}.getType());
        Reply replyAccountHistory = this.sendForReply(callObject, replyObject);
        if (replyAccountHistory == null) {
            ArrayList<HistoryResponseModel.DataBean> Obj = new ArrayList<HistoryResponseModel.DataBean>();
            return Obj;
        }
        String jsonRpc = replyObject.getResponse();
        try {
            JSONObject jsonObject = new JSONObject(jsonRpc);
            JSONArray jsonArray = jsonObject.optJSONArray("result");
            HistoryResponseModel.DataBean dataBean = null;
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject1 = jsonArray.optJSONObject(i);
                JSONArray jsonArray1 = jsonObject1.optJSONArray("op");
                String block_order_id = jsonObject1.optString("id");
                if (!jsonArray1.getString(0).equalsIgnoreCase("0")) continue;
                dataBean = new HistoryResponseModel.DataBean();
                JSONObject jsonObject2 = jsonArray1.getJSONObject(1);
                String fromId = jsonObject2.optString("from");
                String toId = jsonObject2.optString("to");
                String amount = jsonObject2.optJSONObject("amount").optString("amount");
                String type = jsonObject2.optJSONObject("amount").optString("asset_id");
                String memo = jsonObject2.optString("memo");
                dataBean.setId(block_order_id);
                dataBean.setMemo(memo);
                for (asset_object objAsset : objAssets) {
                    if (!objAsset.id.toString().equalsIgnoreCase(type)) continue;
                    dataBean.setSymbol(objAsset.symbol);
                    asset_object.asset_object_legible myasset = objAsset.get_legible_asset_object(Long.parseLong(amount));
                    dataBean.setAmount(NumberUtils.formatNumber(myasset.count));
                    String sFromName = this.get_account((String)fromId).name;
                    String sToName = this.get_account((String)toId).name;
                    dataBean.setFrom(sFromName);
                    dataBean.setTo(sToName);
                    list.add(dataBean);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    public global_property_object get_global_properties() throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_global_properties");
        callObject.params.add(new ArrayList());
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<global_property_object>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            return null;
        }
        return (global_property_object)replyObject.result;
    }

    public dynamic_global_property_object get_dynamic_global_properties() throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_dynamic_global_properties");
        callObject.params.add(new ArrayList());
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<dynamic_global_property_object>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            return null;
        }
        return (dynamic_global_property_object)replyObject.result;
    }

    public List<asset_object> list_assets(String strLowerBound, int nLimit) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("list_assets");
        ArrayList<Object> listAssetsParam = new ArrayList<Object>();
        listAssetsParam.add(strLowerBound);
        listAssetsParam.add(nLimit);
        callObject.params.add(listAssetsParam);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<List<asset_object>>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            ArrayList<asset_object> Obj = new ArrayList<asset_object>();
            return Obj;
        }
        return (List)replyObject.result;
    }

    public List<asset_object> get_assets(List<object_id<asset_object>> listAssetObjectId) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_assets");
        ArrayList listAssetsParam = new ArrayList();
        ArrayList<object_id<asset_object>> listObjectId = new ArrayList<object_id<asset_object>>();
        listObjectId.addAll(listAssetObjectId);
        listAssetsParam.add(listObjectId);
        callObject.params.add(listAssetsParam);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<List<asset_object>>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            ArrayList<asset_object> Obj = new ArrayList<asset_object>();
            return Obj;
        }
        return (List)replyObject.result;
    }

    public String lookup_asset_symbols_rate(String strAssetSymbol) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        String result = "";
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("lookup_asset_symbols");
        ArrayList listAssetsParam = new ArrayList();
        ArrayList<String> listAssetSysmbols = new ArrayList<String>();
        listAssetSysmbols.add(strAssetSymbol);
        listAssetsParam.add(listAssetSysmbols);
        callObject.params.add(listAssetsParam);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<List<asset_object>>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            return "0";
        }
        String jsonRpc = replyObjectProcess.getResponse();
        double nRate = 0.0;
        JSONObject jsonobj = null;
        JSONArray jarray = null;
        JSONObject job = null;
        try {
            jsonobj = new JSONObject(jsonRpc);
            jarray = jsonobj.getJSONArray("result");
            job = jarray.getJSONObject(0);
            String asset_cur_id = job.getString("id");
            int precision = job.getInt("precision");
            double base_amount = job.getJSONObject("options").getJSONObject("core_exchange_rate").getJSONObject("base").getDouble("amount");
            String base_asset_id = job.getJSONObject("options").getJSONObject("core_exchange_rate").getJSONObject("base").getString("asset_id");
            double quote_amount = job.getJSONObject("options").getJSONObject("core_exchange_rate").getJSONObject("quote").getDouble("amount");
            String quote_asset_id = job.getJSONObject("options").getJSONObject("core_exchange_rate").getJSONObject("quote").getString("asset_id");
            int targetPrec = 1;
            int bdsPrec = 1;
            if (precision <= 1) {
                return "0";
            }
            for (int i = 0; i < precision; ++i) {
                targetPrec *= 10;
            }
            for (int n = 0; n < 5; ++n) {
                bdsPrec *= 10;
            }
            if (base_asset_id.equals("1.3.0")) {
                nRate = quote_amount / (double)targetPrec / (base_amount / (double)bdsPrec);
            } else if (quote_asset_id.equals("1.3.0")) {
                nRate = base_amount / (double)targetPrec / (quote_amount / (double)bdsPrec);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "0";
        }
        result = nRate + "";
        return result;
    }

    public asset_object lookup_asset_symbols(String strAssetSymbol) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("lookup_asset_symbols");
        ArrayList listAssetsParam = new ArrayList();
        ArrayList<String> listAssetSymbols = new ArrayList<String>();
        listAssetSymbols.add(strAssetSymbol);
        listAssetsParam.add(listAssetSymbols);
        callObject.params.add(listAssetsParam);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<List<asset_object>>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            return null;
        }
        return (asset_object)((List)replyObject.result).get(0);
    }

    public block_header get_block_header(int nBlockNumber) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_block_header");
        ArrayList<Integer> listBlockNumber = new ArrayList<Integer>();
        listBlockNumber.add(nBlockNumber);
        callObject.params.add(listBlockNumber);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<block_header>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            block_header Obj = new block_header();
            return Obj;
        }
        return (block_header)replyObject.result;
    }

    public block_object get_block(int nBlockNumber) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        block_object block = new block_object();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_block");
        ArrayList<Integer> listBlockNumber = new ArrayList<Integer>();
        listBlockNumber.add(nBlockNumber);
        callObject.params.add(listBlockNumber);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<block_header>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            block_object obj = new block_object();
            return obj;
        }
        String sBlock = replyObjectProcess.getResponse();
        if (sBlock != null) {
            try {
                String date;
                JSONObject jsonobj = new JSONObject(sBlock);
                JSONObject dataobj = jsonobj.getJSONObject("result");
                block.blockNumber = nBlockNumber + "";
                block.timeStame = date = TimeUtils.utc2Local(dataobj.getString("timestamp").replace("T", " "));
                block.witnessId = dataobj.getString("witness");
                JSONArray jarray = dataobj.getJSONArray("transactions");
                block.transactionCount = jarray.length();
                block.transaction_ids = new ArrayList();
                for (int i = 0; i < jarray.length(); ++i) {
                    String json = jarray.getString(i);
                    Gson gson = global_config_object.getInstance().getGsonBuilder().create();
                    transaction trans = (transaction)gson.fromJson(json, transaction.class);
                    block.transaction_ids.add(trans.ids().toString().substring(0, 40));
                }
                return block;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int broadcast_transaction(signed_transaction tx) throws NetworkStatusException {
        this._nBroadcastId = this.get_broadcast_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nBroadcastId);
        callObject.params.add("broadcast_transaction");
        ArrayList<signed_transaction> listTransaction = new ArrayList<signed_transaction>();
        listTransaction.add(tx);
        callObject.params.add(listTransaction);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<Integer>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            return -2;
        }
        if (replyObject.error != null) {
            return -1;
        }
        return 0;
    }

    public int broadcast_json_transaction(signed_transaction tx, String type) throws NetworkStatusException {
        this._nBroadcastId = this.get_broadcast_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nBroadcastId);
        callObject.params.add("broadcast_transaction");
        ArrayList<signed_transaction> listTransaction = new ArrayList<signed_transaction>();
        listTransaction.add(tx);
        callObject.params.add(listTransaction);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<Integer>>(){}.getType());
        Reply replyObject = this.sendJsonForReplyImpl(callObject, replyObjectProcess);
        if (replyObject == null) {
            return -1;
        }
        if (replyObject.error != null) {
            return -1;
        }
        return 0;
    }

    public List<bucket_object> get_market_history(object_id<asset_object> assetObjectId1, object_id<asset_object> assetObjectId2, int nBucket, Date dateStart, Date dateEnd) throws NetworkStatusException {
        this._nHistoryId = this.get_history_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nHistoryId);
        callObject.params.add("get_market_history");
        ArrayList<Object> listParams = new ArrayList<Object>();
        listParams.add(assetObjectId1);
        listParams.add(assetObjectId2);
        listParams.add(nBucket);
        listParams.add(dateStart);
        listParams.add(dateEnd);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<List<bucket_object>>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            ArrayList<bucket_object> Obj = new ArrayList<bucket_object>();
            return Obj;
        }
        return (List)replyObject.result;
    }

    public List<limit_order_object> get_limit_orders(List<object_id<limit_order_object>> ids) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_objects");
        ArrayList<List<object_id<limit_order_object>>> listParams = new ArrayList<List<object_id<limit_order_object>>>();
        listParams.add(ids);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<limit_order_object>>>(){}.getType());
        Reply reply = this.sendForReply(callObject, replyObject);
        if (reply == null) {
            return null;
        }
        return (List)reply.result;
    }

    public List<limit_order_object> get_limit_orders(object_id<asset_object> base, object_id<asset_object> quote, int limit) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_limit_orders");
        ArrayList<Object> listParams = new ArrayList<Object>();
        listParams.add(base);
        listParams.add(quote);
        listParams.add(limit);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<List<limit_order_object>>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            ArrayList<limit_order_object> Obj = new ArrayList<limit_order_object>();
            return Obj;
        }
        return (List)replyObject.result;
    }

    public void subscribe_to_market(object_id<asset_object> base, object_id<asset_object> quote) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("subscribe_to_market");
        ArrayList<Object> listParams = new ArrayList<Object>();
        listParams.add(callObject.id);
        listParams.add(base);
        listParams.add(quote);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<String>>(){}.getType());
        this.sendForReplyImpl(callObject, replyObject);
    }

    public List<full_account_object> get_full_accounts(List<String> names, boolean subscribe) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_full_accounts");
        ArrayList<Object> listParams = new ArrayList<Object>();
        listParams.add(names);
        listParams.add(subscribe);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<full_account_object>>>(){}.getType());
        Reply reply = this.sendForReply(callObject, replyObject);
        if (reply == null) {
            return null;
        }
        return (List)reply.result;
    }

    public String get_Fee(String id, int op) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        String sFee = "0";
        String strResopnse = null;
        object_id ObjectId = object_id.create_from_string(id);
        ArrayList ids = new ArrayList();
        ids.add(ObjectId);
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_objects");
        ArrayList listParams = new ArrayList();
        listParams.add(ids);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<limit_order_object>>>(){}.getType());
        Reply obj = this.sendForReply(callObject, replyObject);
        if (obj == null) {
            strResopnse = replyObject.getResponse();
        } else {
            strResopnse = replyObject.getResponse();
            if (strResopnse != null && !strResopnse.isEmpty()) {
                try {
                    JSONArray jArrayFees;
                    JSONObject jsonObject1;
                    JSONArray jArrayParams;
                    JSONObject jsonObject = new JSONObject(strResopnse);
                    JSONArray jArrayResult = jsonObject.getJSONArray("result");
                    if (jArrayResult != null && jArrayResult.length() > 0 && (jArrayParams = (jsonObject1 = jArrayResult.getJSONObject(0)).getJSONObject("parameters").getJSONObject("current_fees").getJSONArray("parameters")) != null && jArrayParams.length() > 0 && op < jArrayParams.length() && (jArrayFees = jArrayParams.getJSONArray(op)).getInt(0) == op) {
                        JSONObject fee_obj = jArrayFees.getJSONObject(1);
                        switch (op) {
                            case 0: {
                                long transfer_fee = fee_obj.getLong("fee");
                                if (transfer_fee <= 0L) break;
                                sFee = CalculateUtils.div(Double.parseDouble(transfer_fee + ""), 100000.0, 5);
                                break;
                            }
                            case 8: {
                                long liftetime_fee = fee_obj.getLong("membership_lifetime_fee");
                                if (liftetime_fee <= 0L) break;
                                sFee = CalculateUtils.div(Double.parseDouble(liftetime_fee + ""), 100000.0, 5);
                                break;
                            }
                            case 7: {
                                long fee = fee_obj.getLong("membership_lifetime_fee");
                                if (fee <= 0L) break;
                                sFee = CalculateUtils.div(Double.parseDouble(fee + ""), 100000.0, 5);
                                break;
                            }
                            case 3: 
                            case 33: {
                                long vest_fee = fee_obj.getLong("fee");
                                if (vest_fee <= 0L) break;
                                sFee = CalculateUtils.div(Double.parseDouble(vest_fee + ""), 100000.0, 5);
                            }
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return "0";
                }
            }
        }
        return sFee;
    }

    public String get_object(String id) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        String strResopnse = null;
        object_id ObjectId = object_id.create_from_string(id);
        ArrayList ids = new ArrayList();
        ids.add(ObjectId);
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_objects");
        ArrayList listParams = new ArrayList();
        listParams.add(ids);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<limit_order_object>>>(){}.getType());
        Reply obj = this.sendForReply(callObject, replyObject);
        strResopnse = replyObject.getResponse();
        try {
            JSONObject jsonObject = new JSONObject(strResopnse);
            JSONArray jArrayResult = jsonObject.getJSONArray("result");
            return jArrayResult.get(0).toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    public limit_order_object get_limit_order(object_id<limit_order_object> id) throws NetworkStatusException {
        return this.get_limit_orders(Collections.singletonList(id)).get(0);
    }

    private <T> String sendForJsonReply(Call callObject, ReplyObjectProcess<Reply<T>> replyObjectProcess) throws NetworkStatusException {
        int nRet;
        if ((this.mWebsocket == null || this.mnConnectStatus != WEBSOCKET_CONNECT_SUCCESS) && (nRet = this.connect(this.mWebsocket.getURI().toString())) == -1) {
            return null;
        }
        return this.sendForJsonReplyImpl(callObject, replyObjectProcess);
    }

    private <T> Reply<T> sendForReply(Call callObject, ReplyObjectProcess<Reply<T>> replyObjectProcess) throws NetworkStatusException {
        int nRet;
        int id = this.get_websocket_bitshares_api_id("database");
        if (-1 == id && (nRet = this.connect(this.mWebsocket.getURI().toString())) == -1) {
            return null;
        }
        if ((this.mWebsocket == null || this.mnConnectStatus != WEBSOCKET_CONNECT_SUCCESS) && (nRet = this.connect(this.mWebsocket.getURI().toString())) == -1) {
            return null;
        }
        return this.sendForReplyImpl(callObject, replyObjectProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Reply<T> sendJsonForReplyImpl(Call callObject, ReplyObjectProcess<Reply<T>> replyObjectProcess) throws NetworkStatusException {
        Gson gson = global_config_object.getInstance().getGsonBuilder().create();
        String strMessage = gson.toJson((Object)callObject);
        this.log.debug("Wallet send message:" + strMessage);
        Object object = this.mHashMapIdToProcess;
        synchronized (object) {
            this.mHashMapIdToProcess.put(callObject.id, replyObjectProcess);
        }
        object = replyObjectProcess;
        synchronized (object) {
            this.mWebsocket.send(strMessage);
            try {
                replyObjectProcess.wait(2000L);
                Reply<T> replyObject = replyObjectProcess.getReplyObject();
                String jsonResp = replyObjectProcess.getResponse();
                String strError = replyObjectProcess.getError();
                if (!TextUtils.isEmpty(strError)) {
                    throw new NetworkStatusException(strError);
                }
                if (replyObjectProcess.getException() != null) {
                    throw new NetworkStatusException(replyObjectProcess.getException());
                }
                if (replyObject == null) {
                    throw new NetworkStatusException("Reply object is null.\n" + replyObjectProcess.getResponse());
                }
                if (replyObject.error != null) {
                    throw new NetworkStatusException(gson.toJson((Object)replyObject.error));
                }
                return replyObject;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.log.error("Websocket Interrupted:" + e.getMessage());
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> String sendJsonForJsonReply(String strMessage, ReplyObjectProcess<Reply<T>> replyObjectProcess) throws NetworkStatusException {
        Object object = this.mHashMapIdToProcess;
        synchronized (object) {
            this.mHashMapIdToProcess.put(this.mnCallId.getAndIncrement(), replyObjectProcess);
        }
        object = replyObjectProcess;
        synchronized (object) {
            this.mWebsocket.send(strMessage);
            try {
                replyObjectProcess.wait(2000L);
                String jsonResp = replyObjectProcess.getResponse();
                String strError = replyObjectProcess.getError();
                if (!TextUtils.isEmpty(strError)) {
                    throw new NetworkStatusException(strError);
                }
                if (replyObjectProcess.getException() != null) {
                    throw new NetworkStatusException(replyObjectProcess.getException());
                }
                return jsonResp;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> String sendForJsonReplyImpl(Call callObject, ReplyObjectProcess<Reply<T>> replyObjectProcess) throws NetworkStatusException {
        Gson gson = global_config_object.getInstance().getGsonBuilder().create();
        String strMessage = gson.toJson((Object)callObject);
        Object object = this.mHashMapIdToProcess;
        synchronized (object) {
            this.mHashMapIdToProcess.put(callObject.id, replyObjectProcess);
        }
        object = replyObjectProcess;
        synchronized (object) {
            this.mWebsocket.send(strMessage);
            try {
                replyObjectProcess.wait(2000L);
                String jsonResp = replyObjectProcess.getResponse();
                String strError = replyObjectProcess.getError();
                if (!TextUtils.isEmpty(strError)) {
                    throw new NetworkStatusException(strError);
                }
                if (replyObjectProcess.getException() != null) {
                    throw new NetworkStatusException(replyObjectProcess.getException());
                }
                return jsonResp;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Reply<T> sendForReplyImpl(Call callObject, ReplyObjectProcess<Reply<T>> replyObjectProcess) throws NetworkStatusException {
        Gson gson = global_config_object.getInstance().getGsonBuilder().create();
        String strMessage = gson.toJson((Object)callObject);
        Object object = this.mHashMapIdToProcess;
        synchronized (object) {
            this.mHashMapIdToProcess.put(callObject.id, replyObjectProcess);
        }
        if (this.mWebsocket == null) {
            this.connect(this.mWebsocket.getURI().toString());
            if (this.mWebsocket == null) {
                return null;
            }
        }
        object = replyObjectProcess;
        synchronized (object) {
            this.log.debug("Wallet send message:" + strMessage);
            this.mWebsocket.send(strMessage);
            try {
                replyObjectProcess.wait(2000L);
                Reply<T> replyObject = replyObjectProcess.getReplyObject();
                String jsonResp = replyObjectProcess.getResponse();
                this.log.debug("Wallet receive message:" + jsonResp);
                String strError = replyObjectProcess.getError();
                if (!TextUtils.isEmpty(strError)) {
                    return null;
                }
                if (replyObjectProcess.getException() != null) {
                    return null;
                }
                if (replyObject == null) {
                    return null;
                }
                if (replyObject.error != null) {
                    return null;
                }
                return replyObject;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.log.error("callObject = [" + callObject + "], replyObjectProcess = [" + replyObjectProcess + "]" + e.getMessage());
                return null;
            }
        }
    }

    public boolean is_public_key_registered(String pub_key) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        boolean isRegistered = false;
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("is_public_key_registered");
        ArrayList<String> listParams = new ArrayList<String>();
        listParams.add(pub_key);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<limit_order_object>>>(){}.getType());
        String strResp = null;
        try {
            strResp = this.sendForJsonReply(callObject, replyObject);
        }
        catch (Exception e) {
            strResp = replyObject.getResponse();
        }
        if (strResp == null) {
            strResp = replyObject.getResponse();
        }
        if (strResp != null && !strResp.isEmpty()) {
            try {
                JSONObject jsonObject = new JSONObject(strResp);
                String strResult = jsonObject.getString("result");
                isRegistered = !strResult.equals("false");
            }
            catch (JSONException e) {
                e.printStackTrace();
                isRegistered = false;
            }
        }
        return isRegistered;
    }

    public List<vesting_balance_object> get_vesting_balances(String name) throws NetworkStatusException {
        String strResp;
        this._nDatabaseId = this.get_database_api_id();
        ArrayList<vesting_balance_object> vestingList = null;
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_vesting_balances");
        ArrayList<String> listParams = new ArrayList<String>();
        listParams.add(name);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<limit_order_object>>>(){}.getType());
        try {
            strResp = this.sendForJsonReply(callObject, replyObject);
        }
        catch (Exception e) {
            strResp = replyObject.getResponse();
        }
        if (strResp == null) {
            strResp = replyObject.getResponse();
        }
        if (strResp != null) {
            try {
                JSONObject jsonObject = new JSONObject(strResp);
                JSONArray jsonArray = jsonObject.getJSONArray("result");
                if (jsonArray.length() > 0) {
                    vestingList = new ArrayList<vesting_balance_object>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject obj = jsonArray.getJSONObject(i);
                        if (obj == null) continue;
                        String id = obj.getString("id");
                        String owner = obj.getString("owner");
                        long balance_amount = obj.getJSONObject("balance").getLong("amount");
                        if (balance_amount > 0L) {
                            String balance_asset_id = obj.getJSONObject("balance").getString("asset_id");
                            JSONArray policyArray = obj.getJSONArray("policy");
                            if (policyArray.length() <= 0) continue;
                            long vesting_seconds = policyArray.getJSONObject(1).getLong("vesting_seconds");
                            long coin_seconds_earned = policyArray.getJSONObject(1).getLong("coin_seconds_earned");
                            String strTotal = CalculateUtils.mul(balance_amount, vesting_seconds);
                            double nTotal = Double.parseDouble(strTotal);
                            String strPersent = CalculateUtils.div(coin_seconds_earned, nTotal, 12);
                            double availablePercent = Double.parseDouble(strPersent);
                            double allowedAmount = Double.parseDouble(CalculateUtils.mul(balance_amount, availablePercent));
                            double coin_days_earned = Double.parseDouble(CalculateUtils.div(coin_seconds_earned, 86400.0, 12));
                            double coin_days_required = Double.parseDouble(CalculateUtils.div(Double.parseDouble(strTotal), 86400.0, 12));
                            double vesting_period = Double.parseDouble(CalculateUtils.div(Double.parseDouble(CalculateUtils.mul(vesting_seconds, CalculateUtils.sub(1.0, availablePercent))), 86400.0, 2));
                            vesting_balance_object vesting = new vesting_balance_object();
                            vesting.vesting_seconds = vesting_seconds + "";
                            vesting.id = object_id.create_from_string(id);
                            vesting.owner = owner;
                            vesting.TotalBalance = CalculateUtils.div(balance_amount, 100000.0, 5);
                            vesting.AvailablePersent = CalculateUtils.div(availablePercent, 1.0, 4);
                            vesting.Available_to_claim = CalculateUtils.div(allowedAmount, 100000.0, 5);
                            vesting.coin_seconds_earned = coin_seconds_earned;
                            vesting.coin_days_earned = CalculateUtils.div(coin_days_earned, 100000.0, 0);
                            vesting.coin_days_required = CalculateUtils.div(coin_days_required, 100000.0, 0);
                            vesting.vesting_period = vesting_period + "";
                            vestingList.add(vesting);
                            continue;
                        }
                        vesting_balance_object vesting = new vesting_balance_object();
                        vesting.id = object_id.create_from_string(id);
                        vesting.owner = owner;
                        vesting.TotalBalance = "0";
                        vesting.AvailablePersent = "0";
                        vesting.Available_to_claim = "0.00000";
                        vestingList.add(vesting);
                    }
                    return vestingList;
                }
            }
            catch (JSONException e) {
                return null;
            }
        }
        return vestingList;
    }

    public AllHistory get_all_history(String baseSymbolId, String qouteSymbolId, int nLimit) throws NetworkStatusException {
        this._nHistoryId = this.get_history_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nHistoryId);
        callObject.params.add("get_fill_order_history");
        ArrayList<Object> listAccountHistoryParam = new ArrayList<Object>();
        listAccountHistoryParam.add(baseSymbolId);
        listAccountHistoryParam.add(qouteSymbolId);
        listAccountHistoryParam.add(nLimit);
        callObject.params.add(listAccountHistoryParam);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<AllHistory>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        Gson gson = new Gson();
        AllHistory allHistory = (AllHistory)gson.fromJson(replyObjectProcess.getResponse(), AllHistory.class);
        return allHistory;
    }

    public MarketTicker get_ticker(String base, String quote) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_ticker");
        ArrayList<String> listParams = new ArrayList<String>();
        listParams.add(base);
        listParams.add(quote);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<MarketTicker>>(){}.getType());
        Reply reply = this.sendForReply(callObject, replyObject);
        if (reply == null) {
            return null;
        }
        return (MarketTicker)reply.result;
    }

    public OrderBook get_order_book(String base, String quote, int limit) throws NetworkStatusException {
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_order_book");
        ArrayList<Object> listParams = new ArrayList<Object>();
        listParams.add(base);
        listParams.add(quote);
        listParams.add(limit);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObjectProcess = new ReplyObjectProcess(new TypeToken<Reply<OrderBook>>(){}.getType());
        Reply replyObject = this.sendForReply(callObject, replyObjectProcess);
        if (replyObject == null) {
            return null;
        }
        return (OrderBook)replyObject.result;
    }

    public operations.operation_type get_history_object(Integer object) throws NetworkStatusException {
        String strResp;
        this._nDatabaseId = this.get_database_api_id();
        Call callObject = new Call();
        callObject.id = this.mnCallId.getAndIncrement();
        callObject.method = "call";
        callObject.params = new ArrayList<Object>();
        callObject.params.add(this._nDatabaseId);
        callObject.params.add("get_objects");
        ArrayList listParams = new ArrayList();
        ArrayList<String> list = new ArrayList<String>();
        list.add("1.11." + object);
        listParams.add(list);
        callObject.params.add(listParams);
        ReplyObjectProcess replyObject = new ReplyObjectProcess(new TypeToken<Reply<List<limit_order_object>>>(){}.getType());
        try {
            strResp = this.sendForJsonReply(callObject, replyObject);
        }
        catch (Exception e) {
            strResp = replyObject.getResponse();
        }
        if (strResp == null) {
            strResp = replyObject.getResponse();
        }
        if (strResp != null) {
            try {
                JSONObject jsonObject = null;
                jsonObject = new JSONObject(strResp);
                JSONArray jsonArray = jsonObject.getJSONArray("result");
                if (jsonArray.length() > 0) {
                    JSONObject obj = jsonArray.getJSONObject(0);
                    Gson gson = global_config_object.getInstance().getGsonBuilder().create();
                    operations.operation_type operation_type2 = (operations.operation_type)gson.fromJson(obj.getJSONArray("op").toString(), operations.operation_type.class);
                    return operation_type2;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private class ReplyObjectProcess<T>
    implements IReplyObjectProcess<T> {
        private String strError;
        private T mT;
        private Type mType;
        private Throwable exception;
        private String strResponse;

        public ReplyObjectProcess(Type type) {
            this.mType = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processTextToObject(String strText) {
            try {
                this.strResponse = strText;
                websocket_api.this.gRespJson = strText;
                Gson gson = global_config_object.getInstance().getGsonBuilder().create();
                this.mT = gson.fromJson(strText, this.mType);
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
                this.strError = e.getMessage();
                this.strResponse = strText;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.strError = e.getMessage();
                this.strResponse = strText;
            }
            ReplyObjectProcess replyObjectProcess = this;
            synchronized (replyObjectProcess) {
                this.notify();
            }
        }

        @Override
        public T getReplyObject() {
            return this.mT;
        }

        @Override
        public String getError() {
            return this.strError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyFailure(Throwable t) {
            this.exception = t;
            ReplyObjectProcess replyObjectProcess = this;
            synchronized (replyObjectProcess) {
                this.notify();
            }
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }

        @Override
        public String getResponse() {
            return this.strResponse;
        }
    }

    private static interface IReplyObjectProcess<T> {
        public void processTextToObject(String var1);

        public T getReplyObject();

        public String getError();

        public void notifyFailure(Throwable var1);

        public Throwable getException();

        public String getResponse();
    }

    class ReplyBase {
        int id;
        String jsonrpc;

        ReplyBase() {
        }
    }

    class Reply<T> {
        String id;
        String jsonrpc;
        T result;
        WebsocketError error;

        Reply() {
        }
    }

    class Call {
        int id;
        String method;
        List<Object> params;

        Call() {
        }
    }

    class WebsocketError {
        int code;
        String message;
        Object data;

        WebsocketError() {
        }
    }
}

