/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.utils;

import com.github.chouheiwa.wallet.utils.TextUtils;
import java.math.BigDecimal;

public class CalculateUtils {
    public static double add(double var1, double var2) {
        return new BigDecimal(Double.toString(var1)).add(new BigDecimal(Double.toString(var2))).doubleValue();
    }

    public static double sub(double var1, double var2) {
        return new BigDecimal(Double.toString(var1)).subtract(new BigDecimal(Double.toString(var2))).doubleValue();
    }

    public static String sub(String var1, String var2) {
        return new BigDecimal(var1).subtract(new BigDecimal(var2)).toPlainString();
    }

    public static String mul(double var1, double var2) {
        return new BigDecimal(var1).multiply(new BigDecimal(var2)).toPlainString();
    }

    public static String mulScale(String var1, String var2, int scale) {
        return new BigDecimal(var1).multiply(new BigDecimal(var2)).setScale(scale, 0).toPlainString();
    }

    public static String mulScaleHALF_DOWN(String var1, String var2, int scale) {
        return new BigDecimal(var1).multiply(new BigDecimal(var2)).setScale(scale, 5).toPlainString();
    }

    public static String div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or ");
        }
        if (v2 == 0.0) {
            return "0";
        }
        return new BigDecimal(Double.toString(v1)).divide(new BigDecimal(Double.toString(v2)), scale, 4).toPlainString();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        return new BigDecimal(Double.toString(v)).divide(new BigDecimal("1"), scale, 4).doubleValue();
    }

    public static double roundUp(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        return new BigDecimal(Double.toString(v)).divide(new BigDecimal("1"), scale, 0).doubleValue();
    }

    public static int round(String v) {
        if (Double.parseDouble(v) == 0.0) {
            return 0;
        }
        if (TextUtils.isEmpty(v)) {
            return 0;
        }
        return new BigDecimal(v).setScale(0, 1).intValue();
    }

    public static String roundMarket(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        double dou = b.divide(one, scale, 4).doubleValue();
        BigDecimal bigDecimal = new BigDecimal(dou + "");
        return bigDecimal.toString();
    }

    public static double getDouble(String var) {
        return new BigDecimal(var).doubleValue();
    }
}

