/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.utils;

import com.github.chouheiwa.wallet.utils.TextUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Random;

public class NumberUtils {
    private static DecimalFormat decimalFormat0 = new DecimalFormat("#0");
    private static DecimalFormat decimalFormat1 = new DecimalFormat("#0.0");
    private static DecimalFormat decimalFormat2 = new DecimalFormat("#0.00");
    private static DecimalFormat decimalFormat5 = new DecimalFormat("#0.00000");
    private static DecimalFormat decimalFormat8 = new DecimalFormat("#0.00000000");

    public static boolean compareFloatAndInt(float f, int i) {
        Float aFloat = Float.valueOf(f);
        int i1 = aFloat.compareTo(Float.valueOf(i));
        return i1 == 0;
    }

    public static String formatDouble(double d) {
        String str = "";
        if (d >= 10000.0) {
            str = d / 10000.0 + "m";
            return str;
        }
        if (d >= 1000.0) {
            str = d / 1000.0 + "k";
            return str;
        }
        str = d + "";
        return str;
    }

    public static String formatNumber(String s) {
        String str = "";
        str = decimalFormat5.format(Double.parseDouble(s));
        return str;
    }

    public static String formatNumber1(String s) {
        String str = "";
        str = decimalFormat1.format(Double.parseDouble(s));
        return str;
    }

    public static String formatNumber0(String s) {
        String str = "";
        str = decimalFormat0.format(Double.parseDouble(s));
        return str;
    }

    public static String formatNumber2(String s) {
        String str = "";
        str = TextUtils.isEmpty(s) ? "0.00" : decimalFormat2.format(Double.parseDouble(s));
        return str;
    }

    public static String formatNumber8(String s) {
        String str = "";
        str = TextUtils.isEmpty(s) ? "0.00" : decimalFormat8.format(Double.parseDouble(s));
        return str;
    }

    public static String getStringRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    public static String getSHA256StrJava(String str) {
        String encodeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodeStr = NumberUtils.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodeStr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    public static String optString(String name, String fallback) {
        if (!TextUtils.isEmpty(name)) {
            return name;
        }
        return fallback;
    }
}

