/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.jutil.collection;

import java.util.Collection;
import java.util.LinkedList;

public class CollectionPartitioner {
    public static <T> Collection<Collection<T>> partition(Collection<T> ts, Check<T> check) {
        LinkedList<Collection<T>> partitions = new LinkedList<Collection<T>>();
        LinkedList<T> partition = new LinkedList<T>();
        for (T t : ts) {
            if (check.canBeAdded(partition, t)) {
                partition.add(t);
                continue;
            }
            partitions.add(partition);
            partition = new LinkedList();
            partition.add(t);
        }
        if (!partition.isEmpty()) {
            partitions.add(partition);
        }
        return partitions;
    }

    @FunctionalInterface
    public static interface Check<T> {
        public boolean canBeAdded(Collection<T> var1, T var2);
    }
}

