/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.jutil.converter;

import com.google.protobuf.Message;

public class ByteConverter {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static String toHex(byte[] bytes) {
        char[] hex = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            hex[i * 2] = HEX_ARRAY[b >>> 4];
            hex[i * 2 + 1] = HEX_ARRAY[b & 0xF];
        }
        return new String(hex);
    }

    public static String toSpacedHex(Message msg) {
        return ByteConverter.toSpacedHex(msg.toByteArray());
    }

    public static String toSpacedHex(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        if (bytes.length == 0) {
            return "0 bytes";
        }
        String hex = ByteConverter.toHex(bytes);
        StringBuilder sb = new StringBuilder(String.format("%3d byte(s): ", bytes.length));
        for (int i = 0; i < hex.length(); i += 2) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(hex, i, i + 2);
        }
        return sb.toString();
    }
}

