/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.jutil.protobuf;

import com.github.chrisgleissner.jutil.collection.FieldPartitioner;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Optional;

public class ProtobufFieldPartitioner {
    public static <M extends Message> Collection<M> partition(M msg, Descriptors.FieldDescriptor repeatedField, long maxMsgSizeInBytes) {
        Preconditions.checkNotNull(msg, (Object)"msg");
        Preconditions.checkArgument((boolean)repeatedField.isRepeated(), (String)"repeatedField needs to be repeated but was %s", (Object)repeatedField.getType());
        Preconditions.checkArgument((maxMsgSizeInBytes > 0L ? 1 : 0) != 0, (Object)"maxMsgSizeInBytes");
        FieldPartitioner.ObjectBuilder<Message> objectBuilder = () -> msg.toBuilder().clearField(repeatedField).build();
        FieldPartitioner.FieldAdder<Message, Object> fieldAdder = (m, f) -> {
            Message msgWithField = m.toBuilder().addRepeatedField(repeatedField, f).build();
            if ((long)msgWithField.getSerializedSize() <= maxMsgSizeInBytes || msgWithField.getRepeatedFieldCount(repeatedField) == 1) {
                return Optional.of(msgWithField);
            }
            return Optional.empty();
        };
        return FieldPartitioner.partition(objectBuilder, fieldAdder, (Collection)msg.getField(repeatedField));
    }
}

