/*
 * Decompiled with CFR 0.152.
 */
package com.github.ciweigg;

import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.BeetlTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.VelocityTemplateEngine;
import com.github.ciweigg.config.MpCodeGeneratorConfig;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class MpCodeGenerator {
    private static final String DEFAULT_PATH = "mp-code-generator-config.yaml";

    public static void main(String[] args) throws Exception {
        InputStream inputStream = args.length > 0 && !StringUtils.isEmpty((CharSequence)args[0]) ? new FileInputStream(args[0]) : MpCodeGenerator.class.getClassLoader().getResourceAsStream(DEFAULT_PATH);
        MpCodeGeneratorConfig config = MpCodeGenerator.yaml2Config(inputStream);
        AutoGenerator mpg = MpCodeGenerator.configureAutoGenerator(config);
        mpg.execute();
    }

    private static MpCodeGeneratorConfig yaml2Config(InputStream inputStream) {
        Yaml yaml = new Yaml();
        yaml.setBeanAccess(BeanAccess.FIELD);
        return (MpCodeGeneratorConfig)yaml.loadAs(inputStream, MpCodeGeneratorConfig.class);
    }

    private static AutoGenerator configureAutoGenerator(MpCodeGeneratorConfig config) {
        AutoGenerator mpg = new AutoGenerator();
        mpg.setGlobalConfig(config.getGlobalConfig());
        mpg.setDataSource(config.getDataSourceConfig());
        mpg.setPackageInfo(config.getPackageConfig());
        mpg.setTemplate(config.getTemplateConfig());
        mpg.setStrategy(config.getStrategyConfig());
        if (config.isUseftl()) {
            mpg.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        } else if (config.isUsebtl()) {
            mpg.setTemplateEngine((AbstractTemplateEngine)new BeetlTemplateEngine());
        } else {
            mpg.setTemplateEngine((AbstractTemplateEngine)new VelocityTemplateEngine());
        }
        return mpg;
    }
}

