/*
 * Decompiled with CFR 0.152.
 */
package com.onestop.starter.common.redis.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.onestop.starter.common.redis.config.OsRedisProperties;
import com.onestop.starter.common.redis.util.OsRedisUtils;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableConfigurationProperties(value={OsRedisProperties.class})
@ConditionalOnProperty(prefix="os.redis", name={"enabled"}, havingValue="true")
public class OsRedisAutoConfiguration {
    @Autowired
    private OsRedisProperties properties;

    @Bean
    public LettuceConnectionFactory lettuceConnectionFactory() {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        if (this.properties != null && this.properties.getLettuce() != null && this.properties.getLettuce().getPool() != null) {
            genericObjectPoolConfig.setMaxIdle(this.properties.getLettuce().getPool().getMaxIdle());
            genericObjectPoolConfig.setMinIdle(this.properties.getLettuce().getPool().getMinIdle());
            genericObjectPoolConfig.setMaxTotal(this.properties.getLettuce().getPool().getMaxActive());
            genericObjectPoolConfig.setMaxWaitMillis(this.properties.getLettuce().getPool().getMaxWait());
        }
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(100L);
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(this.properties.getHost());
        redisStandaloneConfiguration.setPort(this.properties.getPort().intValue());
        redisStandaloneConfiguration.setPassword(RedisPassword.of((String)this.properties.getPassword()));
        redisStandaloneConfiguration.setDatabase(this.properties.getDatabase().intValue());
        LettucePoolingClientConfiguration clientConfig = LettucePoolingClientConfiguration.builder().commandTimeout(Duration.ofMillis(this.properties.getTimeout())).shutdownTimeout(Duration.ofMillis(this.properties.getLettuce().getShutdownTimeout())).poolConfig(genericObjectPoolConfig).build();
        LettuceConnectionFactory factory = new LettuceConnectionFactory(redisStandaloneConfiguration, (LettuceClientConfiguration)clientConfig);
        return factory;
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(LettuceConnectionFactory factory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)factory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    @ConditionalOnMissingBean
    public OsRedisUtils osRedisUtils() {
        OsRedisUtils utils = new OsRedisUtils();
        return utils;
    }
}

