/*
 * Decompiled with CFR 0.152.
 */
package cf.dropsonde.spring.boot;

import cf.dropsonde.metron.MetronClient;
import cf.dropsonde.metron.MetronClientBuilder;
import cf.dropsonde.spring.boot.MetronClientProperties;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@EnableConfigurationProperties(value={MetronClientProperties.class})
public class MetronClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MetronClient metronClient(MetronClientProperties properties) {
        return MetronClientBuilder.create((String)properties.getOrigin()).metronAgent(new InetSocketAddress(properties.getMetronAgentHost(), properties.getMetronAgentPort())).eventLoopGroup(this.metronEventLoopGroup(), NioDatagramChannel.class).build();
    }

    @Bean(destroyMethod="shutdownGracefully")
    @Lazy
    @Qualifier(value="cf.dropsonde")
    EventLoopGroup metronEventLoopGroup() {
        return new NioEventLoopGroup();
    }
}

