/*
 * Decompiled with CFR 0.152.
 */
package com.github.code2358.javacard.jcdk;

import com.github.code2358.javacard.jcdk.InitializationException;
import com.github.code2358.javacard.jcdk.JcdkInstallation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public final class Jcdk3Installation
implements JcdkInstallation {
    private static final String API_EXPORTS = "/api_export_files";
    private static final String TOOLS_JAR = "/lib/tools.jar";
    private final Path jcdk3Home;

    public Jcdk3Installation(Path jcdkPath) throws InitializationException {
        Objects.requireNonNull(jcdkPath);
        this.jcdk3Home = jcdkPath;
    }

    @Override
    public boolean isJcdkAvailable() {
        return Files.isReadable(this.getApiExportPath()) && Files.isReadable(this.getConverterClasspath());
    }

    @Override
    public Path getBasePath() {
        return this.jcdk3Home;
    }

    @Override
    public Path getApiExportPath() {
        return this.getPath(API_EXPORTS);
    }

    @Override
    public Path getConverterClasspath() {
        return this.getPath(TOOLS_JAR);
    }

    @Override
    public String getConverterClass() {
        return "com.sun.javacard.converter.Main";
    }

    private Path getPath(String subPath) {
        return Paths.get(this.jcdk3Home.toString(), subPath);
    }
}

