/*
 * Decompiled with CFR 0.152.
 */
package com.github.code2358.javacard.jcdk;

import com.github.code2358.javacard.jcdk.ConvertionException;
import com.github.code2358.javacard.jcdk.InitializationException;
import com.github.code2358.javacard.jcdk.JcdkInstallation;
import com.github.code2358.javacard.jcdk.JcdkWrapper;
import com.github.code2358.javacard.jcdk.utils.CommandLine;
import com.github.code2358.javacard.jcdk.utils.StringJoiner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;

public final class JcdkWrapperImpl
implements JcdkWrapper {
    private final JcdkInstallation jcdkInstallation;
    private final Path configurationFile;
    private ByteArrayOutputStream jcdkOutput;

    public JcdkWrapperImpl(JcdkInstallation jcdkInstallation, Path configurationFile) throws InitializationException {
        Objects.requireNonNull(jcdkInstallation);
        Objects.requireNonNull(configurationFile);
        this.jcdkInstallation = jcdkInstallation;
        this.configurationFile = configurationFile;
    }

    @Override
    public final void convert() throws ConvertionException {
        try {
            this.jcdkOutput = new ByteArrayOutputStream();
            int result = CommandLine.execute(JcdkWrapperImpl.generateCommand(this.jcdkInstallation, this.configurationFile), this.jcdkOutput);
            if (result != 0) {
                throw new ConvertionException("Error during execution of JCDK converter (see output for details).");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new ConvertionException(e.getMessage(), e);
        }
    }

    public String getJcdkOutput() throws UnsupportedEncodingException {
        if (this.jcdkOutput != null) {
            return this.jcdkOutput.toString("UTF-8");
        }
        return null;
    }

    protected static String generateCommand(JcdkInstallation jcdkInstallation, Path configurationFile) {
        if (!jcdkInstallation.isJcdkAvailable()) {
            throw new RuntimeException("Provided JCDK path is not valid: " + jcdkInstallation.getBasePath().toString());
        }
        if (!Files.isReadable(configurationFile)) {
            throw new RuntimeException("Provided configuration path is not valid: " + configurationFile.toString());
        }
        StringJoiner commandString = new StringJoiner(" ");
        commandString.add("java");
        commandString.add("-cp");
        commandString.add(jcdkInstallation.getConverterClasspath().toString());
        commandString.add("-Djc.home=" + jcdkInstallation.getBasePath().toString());
        commandString.add(jcdkInstallation.getConverterClass());
        commandString.add("-config");
        commandString.add(configurationFile.toString());
        return commandString.toString();
    }
}

