/*
 * Decompiled with CFR 0.152.
 */
package com.github.code2358.javacard.jcdk.config;

import com.github.code2358.javacard.jcdk.ConfigurationException;
import com.github.code2358.javacard.jcdk.JcdkInstallation;
import com.github.code2358.javacard.jcdk.config.AppletClass;
import com.github.code2358.javacard.jcdk.config.AppletId;
import com.github.code2358.javacard.jcdk.config.AppletVersion;
import com.github.code2358.javacard.jcdk.utils.StringJoiner;
import java.nio.file.Path;
import java.util.Objects;

public final class JcdkConfigurationBuilder {
    private JcdkInstallation jcdkInstallation;
    private Path classDirectory;
    private Path outputDirectory;
    private AppletId appletId;
    private AppletClass appletClass;
    private AppletVersion appletVersion;
    boolean supportInt32 = false;

    public JcdkConfigurationBuilder jcdkInstallation(JcdkInstallation jcdkInstallation) {
        this.jcdkInstallation = Objects.requireNonNull(jcdkInstallation);
        return this;
    }

    public JcdkConfigurationBuilder classDirectory(Path classDirectory) {
        this.classDirectory = Objects.requireNonNull(classDirectory);
        return this;
    }

    public JcdkConfigurationBuilder outputDirectory(Path outputDirectory) {
        this.outputDirectory = Objects.requireNonNull(outputDirectory);
        return this;
    }

    public JcdkConfigurationBuilder appletId(String appletId) {
        Objects.requireNonNull(appletId);
        this.appletId = new AppletId(appletId);
        return this;
    }

    public JcdkConfigurationBuilder appletClass(String appletClass) {
        Objects.requireNonNull(appletClass);
        this.appletClass = new AppletClass(appletClass);
        return this;
    }

    public JcdkConfigurationBuilder appletVersion(String appletVersion) {
        Objects.requireNonNull(appletVersion);
        this.appletVersion = new AppletVersion(appletVersion);
        return this;
    }

    public JcdkConfigurationBuilder supportInt32() {
        this.supportInt32 = true;
        return this;
    }

    public String build() throws ConfigurationException {
        this.ensureThatRequiredParametersAvailable();
        StringJoiner commandString = new StringJoiner(" ");
        commandString.add("-classdir");
        commandString.add(this.classDirectory.toString());
        if (this.supportInt32) {
            commandString.add("-i");
        }
        commandString.add("-exportpath");
        commandString.add(this.jcdkInstallation.getApiExportPath().toString());
        commandString.add("-applet");
        commandString.add(JcdkConfigurationBuilder.formatAsAid(this.appletId.toString()));
        commandString.add(this.appletClass.toString());
        commandString.add("-d");
        commandString.add(this.outputDirectory.toString());
        commandString.add("-out");
        commandString.add("CAP");
        commandString.add("EXP");
        commandString.add("JCA");
        commandString.add("-v");
        commandString.add(this.appletClass.getPackage());
        commandString.add(JcdkConfigurationBuilder.formatAsAid(this.appletId.getPackageId()));
        commandString.add(this.appletVersion.toString());
        return commandString.toString();
    }

    private static String formatAsAid(String id) {
        return "0x" + id.replaceAll(":", ":0x");
    }

    private void ensureThatRequiredParametersAvailable() throws ConfigurationException {
        if (this.jcdkInstallation == null) {
            throw new ConfigurationException("Missing parameter jcdkInstallation");
        }
        if (this.classDirectory == null) {
            throw new ConfigurationException("Missing parameter classDirectory");
        }
        if (this.outputDirectory == null) {
            throw new ConfigurationException("Missing parameter outputDirectory");
        }
        if (this.appletId == null) {
            throw new ConfigurationException("Missing parameter appletId");
        }
        if (this.appletClass == null) {
            throw new ConfigurationException("Missing parameter appletClass");
        }
        if (this.appletVersion == null) {
            throw new ConfigurationException("Missing parameter appletVersion");
        }
    }
}

