/*
 * Decompiled with CFR 0.152.
 */
package com.github.code2358.javacard.jcdk;

import com.github.code2358.javacard.jcdk.JcdkInstallation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public final class Jcdk2Installation
implements JcdkInstallation {
    private static final String API_EXPORTS = "/api_export_files";
    private static final String CONVERTER_JAR = "/lib/converter.jar";
    private static final String LIBS = "/lib/*";
    private final Path jcdk2Home;

    public Jcdk2Installation(Path jcdkPath) {
        Objects.requireNonNull(jcdkPath);
        this.jcdk2Home = jcdkPath;
    }

    @Override
    public boolean isJcdkAvailable() {
        return Files.isReadable(this.getApiExportPath()) && Files.isReadable(this.getPath(CONVERTER_JAR));
    }

    @Override
    public Path getBasePath() {
        return this.jcdk2Home;
    }

    @Override
    public Path getApiExportPath() {
        return this.getPath(API_EXPORTS);
    }

    @Override
    public Path getConverterClasspath() {
        return this.getPath(LIBS);
    }

    @Override
    public String getConverterClass() {
        return "com.sun.javacard.converter.Converter";
    }

    private Path getPath(String subPath) {
        return Paths.get(this.jcdk2Home.toString(), subPath);
    }
}

