/*
 * Decompiled with CFR 0.152.
 */
package com.github.code2358.javacard.jcdk;

import com.github.code2358.javacard.jcdk.InitializationException;
import com.github.code2358.javacard.jcdk.Jcdk2Installation;
import com.github.code2358.javacard.jcdk.Jcdk3Installation;
import com.github.code2358.javacard.jcdk.JcdkInstallation;
import java.nio.file.Path;

public final class JcdkInstallationFactory {
    private JcdkInstallationFactory() {
    }

    public static JcdkInstallation getInstance(String jcdkVersion, Path jcdkHome) throws InitializationException {
        JcdkInstallation jcdkInstallation;
        if ("3.0.x".equals(jcdkVersion)) {
            jcdkInstallation = new Jcdk3Installation(jcdkHome);
        } else if ("2.2.x".equals(jcdkVersion)) {
            jcdkInstallation = new Jcdk2Installation(jcdkHome);
        } else {
            throw new InitializationException("Invalid JCDK version. Supported parameters: 3.0.x, 2.2.x");
        }
        if (!jcdkInstallation.isJcdkAvailable()) {
            throw new InitializationException("Provided JCDK path is invalid or does not match provided JCDK version.");
        }
        return jcdkInstallation;
    }
}

